/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.impl.doubles;

import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;
import org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.AbstractPrimitiveWriters;
import org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.RepeatedPrimitiveWriteSchemas;

public class DoublePackedWriteSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor) {
        return RepeatedPrimitiveWriteSchemas.create(protoField, propertyDescriptor, new DoublePackedWriters(protoField));
    }

    private static class DoublePackedWriters
    extends AbstractPrimitiveWriters<double[], Double> {
        public DoublePackedWriters(Field protoField) {
            super(protoField);
            this.primitiveArrayWriter = (o, value) -> o.writeObject(this.tag, this.tagSize, value, (output, array) -> {
                for (double element : array) {
                    output.writePackedDouble(element);
                }
            });
            this.arrayWriter = (o, value) -> o.writeObject(this.tag, this.tagSize, value, (output, array) -> {
                for (Double element : array) {
                    if (element != null) {
                        output.writePackedDouble(element);
                        continue;
                    }
                    ProtoUtils.throwNotSupportNullElement(protoField);
                }
            });
            this.collectionWriter = (o, value) -> o.writeObject(this.tag, this.tagSize, value, (output, collection) -> {
                for (Double element : collection) {
                    if (element != null) {
                        output.writePackedDouble(element);
                        continue;
                    }
                    ProtoUtils.throwNotSupportNullElement(protoField);
                }
            });
            this.stringArrayWriter = (o, value) -> o.writeObject(this.tag, this.tagSize, value, (output, array) -> {
                for (String element : array) {
                    if (element != null) {
                        double parsedValue = Double.parseDouble(element);
                        output.writePackedDouble(parsedValue);
                        continue;
                    }
                    ProtoUtils.throwNotSupportNullElement(protoField);
                }
            });
        }
    }
}

