/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PrepareAst;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.util.Set;

public class GenerateRoyaleExports
extends NodeTraversal.AbstractPostOrderCallback {
    private final AbstractCompiler compiler;
    private Set<String> extraSymbolNamesToExport;

    public GenerateRoyaleExports(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    public void process(Node externs, Node root, Set<String> extraSymbolNamesToExport) {
        this.extraSymbolNamesToExport = extraSymbolNamesToExport;
        NodeTraversal.traverse((AbstractCompiler)this.compiler, (Node)root, (NodeTraversal.Callback)this);
    }

    public void visit(NodeTraversal t, Node n, Node parent) {
        JSDocInfo docInfo = n.getJSDocInfo();
        if (docInfo == null || docInfo.isExport()) {
            return;
        }
        switch (n.getToken()) {
            case STRING_KEY: {
                Node parentNode = n.getParent();
                if (parentNode == null) {
                    return;
                }
                Node gpNode = parentNode.getParent();
                if (gpNode == null || gpNode.getToken() != Token.CALL) {
                    return;
                }
                Node objNode = gpNode.getChildAtIndex(1);
                if (!objNode.isQualifiedName()) {
                    return;
                }
                String accessorQualifiedName = objNode.getQualifiedName() + "." + n.getString();
                if (!this.extraSymbolNamesToExport.contains(accessorQualifiedName)) {
                    return;
                }
                this.addExtern(n.getString());
                return;
            }
            case GETPROP: {
                String qualifiedName = n.getQualifiedName();
                if (!qualifiedName.startsWith("this.$ID_")) {
                    return;
                }
                Node gp = n.getGrandparent();
                if (gp == null) {
                    return;
                }
                Node ggp = gp.getParent();
                if (ggp == null || !ggp.isFunction()) {
                    return;
                }
                this.addExtern(n.getOriginalName());
                return;
            }
            case ASSIGN: {
                Node firstChild = n.getFirstChild();
                if (!firstChild.isQualifiedName()) {
                    return;
                }
                String qualifiedName = firstChild.getQualifiedName();
                if (!this.extraSymbolNamesToExport.contains(qualifiedName)) {
                    return;
                }
                Node parentNode = n.getParent();
                if (parentNode == null) {
                    return;
                }
                Node gpNode = parentNode.getParent();
                if (gpNode == null || !gpNode.isScript()) {
                    return;
                }
                this.addExportSymbolCall(qualifiedName, n);
                return;
            }
        }
    }

    private void addExtern(String export) {
        Node objectPrototype = NodeUtil.newQName((AbstractCompiler)this.compiler, (String)"Object.prototype");
        JSType objCtor = this.compiler.getTypeRegistry().getNativeType(JSTypeNative.OBJECT_FUNCTION_TYPE);
        objectPrototype.getFirstChild().setJSType(objCtor);
        Node propstmt = IR.exprResult((Node)IR.getprop((Node)objectPrototype, (Node)IR.string((String)export)));
        propstmt.useSourceInfoFromForTree(this.getSynthesizedExternsRoot());
        propstmt.setOriginalName(export);
        this.getSynthesizedExternsRoot().addChildToBack(propstmt);
        this.compiler.reportChangeToEnclosingScope(propstmt);
    }

    private Node getSynthesizedExternsRoot() {
        return this.compiler.getSynthesizedExternsInput().getAstRoot(this.compiler);
    }

    private void addExportSymbolCall(String export, Node context) {
        Node call = IR.call((Node)NodeUtil.newQName((AbstractCompiler)this.compiler, (String)this.compiler.getCodingConvention().getExportSymbolFunction(), (Node)context, (String)export), (Node[])new Node[]{IR.string((String)export), NodeUtil.newQName((AbstractCompiler)this.compiler, (String)export, (Node)context, (String)export)});
        Node expression = IR.exprResult((Node)call).useSourceInfoIfMissingFromForTree(context);
        this.annotate(expression);
        this.addStatement(context, expression);
    }

    private void addStatement(Node context, Node stmt) {
        Node next;
        Node n;
        CodingConvention convention = this.compiler.getCodingConvention();
        Node exprRoot = n = context;
        while (!NodeUtil.isStatementBlock((Node)exprRoot.getParent())) {
            exprRoot = exprRoot.getParent();
        }
        while ((next = exprRoot.getNext()) != null && NodeUtil.isExprCall((Node)next) && convention.getClassesDefinedByCall(next.getFirstChild()) != null) {
            exprRoot = next;
        }
        Node block = exprRoot.getParent();
        block.addChildAfter(stmt, exprRoot);
        this.compiler.reportChangeToEnclosingScope(stmt);
    }

    private void annotate(Node node) {
        NodeTraversal.traverse((AbstractCompiler)this.compiler, (Node)node, (NodeTraversal.Callback)new PrepareAst.PrepareAnnotations());
    }
}

