/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.tools.debugger.NoResponseException;
import flash.tools.debugger.Session;
import flash.tools.debugger.SourceFile;
import flash.tools.debugger.SourceLocator;
import flash.tools.debugger.VersionException;
import flash.tools.debugger.concrete.PlayerSession;
import flash.tools.debugger.concrete.PlayerSessionManager;
import flash.tools.debugger.concrete.ScriptText;
import flash.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DModule
implements SourceFile {
    private ScriptText m_script;
    private boolean m_gotRealScript;
    private final String m_rawName;
    private final String m_shortName;
    private final String m_path;
    private final String m_basePath;
    private final int m_id;
    private final int m_bitmap;
    private final ArrayList<Integer> m_line2Offset;
    private final ArrayList<Object> m_line2Func;
    private final HashMap<String, Integer> m_func2FirstLine;
    private final HashMap<String, Integer> m_func2LastLine;
    private String m_packageName;
    private boolean m_gotAllFncNames;
    private int m_anonymousFunctionCounter = 0;
    private SourceLocator m_sourceLocator;
    private int m_sourceLocatorChangeCount;
    private int m_isolateId;
    private static final String m_newline = System.getProperty("line.separator");
    private static final Pattern sXMLDeclarationPattern = Pattern.compile("^<\\?xml[^>]*encoding\\s*=\\s*(\"([^\"]*)\"|'([^']*)')");

    public DModule(SourceLocator sourceLocator, int n, int n2, String string, String string2, int n3) {
        if (string2 != null && string2.length() > 0) {
            this.m_script = new ScriptText(string2);
            this.m_gotRealScript = true;
        }
        NameParser nameParser = new NameParser(string);
        this.m_sourceLocator = sourceLocator;
        this.m_rawName = string;
        this.m_basePath = nameParser.getBasePath();
        this.m_bitmap = n2;
        this.m_id = n;
        this.m_shortName = DModule.generateShortName(nameParser);
        this.m_path = DModule.generatePath(nameParser);
        this.m_line2Offset = new ArrayList();
        this.m_line2Func = new ArrayList();
        this.m_func2FirstLine = new HashMap();
        this.m_func2LastLine = new HashMap();
        this.m_packageName = nameParser.getPackage();
        this.m_gotAllFncNames = false;
        this.m_isolateId = n3;
    }

    public synchronized ScriptText getScript() {
        if (!this.m_gotRealScript && this.m_sourceLocator != null && this.m_sourceLocator.getChangeCount() != this.m_sourceLocatorChangeCount) {
            this.m_script = null;
        }
        if (this.m_script == null) {
            String string = this.scriptFromDisk(this.getRawName());
            if (string == null) {
                string = "";
            } else {
                this.m_gotRealScript = true;
            }
            this.m_script = new ScriptText(string);
        }
        return this.m_script;
    }

    @Override
    public String getBasePath() {
        return this.m_basePath;
    }

    @Override
    public String getName() {
        return this.m_shortName;
    }

    @Override
    public String getFullPath() {
        return this.m_path;
    }

    @Override
    public String getPackageName() {
        return this.m_packageName == null ? "" : this.m_packageName;
    }

    @Override
    public String getRawName() {
        return this.m_rawName;
    }

    @Override
    public int getId() {
        return this.m_id;
    }

    public int getBitmap() {
        return this.m_bitmap;
    }

    @Override
    public int getLineCount() {
        return this.getScript().getLineCount();
    }

    @Override
    public String getLine(int n) {
        return n > this.getLineCount() ? "// code goes here" : this.getScript().getLine(n);
    }

    void setPackageName(String string) {
        this.m_packageName = string;
    }

    @Override
    public int getOffsetForLine(int n) {
        Integer n2;
        int n3 = 0;
        if (n < this.m_line2Offset.size() && (n2 = this.m_line2Offset.get(n)) != null) {
            n3 = n2;
        }
        return n3;
    }

    @Override
    public int getLineForFunctionName(Session session, String string) {
        int n = -1;
        this.primeAllFncNames(session);
        Integer n2 = this.m_func2FirstLine.get(string);
        if (n2 != null) {
            n = n2;
        }
        return n;
    }

    @Override
    public String getFunctionNameForLine(Session session, int n) {
        this.primeFncName(session, n);
        String[] stringArray = this.getFunctionNamesForLine(session, n);
        if (stringArray != null && stringArray.length == 1) {
            return stringArray[0];
        }
        return null;
    }

    private String[] getFunctionNamesForLine(Session session, int n) {
        this.primeFncName(session, n);
        if (n < this.m_line2Func.size()) {
            Object object = this.m_line2Func.get(n);
            if (object instanceof String) {
                return new String[]{(String)object};
            }
            if (object instanceof String[]) {
                return (String[])object;
            }
        }
        return new String[0];
    }

    @Override
    public String[] getFunctionNames(Session session) {
        this.primeAllFncNames(session);
        int n = this.m_func2FirstLine.size();
        return this.m_func2FirstLine.keySet().toArray(new String[n]);
    }

    private static String generateShortName(NameParser nameParser) {
        String string;
        String string2 = string = nameParser.getOriginalName();
        if (nameParser.isPathPackageAndFilename()) {
            string2 = nameParser.getFilename();
        } else {
            int n = string.lastIndexOf(46);
            if (n > 1) {
                int n2 = string.lastIndexOf(92, n);
                n2 = Math.max(n2, string.lastIndexOf(47, n));
                string2 = string.substring(n2 + 1);
            } else {
                string2 = string;
            }
        }
        return string2.trim();
    }

    private static String generatePath(NameParser nameParser) {
        String string;
        String string2 = string = nameParser.getOriginalName();
        int n = string.indexOf(58);
        if (n > 1 && !string.startsWith("Actions for")) {
            if (string.charAt(n + 1) == ' ') {
                string2 = string.substring(n + 2);
            }
        } else {
            string2 = string.indexOf(46) > -1 && string.charAt(0) != '<' ? nameParser.recombine() : "";
        }
        return string2.trim();
    }

    public void lineMapping(StringBuilder stringBuilder) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("fileName", this.getName());
        hashMap.put("fileNumber", Integer.toString(this.getId()));
        stringBuilder.append(PlayerSessionManager.getLocalizationManager().getLocalizedTextString("functionsInFile", hashMap));
        stringBuilder.append(m_newline);
        String[] stringArray = this.m_func2FirstLine.keySet().toArray(new String[this.m_func2FirstLine.size()]);
        Arrays.sort(stringArray, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                int n = (Integer)DModule.this.m_func2FirstLine.get(string);
                int n2 = (Integer)DModule.this.m_func2FirstLine.get(string2);
                return n - n2;
            }
        });
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n = this.m_func2FirstLine.get(string);
            int n2 = this.m_func2LastLine.get(string);
            stringBuilder.append(" ");
            stringBuilder.append(string);
            stringBuilder.append(" ");
            stringBuilder.append(n);
            stringBuilder.append(" ");
            stringBuilder.append(n2);
            stringBuilder.append(m_newline);
        }
    }

    int compareTo(DModule dModule) {
        return this.getName().compareTo(dModule.getName());
    }

    void primeFncName(Session session, int n) {
        this.primeAllFncNames(session);
    }

    void primeAllFncNames(Session session) {
        PlayerSession playerSession = (PlayerSession)session;
        if (!this.m_gotAllFncNames && playerSession.playerVersion() >= 9) {
            try {
                playerSession.requestFunctionNames(this.m_id, -1, this.m_isolateId);
            }
            catch (VersionException versionException) {
            }
            catch (NoResponseException noResponseException) {
                // empty catch block
            }
        }
        this.m_gotAllFncNames = true;
    }

    void addLineFunctionInfo(int n, int n2, String string) {
        this.addLineFunctionInfo(n, n2, n2, string);
    }

    void addLineFunctionInfo(int n, int n2, int n3, String string) {
        if (string == null || string.length() == 0) {
            string = "<anonymous$" + ++this.m_anonymousFunctionCounter + ">";
        } else {
            int n4;
            int n5 = string.lastIndexOf(58);
            int n6 = string.lastIndexOf(47);
            if (n5 > -1 || n6 > -1) {
                n4 = Math.max(n5, n6);
                string = string.substring(n4 + 1);
            } else {
                n4 = string.lastIndexOf(46);
                if (n4 > -1) {
                    String string2 = string.substring(0, n4);
                    string = string.substring(n4 + 1);
                    this.setPackageName(string2);
                }
            }
        }
        this.m_line2Offset.ensureCapacity(n2 + 1);
        while (n2 >= this.m_line2Offset.size()) {
            this.m_line2Offset.add(null);
        }
        this.m_line2Offset.set(n2, new Integer(n));
        this.m_line2Func.ensureCapacity(n3 + 1);
        while (n3 >= this.m_line2Func.size()) {
            this.m_line2Func.add(null);
        }
        for (int i = n2; i <= n3; ++i) {
            Object object = this.m_line2Func.get(i);
            if (object == null) {
                this.m_line2Func.set(i, string);
                continue;
            }
            if (object instanceof String) {
                String string3 = (String)object;
                this.m_line2Func.set(i, new String[]{string3, string});
                continue;
            }
            if (!(object instanceof String[])) continue;
            String[] stringArray = (String[])object;
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray2.length - 1] = string;
            this.m_line2Func.set(i, stringArray2);
        }
        if (this.m_func2FirstLine.get(string) == null) {
            this.m_func2FirstLine.put(string, new Integer(n2));
            this.m_func2LastLine.put(string, new Integer(n3));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String scriptFromDisk(String string) {
        String string2;
        block26: {
            int n;
            string = string.replace('\\', '/');
            String string3 = "";
            String string4 = "";
            String string5 = "";
            int n2 = string.indexOf(59);
            if (n2 > -1) {
                n = string.indexOf(59, n2 + 1);
                if (n > -1) {
                    string4 = string.substring(0, n2);
                    string3 = string.substring(n2 + 1, n);
                    string5 = string.substring(n + 1);
                } else {
                    string4 = string.substring(0, n2);
                    string5 = string.substring(n2 + 1);
                }
            } else {
                n2 = string.lastIndexOf(47);
                if (n2 > -1) {
                    n = string.lastIndexOf("/mx/");
                    if (n > -1) {
                        string4 = string.substring(0, n);
                        string3 = string.substring(n + 1, n2);
                    } else {
                        string4 = string.substring(0, n2);
                    }
                    string5 = string.substring(n2 + 1);
                } else {
                    string4 = ".";
                    string5 = string;
                }
            }
            string2 = null;
            try {
                BufferedInputStream bufferedInputStream;
                Charset charset = null;
                Charset charset2 = null;
                InputStream inputStream = this.locateScriptFile(string4, string3, string5);
                if (inputStream != null) {
                    try {
                        bufferedInputStream = new BufferedInputStream(inputStream);
                        charset2 = this.getEncodingFromBOM(bufferedInputStream);
                        string2 = this.pullInSource(bufferedInputStream, charset2);
                        charset = this.getEncodingFromXMLDirective(string2);
                    }
                    finally {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                if (charset == null || charset.equals(charset2) || (inputStream = this.locateScriptFile(string4, string3, string5)) == null) break block26;
                try {
                    bufferedInputStream = new BufferedInputStream(inputStream);
                    this.getEncodingFromBOM(bufferedInputStream);
                    string2 = this.pullInSource(bufferedInputStream, charset);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
        return string2;
    }

    InputStream locateScriptFile(String string, String string2, String string3) throws FileNotFoundException {
        Object object;
        if (this.m_sourceLocator != null) {
            this.m_sourceLocatorChangeCount = this.m_sourceLocator.getChangeCount();
            object = this.m_sourceLocator.locateSource(string, string2, string3);
            if (object != null) {
                return object;
            }
        }
        string = string.replace('/', File.separatorChar);
        string2 = string2.replace('/', File.separatorChar);
        if (string.length() > 0) {
            try {
                String string4 = "";
                if (string2.length() > 0) {
                    string4 = string4 + string2 + File.separatorChar;
                }
                if (((File)(object = new File(string, string4 = string4 + string3))).exists()) {
                    return new FileInputStream((File)object);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (string2.length() > 0 && ((File)(object = new File(string2, string3))).exists()) {
            return new FileInputStream((File)object);
        }
        object = new File(string3);
        if (((File)object).exists()) {
            return new FileInputStream((File)object);
        }
        return null;
    }

    private Charset getEncodingFromBOM(BufferedInputStream bufferedInputStream) {
        String string;
        Charset charset = null;
        bufferedInputStream.mark(3);
        try {
            string = FileUtils.consumeBOM(bufferedInputStream, null);
        }
        catch (IOException iOException) {
            string = System.getProperty("file.encoding");
        }
        charset = Charset.forName(string);
        return charset;
    }

    private Charset getEncodingFromXMLDirective(String string) {
        String string2 = null;
        Matcher matcher = sXMLDeclarationPattern.matcher(string);
        if (matcher.find()) {
            string2 = matcher.group(2);
            if (string2 == null) {
                string2 = matcher.group(3);
            }
            try {
                return Charset.forName(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    String pullInSource(InputStream inputStream, Charset charset) {
        String string = "";
        BufferedReader bufferedReader = null;
        try {
            String string2;
            StringBuilder stringBuilder = new StringBuilder();
            InputStreamReader inputStreamReader = null;
            inputStreamReader = charset == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, charset);
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
                stringBuilder.append('\n');
            }
            string = stringBuilder.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }

    public String toString() {
        return this.getFullPath();
    }

    private static class NameParser {
        private String fOriginalName;
        private String fBasePath;
        private String fPackage;
        private String fFilename;
        private String fRecombinedName;

        public NameParser(String string) {
            this.fOriginalName = string;
            int n = 0;
            int n2 = 0;
            int n3 = -1;
            int n4 = -1;
            while ((n2 = string.indexOf(59, n2)) >= 0) {
                ++n;
                if (n3 == -1) {
                    n3 = n2;
                }
                n4 = n2++;
            }
            if (n == 2) {
                this.fBasePath = string.substring(0, n3);
                this.fPackage = string.substring(n3 + 1, n4);
                this.fFilename = string.substring(n4 + 1);
            }
        }

        public boolean isPathPackageAndFilename() {
            return this.fBasePath != null;
        }

        public String getOriginalName() {
            return this.fOriginalName;
        }

        public String getBasePath() {
            return this.fBasePath;
        }

        public String getFilename() {
            return this.fFilename;
        }

        public String getPackage() {
            return this.fPackage;
        }

        public String recombine() {
            if (this.fRecombinedName == null) {
                if (this.isPathPackageAndFilename()) {
                    char c = this.fOriginalName.indexOf(92) != -1 ? (char)'\\' : '/';
                    this.fRecombinedName = this.fOriginalName.replaceAll(";;", ";").replace(';', c);
                } else {
                    this.fRecombinedName = this.fOriginalName;
                }
            }
            return this.fRecombinedName;
        }
    }
}

