/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.util;

import flash.localization.LocalizationManager;
import flex2.compiler.ILocalizableMessage;
import flex2.compiler.Logger;
import flex2.compiler.Source;
import flex2.compiler.common.PathResolver;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.util.Benchmark;
import flex2.compiler.util.CompilerControl;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.MimeMappings;
import flex2.tools.oem.ProgressMeter;
import java.util.HashMap;
import java.util.Map;

public final class ThreadLocalToolkit {
    private static ThreadLocal<Logger> logger = new ThreadLocal();
    private static ThreadLocal<PathResolver> resolver = new ThreadLocal();
    private static ThreadLocal<Map<String, VirtualFile>> resolved = new ThreadLocal();
    private static ThreadLocal<Benchmark> stopWatch = new ThreadLocal();
    private static ThreadLocal<LocalizationManager> localization = new ThreadLocal();
    private static ThreadLocal<MimeMappings> mimeMappings = new ThreadLocal();
    private static ThreadLocal<ProgressMeter> progressMeter = new ThreadLocal();
    private static ThreadLocal<CompilerControl> compilerControl = new ThreadLocal();
    private static ThreadLocal<StandardDefs> standardDefs = new ThreadLocal();
    private static ThreadLocal<Integer> compatibilityVersion = new ThreadLocal();

    public static LocalizationManager getLocalizationManager() {
        return localization.get();
    }

    public static void setLocalizationManager(LocalizationManager mgr) {
        localization.set(mgr);
    }

    public static void setPathResolver(PathResolver r) {
        resolver.set(r);
    }

    public static void resetResolvedPaths() {
        resolved.set(null);
    }

    public static PathResolver getPathResolver() {
        return resolver.get();
    }

    public static void addResolvedPath(String path, VirtualFile virtualFile) {
        Map<String, VirtualFile> resolvedMap = resolved.get();
        if (resolvedMap == null) {
            resolvedMap = new HashMap<String, VirtualFile>();
            resolved.set(resolvedMap);
        }
        resolvedMap.put(path, virtualFile);
    }

    public static VirtualFile getResolvedPath(String path) {
        Map<String, VirtualFile> resolvedMap = resolved.get();
        assert (resolvedMap != null);
        return resolvedMap.get(path);
    }

    public static void setBenchmark(Benchmark b) {
        stopWatch.set(b);
    }

    public static Benchmark getBenchmark() {
        return stopWatch.get();
    }

    public static void resetBenchmark() {
        Benchmark b = stopWatch.get();
        if (b != null) {
            // empty if block
        }
    }

    public static void setMimeMappings(MimeMappings mappings) {
        mimeMappings.set(mappings);
    }

    static MimeMappings getMimeMappings() {
        return mimeMappings.get();
    }

    public static void setProgressMeter(ProgressMeter meter) {
        progressMeter.set(meter);
    }

    public static ProgressMeter getProgressMeter() {
        return progressMeter.get();
    }

    public static void setCompilerControl(CompilerControl cc) {
        compilerControl.set(cc);
    }

    public static CompilerControl getCompilerControl() {
        return compilerControl.get();
    }

    public static void setStandardDefs(StandardDefs defs) {
        standardDefs.set(defs);
    }

    public static StandardDefs getStandardDefs() {
        StandardDefs defs = standardDefs.get();
        if (defs == null) {
            defs = StandardDefs.getStandardDefs("halo");
            ThreadLocalToolkit.setStandardDefs(defs);
        }
        return defs;
    }

    public static void setLogger(Logger logger) {
        ThreadLocalToolkit.logger.set(logger);
        if (logger != null) {
            // empty if block
        }
    }

    public static Logger getLogger() {
        return logger.get();
    }

    public static void setCompatibilityVersion(Integer compatibilityVersion) {
        ThreadLocalToolkit.compatibilityVersion.set(compatibilityVersion);
    }

    public static Integer getCompatibilityVersion() {
        assert (compatibilityVersion.get() != null) : "Entry point missing setCompatibilityVersion()";
        return compatibilityVersion.get();
    }

    public static int errorCount() {
        Logger l = logger.get();
        if (l != null) {
            return l.errorCount();
        }
        return 0;
    }

    public static int warningCount() {
        Logger l = logger.get();
        if (l != null) {
            return l.warningCount();
        }
        return 0;
    }

    public static void logInfo(String info) {
        Logger l = logger.get();
        if (l != null) {
            l.logInfo(info);
        } else {
            System.out.println(info);
        }
    }

    public static void logDebug(String debug) {
        Logger l = logger.get();
        if (l != null) {
            l.logDebug(debug);
        } else {
            System.err.println(debug);
        }
    }

    public static void logWarning(String warning) {
        Logger l = logger.get();
        if (l != null) {
            l.logWarning(warning);
        } else {
            System.err.println(warning);
        }
    }

    public static void logError(String error) {
        Logger l = logger.get();
        if (l != null) {
            l.logError(error);
        } else {
            System.err.println(error);
        }
    }

    public static void logInfo(String path, String info) {
        Logger l = logger.get();
        if (l != null) {
            l.logInfo(path, info);
        } else {
            System.out.println(path + ":" + info);
        }
    }

    public static void logDebug(String path, String debug) {
        Logger l = logger.get();
        if (l != null) {
            l.logDebug(path, debug);
        } else {
            System.err.println(path + ":" + debug);
        }
    }

    public static void logWarning(String path, String warning) {
        Logger l = logger.get();
        if (l != null) {
            l.logWarning(path, warning);
        } else {
            System.err.println(path + ":" + warning);
        }
    }

    public static void logWarning(String path, String warning, int errorCode) {
        Logger l = logger.get();
        if (l != null) {
            l.logWarning(path, warning, errorCode);
        } else {
            System.err.println(path + ":" + warning);
        }
    }

    public static void logError(String path, String error) {
        Logger l = logger.get();
        if (l != null) {
            l.logError(path, error);
        } else {
            System.err.println(path + ":" + error);
        }
    }

    public static void logError(String path, String error, int errorCode) {
        Logger l = logger.get();
        if (l != null) {
            l.logError(path, error, errorCode);
        } else {
            System.err.println(path + ":" + error);
        }
    }

    public static void logInfo(String path, int line, String info) {
        Logger l = logger.get();
        if (l != null) {
            l.logInfo(path, line, info);
        } else {
            System.out.println(path + ": line " + line + " - " + info);
        }
    }

    public static void logDebug(String path, int line, String debug) {
        Logger l = logger.get();
        if (l != null) {
            l.logDebug(path, line, debug);
        } else {
            System.err.println(path + ": line " + line + " - " + debug);
        }
    }

    public static void logWarning(String path, int line, String warning) {
        Logger l = logger.get();
        if (l != null) {
            l.logWarning(path, line, warning);
        } else {
            System.err.println(path + ": line " + line + " - " + warning);
        }
    }

    public static void logError(String path, int line, String error) {
        Logger l = logger.get();
        if (l != null) {
            l.logError(path, line, error);
        } else {
            System.err.println(path + ": line " + line + " - " + error);
        }
    }

    public static void logInfo(String path, int line, int col, String info) {
        Logger l = logger.get();
        if (l != null) {
            l.logInfo(path, line, col, info);
        } else {
            System.out.println(path + ": line " + line + ", col " + col + " - " + info);
        }
    }

    public static void logDebug(String path, int line, int col, String debug) {
        Logger l = logger.get();
        if (l != null) {
            l.logDebug(path, line, col, debug);
        } else {
            System.err.println(path + ": line " + line + ", col " + col + " - " + debug);
        }
    }

    public static void logWarning(String path, int line, int col, String warning) {
        Logger l = logger.get();
        if (l != null) {
            l.logWarning(path, line, col, warning);
        } else {
            System.err.println(path + ": line " + line + ", col " + col + " - " + warning);
        }
    }

    public static void logError(String path, int line, int col, String error) {
        Logger l = logger.get();
        if (l != null) {
            l.logError(path, line, col, error);
        } else {
            System.err.println(path + ": line " + line + ", col " + col + " - " + error);
        }
    }

    public static void logWarning(String path, int line, int col, String warning, String source) {
        Logger l = logger.get();
        if (l != null) {
            l.logWarning(path, line, col, warning, source);
        } else {
            System.err.println(path + ": line " + line + ", col " + col + " - " + warning);
            System.err.println(source);
        }
    }

    public static void logWarning(String path, int line, int col, String warning, String source, int errorCode) {
        Logger l = logger.get();
        if (l != null) {
            l.logWarning(path, line, col, warning, source, errorCode);
        } else {
            System.err.println(path + ": line " + line + ", col " + col + " - " + warning);
            System.err.println(source);
        }
    }

    public static void logError(String path, int line, int col, String error, String source) {
        Logger l = logger.get();
        if (l != null) {
            l.logError(path, line, col, error, source);
        } else {
            System.err.println(path + ": line " + line + ", col " + col + " - " + error);
            System.err.println(source);
        }
    }

    public static void logError(String path, int line, int col, String error, String source, int errorCode) {
        Logger l = logger.get();
        if (l != null) {
            l.logError(path, line, col, error, source, errorCode);
        } else {
            System.err.println(path + ": line " + line + ", col " + col + " - " + error);
            System.err.println(source);
        }
    }

    public static void log(CompilerMessage m, String path, int line, int column) {
        m.path = path;
        m.line = line;
        m.column = column;
        ThreadLocalToolkit.log(m);
    }

    public static void log(CompilerMessage m, String path, int line, int column, String source) {
        m.path = path;
        m.line = line;
        m.column = column;
        ThreadLocalToolkit.log((ILocalizableMessage)m, source);
    }

    public static void log(CompilerMessage m, String path, int line) {
        ThreadLocalToolkit.log(m, path, line, -1);
    }

    public static void log(CompilerMessage m, String path) {
        ThreadLocalToolkit.log(m, path, -1, -1);
    }

    public static void log(CompilerMessage m, Source s, int line) {
        m.path = s.getNameForReporting();
        m.line = line;
        ThreadLocalToolkit.log(m);
    }

    public static void log(CompilerMessage m, Source s, int line, int column) {
        m.path = s.getNameForReporting();
        m.line = line;
        m.column = column;
        ThreadLocalToolkit.log(m);
    }

    public static void log(CompilerMessage m, Source s) {
        m.path = s.getNameForReporting();
        ThreadLocalToolkit.log(m);
    }

    public static void log(ILocalizableMessage m) {
        Logger logger = ThreadLocalToolkit.getLogger();
        if (logger != null) {
            logger.log(m);
        }
    }

    public static void log(ILocalizableMessage m, String source) {
        Logger logger = ThreadLocalToolkit.getLogger();
        if (logger != null) {
            logger.log(m, source);
        }
    }
}

