/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.remoting.channel;

import io.netty.channel.Channel;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.rocketmq.common.utils.StartAndShutdown;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.remoting.RemotingProxyOutClient;
import org.apache.rocketmq.proxy.remoting.channel.RemotingChannel;
import org.apache.rocketmq.proxy.service.relay.ProxyRelayService;
import org.apache.rocketmq.remoting.protocol.heartbeat.SubscriptionData;

public class RemotingChannelManager
implements StartAndShutdown {
    protected static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    private final ProxyRelayService proxyRelayService;
    protected final ConcurrentMap<String, Map<Channel, RemotingChannel>> groupChannelMap = new ConcurrentHashMap<String, Map<Channel, RemotingChannel>>();
    private final RemotingProxyOutClient remotingProxyOutClient;

    public RemotingChannelManager(RemotingProxyOutClient remotingProxyOutClient, ProxyRelayService proxyRelayService) {
        this.remotingProxyOutClient = remotingProxyOutClient;
        this.proxyRelayService = proxyRelayService;
    }

    protected String buildProducerKey(String group) {
        return this.buildKey("p", group);
    }

    protected String buildConsumerKey(String group) {
        return this.buildKey("c", group);
    }

    protected String buildKey(String prefix, String group) {
        return prefix + group;
    }

    public RemotingChannel createProducerChannel(Channel channel, String group, String clientId) {
        return this.createChannel(channel, this.buildProducerKey(group), clientId, Collections.emptySet());
    }

    public RemotingChannel createConsumerChannel(Channel channel, String group, String clientId, Set<SubscriptionData> subscriptionData) {
        return this.createChannel(channel, this.buildConsumerKey(group), clientId, subscriptionData);
    }

    protected RemotingChannel createChannel(Channel channel, String group, String clientId, Set<SubscriptionData> subscriptionData) {
        this.groupChannelMap.compute(group, (groupKey, clientIdMap) -> {
            if (clientIdMap == null) {
                clientIdMap = new ConcurrentHashMap<Channel, RemotingChannel>();
            }
            clientIdMap.computeIfAbsent(channel, clientIdKey -> new RemotingChannel(this.remotingProxyOutClient, this.proxyRelayService, channel, clientId, subscriptionData));
            return clientIdMap;
        });
        return this.getChannel(group, channel);
    }

    protected RemotingChannel getChannel(String group, Channel channel) {
        Map clientIdChannelMap = (Map)this.groupChannelMap.get(group);
        if (clientIdChannelMap == null) {
            return null;
        }
        return (RemotingChannel)clientIdChannelMap.get(channel);
    }

    public Set<RemotingChannel> removeChannel(Channel channel) {
        HashSet<RemotingChannel> removedChannelSet = new HashSet<RemotingChannel>();
        Set groupKeySet = this.groupChannelMap.keySet();
        for (String group : groupKeySet) {
            RemotingChannel remotingChannel = this.removeChannel(group, channel);
            if (remotingChannel == null) continue;
            removedChannelSet.add(remotingChannel);
        }
        return removedChannelSet;
    }

    public RemotingChannel removeProducerChannel(String group, Channel channel) {
        return this.removeChannel(this.buildProducerKey(group), channel);
    }

    public RemotingChannel removeConsumerChannel(String group, Channel channel) {
        return this.removeChannel(this.buildConsumerKey(group), channel);
    }

    protected RemotingChannel removeChannel(String group, Channel channel) {
        AtomicReference channelRef = new AtomicReference();
        this.groupChannelMap.computeIfPresent(group, (groupKey, channelMap) -> {
            channelRef.set(channelMap.remove(this.getOrgRawChannel(channel)));
            if (channelMap.isEmpty()) {
                return null;
            }
            return channelMap;
        });
        return (RemotingChannel)channelRef.get();
    }

    protected Channel getOrgRawChannel(Channel channel) {
        if (channel instanceof RemotingChannel) {
            return channel.parent();
        }
        return channel;
    }

    public void shutdown() throws Exception {
    }

    public void start() throws Exception {
    }
}

