/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.sampling;

import com.yahoo.memory.Memory;
import com.yahoo.memory.NativeMemory;
import com.yahoo.sketches.Family;
import com.yahoo.sketches.ResizeFactor;
import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.SketchesStateException;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.sampling.PreambleUtil;
import com.yahoo.sketches.sampling.SamplingUtil;
import com.yahoo.sketches.sampling.VersionConverter;
import java.util.Arrays;

public final class ReservoirLongsSketch {
    private static final int MIN_LG_ARR_LONGS = 4;
    private static final long MAX_ITEMS_SEEN = 0xFFFFFFFFFFFFL;
    private static final ResizeFactor DEFAULT_RESIZE_FACTOR = ResizeFactor.X8;
    private final int reservoirSize_;
    private int currItemsAlloc_;
    private long itemsSeen_;
    private final ResizeFactor rf_;
    private long[] data_;

    private ReservoirLongsSketch(int k, ResizeFactor rf) {
        if (k < 2) {
            throw new SketchesArgumentException("k must be at least 2");
        }
        this.reservoirSize_ = k;
        this.rf_ = rf;
        this.itemsSeen_ = 0L;
        int ceilingLgK = Util.toLog2(Util.ceilingPowerOf2(this.reservoirSize_), "ReservoirLongsSketch");
        int initialLgSize = SamplingUtil.startingSubMultiple(ceilingLgK, this.rf_.lg(), 4);
        this.currItemsAlloc_ = SamplingUtil.getAdjustedSize(this.reservoirSize_, 1 << initialLgSize);
        this.data_ = new long[this.currItemsAlloc_];
        Arrays.fill(this.data_, 0L);
    }

    private ReservoirLongsSketch(long[] data, long itemsSeen, ResizeFactor rf, int k) {
        if (data == null) {
            throw new SketchesArgumentException("Instantiating sketch with null reservoir");
        }
        if (k < 2) {
            throw new SketchesArgumentException("Cannot instantiate sketch with reservoir size less than 2");
        }
        if (k < data.length) {
            throw new SketchesArgumentException("Instantiating sketch with max size less than array length: " + k + " max size, array of length " + data.length);
        }
        if (itemsSeen >= (long)k && data.length < k || itemsSeen < (long)k && (long)data.length < itemsSeen) {
            throw new SketchesArgumentException("Instantiating sketch with too few samples. Items seen: " + itemsSeen + ", max reservoir size: " + k + ", data array length: " + data.length);
        }
        this.reservoirSize_ = k;
        this.currItemsAlloc_ = data.length;
        this.itemsSeen_ = itemsSeen;
        this.rf_ = rf;
        this.data_ = data;
    }

    private ReservoirLongsSketch(int k, int currItemsAlloc, long itemsSeen, ResizeFactor rf, long[] data) {
        this.reservoirSize_ = k;
        this.currItemsAlloc_ = currItemsAlloc;
        this.itemsSeen_ = itemsSeen;
        this.rf_ = rf;
        this.data_ = data;
    }

    public static ReservoirLongsSketch getInstance(int k) {
        return new ReservoirLongsSketch(k, DEFAULT_RESIZE_FACTOR);
    }

    public static ReservoirLongsSketch getInstance(int k, ResizeFactor rf) {
        return new ReservoirLongsSketch(k, rf);
    }

    public static ReservoirLongsSketch getInstance(Memory srcMem) {
        Family.RESERVOIR.checkFamilyID(srcMem.getByte(2L));
        int numPreLongs = PreambleUtil.getAndCheckPreLongs(srcMem);
        long pre0 = srcMem.getLong(0L);
        ResizeFactor rf = ResizeFactor.getRF(PreambleUtil.extractResizeFactor(pre0));
        int serVer = PreambleUtil.extractSerVer(pre0);
        boolean isEmpty = (PreambleUtil.extractFlags(pre0) & 4) != 0;
        boolean preLongsEqMin = numPreLongs == Family.RESERVOIR.getMinPreLongs();
        boolean preLongsEqMax = numPreLongs == Family.RESERVOIR.getMaxPreLongs();
        if (!preLongsEqMin & !preLongsEqMax) {
            throw new SketchesArgumentException("Possible corruption: Non-empty sketch with only " + Family.RESERVOIR.getMinPreLongs() + "preLongs");
        }
        if (serVer != 2) {
            if (serVer == 1) {
                srcMem = VersionConverter.convertSketch1to2(srcMem);
                pre0 = srcMem.getLong(0L);
            } else {
                throw new SketchesArgumentException("Possible Corruption: Ser Ver must be 2: " + serVer);
            }
        }
        int k = PreambleUtil.extractReservoirSize(pre0);
        if (isEmpty) {
            return new ReservoirLongsSketch(k, rf);
        }
        long pre1 = srcMem.getLong(8L);
        long itemsSeen = PreambleUtil.extractItemsSeenCount(pre1);
        int preLongBytes = numPreLongs << 3;
        int numSketchLongs = (int)Math.min(itemsSeen, (long)k);
        int allocatedSize = k;
        if (itemsSeen < (long)k) {
            int ceilingLgK = Util.toLog2(Util.ceilingPowerOf2(k), "getInstance");
            int minLgSize = Util.toLog2(Util.ceilingPowerOf2((int)itemsSeen), "getInstance");
            int initialLgSize = SamplingUtil.startingSubMultiple(ceilingLgK, rf.lg(), Math.max(minLgSize, 4));
            allocatedSize = SamplingUtil.getAdjustedSize(k, 1 << initialLgSize);
        }
        long[] data = new long[allocatedSize];
        srcMem.getLongArray((long)preLongBytes, data, 0, numSketchLongs);
        return new ReservoirLongsSketch(data, itemsSeen, rf, k);
    }

    static ReservoirLongsSketch getInstance(long[] data, long itemsSeen, ResizeFactor rf, int k) {
        return new ReservoirLongsSketch(data, itemsSeen, rf, k);
    }

    public int getK() {
        return this.reservoirSize_;
    }

    public long getN() {
        return this.itemsSeen_;
    }

    public int getNumSamples() {
        return (int)Math.min((long)this.reservoirSize_, this.itemsSeen_);
    }

    public long[] getSamples() {
        if (this.itemsSeen_ == 0L) {
            return null;
        }
        int numSamples = (int)Math.min((long)this.reservoirSize_, this.itemsSeen_);
        return Arrays.copyOf(this.data_, numSamples);
    }

    public void update(long item) {
        if (this.itemsSeen_ == 0xFFFFFFFFFFFFL) {
            throw new SketchesStateException("Sketch has exceeded capacity for total items seen: 281474976710655");
        }
        if (this.itemsSeen_ < (long)this.reservoirSize_) {
            if (this.itemsSeen_ >= (long)this.currItemsAlloc_) {
                this.growReservoir();
            }
            assert (this.itemsSeen_ < (long)this.currItemsAlloc_);
            this.data_[(int)this.itemsSeen_] = item;
            ++this.itemsSeen_;
        } else {
            ++this.itemsSeen_;
            if (SamplingUtil.rand.nextDouble() * (double)this.itemsSeen_ < (double)this.reservoirSize_) {
                int newSlot = SamplingUtil.rand.nextInt(this.reservoirSize_);
                this.data_[newSlot] = item;
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String thisSimpleName = this.getClass().getSimpleName();
        sb.append(Util.LS);
        sb.append("### ").append(thisSimpleName).append(" SUMMARY: ").append(Util.LS);
        sb.append("   k            : ").append(this.reservoirSize_).append(Util.LS);
        sb.append("   n            : ").append(this.itemsSeen_).append(Util.LS);
        sb.append("   Current size : ").append(this.currItemsAlloc_).append(Util.LS);
        sb.append("   Resize factor: ").append((Object)this.rf_).append(Util.LS);
        sb.append("### END SKETCH SUMMARY").append(Util.LS);
        return sb.toString();
    }

    public byte[] toByteArray() {
        int outBytes;
        int preLongs;
        boolean empty = this.itemsSeen_ == 0L;
        int numItems = (int)Math.min((long)this.reservoirSize_, this.itemsSeen_);
        if (empty) {
            preLongs = 1;
            outBytes = 8;
        } else {
            preLongs = Family.RESERVOIR.getMaxPreLongs();
            outBytes = preLongs + numItems << 3;
        }
        byte[] outArr = new byte[outBytes];
        NativeMemory mem = new NativeMemory(outArr);
        long pre0 = 0L;
        pre0 = PreambleUtil.insertPreLongs(preLongs, pre0);
        pre0 = PreambleUtil.insertResizeFactor(this.rf_.lg(), pre0);
        pre0 = PreambleUtil.insertSerVer(2, pre0);
        pre0 = PreambleUtil.insertFamilyID(Family.RESERVOIR.getID(), pre0);
        pre0 = empty ? PreambleUtil.insertFlags(4, pre0) : PreambleUtil.insertFlags(0, pre0);
        pre0 = PreambleUtil.insertReservoirSize(this.reservoirSize_, pre0);
        if (empty) {
            mem.putLong(0L, pre0);
        } else {
            long pre1 = 0L;
            pre1 = PreambleUtil.insertItemsSeenCount(this.itemsSeen_, pre1);
            long[] preArr = new long[preLongs];
            preArr[0] = pre0;
            preArr[1] = pre1;
            mem.putLongArray(0L, preArr, 0, preLongs);
            int preBytes = preLongs << 3;
            mem.putLongArray((long)preBytes, this.data_, 0, numItems);
        }
        return outArr;
    }

    double getImplicitSampleWeight() {
        if (this.itemsSeen_ < (long)this.reservoirSize_) {
            return 1.0;
        }
        return 1.0 * (double)this.itemsSeen_ / (double)this.reservoirSize_;
    }

    long getValueAtPosition(int pos) {
        if (this.itemsSeen_ == 0L) {
            throw new SketchesArgumentException("Requested element from empty reservoir.");
        }
        if (pos < 0 || pos >= this.getNumSamples()) {
            throw new SketchesArgumentException("Requested position must be between 0 and " + (this.getNumSamples() - 1) + ", inclusive. Received: " + pos);
        }
        return this.data_[pos];
    }

    void insertValueAtPosition(long value, int pos) {
        if (pos < 0 || pos >= this.getNumSamples()) {
            throw new SketchesArgumentException("Insert position must be between 0 and " + this.getNumSamples() + ", inclusive. Received: " + pos);
        }
        this.data_[pos] = value;
    }

    void forceIncrementItemsSeen(long inc) {
        this.itemsSeen_ += inc;
        if (this.itemsSeen_ > 0xFFFFFFFFFFFFL) {
            throw new SketchesStateException("Sketch has exceeded capacity for total items seen. Limit: 281474976710655, found: " + this.itemsSeen_);
        }
    }

    ReservoirLongsSketch copy() {
        long[] dataCopy = Arrays.copyOf(this.data_, this.currItemsAlloc_);
        return new ReservoirLongsSketch(this.reservoirSize_, this.currItemsAlloc_, this.itemsSeen_, this.rf_, dataCopy);
    }

    ReservoirLongsSketch downsampledCopy(int maxK) {
        ReservoirLongsSketch rls = new ReservoirLongsSketch(maxK, this.rf_);
        for (long l : this.getSamples()) {
            rls.update(l);
        }
        if (rls.getN() < this.itemsSeen_) {
            rls.forceIncrementItemsSeen(this.itemsSeen_ - rls.getN());
        }
        return rls;
    }

    private void growReservoir() {
        this.currItemsAlloc_ = SamplingUtil.getAdjustedSize(this.reservoirSize_, this.currItemsAlloc_ * this.rf_.getValue());
        this.data_ = Arrays.copyOf(this.data_, this.currItemsAlloc_);
    }
}

