/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.primitivetype;

import java.math.BigInteger;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt64;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;

public final class EdmSByte
extends SingletonPrimitiveType {
    private static final EdmSByte INSTANCE = new EdmSByte();

    public static EdmSByte getInstance() {
        return INSTANCE;
    }

    @Override
    public Class<?> getDefaultType() {
        return Byte.class;
    }

    @Override
    protected <T> T internalValueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        Byte valueByte;
        try {
            valueByte = Byte.parseByte(value);
        }
        catch (NumberFormatException e) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' has illegal content.", e);
        }
        try {
            return EdmInt64.convertNumber(valueByte, returnType);
        }
        catch (ClassCastException e) {
            throw new EdmPrimitiveTypeException("The value type " + returnType + " is not supported.", e);
        }
    }

    @Override
    protected <T> String internalValueToString(T value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        if (value instanceof Byte) {
            return value.toString();
        }
        if (value instanceof Short || value instanceof Integer || value instanceof Long) {
            if (((Number)value).longValue() >= -128L && ((Number)value).longValue() <= 127L) {
                return value.toString();
            }
            throw new EdmPrimitiveTypeException("The value '" + value + "' is not valid.");
        }
        if (value instanceof BigInteger) {
            if (((BigInteger)value).bitLength() < 8) {
                return value.toString();
            }
            throw new EdmPrimitiveTypeException("The value '" + value + "' is not valid.");
        }
        throw new EdmPrimitiveTypeException("The value type " + value.getClass() + " is not supported.");
    }
}

