/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.nifi;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;
import org.apache.nifi.web.api.dto.ParameterContextDTO;
import org.apache.nifi.web.api.dto.ParameterDTO;
import org.apache.nifi.web.api.entity.ParameterContextEntity;

public class ParamContextResult
extends AbstractWritableResult<ParameterContextEntity> {
    private final ParameterContextEntity parameterContext;
    private final boolean includeParameterContextSource;

    public ParamContextResult(ResultType resultType, ParameterContextEntity parameterContext, boolean includeParameterContextSource) {
        super(resultType);
        this.parameterContext = parameterContext;
        this.includeParameterContextSource = includeParameterContextSource;
    }

    @Override
    protected void writeSimpleResult(PrintStream output) throws IOException {
        ParameterContextDTO parameterContextDTO = this.parameterContext.getComponent();
        Set paramEntities = parameterContextDTO.getParameters() == null ? Collections.emptySet() : parameterContextDTO.getParameters();
        Set paramDTOs = paramEntities.stream().map(p -> p.getParameter()).collect(Collectors.toSet());
        List sortedParams = paramDTOs.stream().sorted(Comparator.comparing(param -> param.getParameterContext().getComponent().getId().equals(this.parameterContext.getComponent().getId())).reversed().thenComparing(ParameterDTO::getName)).collect(Collectors.toList());
        Table.Builder tableBuilder = new Table.Builder().column("#", 3, 3, false).column("Name", 20, 60, false).column("Value", 20, 80, false).column("Sensitive", 10, 10, false).column("Provided", 10, 10, false);
        if (this.includeParameterContextSource) {
            tableBuilder.column("Source Parameter Context", 25, 40, true);
        }
        Table table = tableBuilder.column("Description", 20, 80, true).build();
        for (int i = 0; i < sortedParams.size(); ++i) {
            String[] stringArray;
            ParameterDTO r = (ParameterDTO)sortedParams.get(i);
            if (this.includeParameterContextSource) {
                String[] stringArray2 = new String[7];
                stringArray2[0] = String.valueOf(i + 1);
                stringArray2[1] = r.getName();
                stringArray2[2] = r.getValue();
                stringArray2[3] = r.getSensitive().toString();
                stringArray2[4] = String.valueOf(r.getProvided());
                stringArray2[5] = r.getParameterContext().getComponent().getName();
                stringArray = stringArray2;
                stringArray2[6] = r.getDescription();
            } else {
                String[] stringArray3 = new String[6];
                stringArray3[0] = String.valueOf(i + 1);
                stringArray3[1] = r.getName();
                stringArray3[2] = r.getValue();
                stringArray3[3] = r.getSensitive().toString();
                stringArray3[4] = String.valueOf(r.getProvided());
                stringArray = stringArray3;
                stringArray3[5] = r.getDescription();
            }
            String[] row = stringArray;
            table.addRow(row);
        }
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }

    @Override
    public ParameterContextEntity getResult() {
        return this.parameterContext;
    }
}

