/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.hibernate;

import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionImplementor;
import org.springframework.core.Ordered;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.orm.jpa.hibernate.SessionHolder;
import org.springframework.orm.jpa.hibernate.SpringFlushSynchronization;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

class SpringSessionSynchronization
implements TransactionSynchronization,
Ordered {
    static final int SESSION_SYNCHRONIZATION_ORDER = 900;
    private final SessionHolder sessionHolder;
    private final SessionFactory sessionFactory;
    private final boolean newSession;
    private boolean holderActive = true;

    public SpringSessionSynchronization(SessionHolder sessionHolder, SessionFactory sessionFactory, boolean newSession) {
        this.sessionHolder = sessionHolder;
        this.sessionFactory = sessionFactory;
        this.newSession = newSession;
    }

    private Session getCurrentSession() {
        return this.sessionHolder.getSession();
    }

    public int getOrder() {
        return 900;
    }

    public void suspend() {
        if (this.holderActive) {
            TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
            Session session = this.getCurrentSession();
            if (session instanceof SessionImplementor) {
                SessionImplementor sessionImpl = (SessionImplementor)session;
                sessionImpl.getJdbcCoordinator().getLogicalConnection().manualDisconnect();
            }
        }
    }

    public void resume() {
        if (this.holderActive) {
            TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)((Object)this.sessionHolder));
        }
    }

    public void flush() {
        try {
            this.getCurrentSession().flush();
        }
        catch (RuntimeException ex) {
            throw DataAccessUtils.translateIfNecessary((RuntimeException)ex, (PersistenceExceptionTranslator)SpringFlushSynchronization.exceptionTranslator);
        }
    }

    public void beforeCommit(boolean readOnly) throws DataAccessException {
        Session session;
        if (!readOnly && !FlushMode.MANUAL.equals((Object)(session = this.getCurrentSession()).getHibernateFlushMode())) {
            try {
                this.getCurrentSession().flush();
            }
            catch (RuntimeException ex) {
                throw DataAccessUtils.translateIfNecessary((RuntimeException)ex, (PersistenceExceptionTranslator)SpringFlushSynchronization.exceptionTranslator);
            }
        }
    }

    public void beforeCompletion() {
        try {
            Session session = this.sessionHolder.getSession();
            if (this.sessionHolder.getPreviousFlushMode() != null) {
                session.setHibernateFlushMode(this.sessionHolder.getPreviousFlushMode());
            }
            if (session instanceof SessionImplementor) {
                SessionImplementor sessionImpl = (SessionImplementor)session;
                sessionImpl.getJdbcCoordinator().getLogicalConnection().manualDisconnect();
            }
        }
        finally {
            if (this.newSession) {
                TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
                this.holderActive = false;
            }
        }
    }

    public void afterCommit() {
    }

    public void afterCompletion(int status) {
        try {
            if (status != 0) {
                this.sessionHolder.getSession().clear();
            }
        }
        finally {
            this.sessionHolder.setSynchronizedWithTransaction(false);
            if (this.newSession) {
                this.sessionHolder.closeAll();
            }
        }
    }
}

