/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.crypto.key;

import java.util.Objects;
import org.apache.nifi.security.crypto.key.DerivedKeyParameterSpec;
import org.apache.nifi.security.crypto.key.DerivedKeySpec;

public class StandardDerivedKeySpec<T extends DerivedKeyParameterSpec>
implements DerivedKeySpec<T> {
    private final char[] password;
    private final int derivedKeyLength;
    private final String algorithm;
    private final T parameterSpec;

    public StandardDerivedKeySpec(char[] password, int derivedKeyLength, String algorithm, T parameterSpec) {
        this.password = Objects.requireNonNull(password, "Password required");
        this.derivedKeyLength = derivedKeyLength;
        this.algorithm = Objects.requireNonNull(algorithm, "Algorithm required");
        this.parameterSpec = (DerivedKeyParameterSpec)Objects.requireNonNull(parameterSpec, "Parameter Specification required");
    }

    @Override
    public char[] getPassword() {
        return this.password;
    }

    @Override
    public int getDerivedKeyLength() {
        return this.derivedKeyLength;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public T getParameterSpec() {
        return this.parameterSpec;
    }
}

