/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.flow;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.flow.VersionedReportingTaskSnapshot;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.nifi.ImportReportingTasksResult;
import org.apache.nifi.toolkit.cli.impl.util.JacksonUtils;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.web.api.entity.VersionedReportingTaskImportRequestEntity;
import org.apache.nifi.web.api.entity.VersionedReportingTaskImportResponseEntity;

public class ImportReportingTasks
extends AbstractNiFiCommand<ImportReportingTasksResult> {
    public ImportReportingTasks() {
        super("import-reporting-tasks", ImportReportingTasksResult.class);
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.INPUT_SOURCE.createOption());
    }

    @Override
    public String getDescription() {
        return "Imports the contents of a reporting task snapshot produced from export-reporting-tasks or export-reporting-task.";
    }

    @Override
    public ImportReportingTasksResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String inputFile = this.getRequiredArg(properties, CommandOption.INPUT_SOURCE);
        String contents = this.getInputSourceContent(inputFile);
        ObjectMapper objectMapper = JacksonUtils.getObjectMapper();
        VersionedReportingTaskSnapshot reportingTaskSnapshot = (VersionedReportingTaskSnapshot)objectMapper.readValue(contents, VersionedReportingTaskSnapshot.class);
        if (reportingTaskSnapshot == null) {
            throw new IOException("Unable to deserialize reporting task snapshot from " + inputFile);
        }
        VersionedReportingTaskImportRequestEntity importRequestEntity = new VersionedReportingTaskImportRequestEntity();
        importRequestEntity.setReportingTaskSnapshot(reportingTaskSnapshot);
        VersionedReportingTaskImportResponseEntity importResponseEntity = client.getControllerClient().importReportingTasks(importRequestEntity);
        return new ImportReportingTasksResult(this.getResultType(properties), importResponseEntity);
    }
}

