/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.awt.Font;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.util.prefs.Preferences;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class PrintPreferences {
    private static final PrintPreferences INSTANCE = new PrintPreferences();
    private static final String PROP_WRAP = "wrap";
    private static final String PROP_HEADER_FORMAT = "headerFormat";
    private static final String PROP_FOOTER_FORMAT = "footerFormat";
    private static final String PROP_HEADER_ALIGNMENT = "headerAlignment";
    private static final String PROP_FOOTER_ALIGNMENT = "footerAlignment";
    private static final String PROP_PAGE_ORIENTATION = "pageOrientation";
    private static final String PROP_PAGE_WIDTH = "pageWidth";
    private static final String PROP_PAGE_HEIGHT = "pageHeight";
    private static final String PROP_PAGE_IMAGEABLEAREA_Y = "imageableAreaY";
    private static final String PROP_PAGE_IMAGEABLEAREA_X = "imageableAreaX";
    private static final String PROP_PAGE_IMAGEABLEAREA_WIDTH = "imageableAreaWidth";
    private static final String PROP_PAGE_IMAGEABLEAREA_HEIGHT = "imageableAreaHeight";
    private static final String PROP_HEADER_FONT_NAME = "headerFontName";
    private static final String PROP_HEADER_FONT_STYLE = "headerFontStyle";
    private static final String PROP_HEADER_FONT_SIZE = "headerFontSize";
    private static final String PROP_FOOTER_FONT_NAME = "footerFontName";
    private static final String PROP_FOOTER_FONT_STYLE = "footerFontStyle";
    private static final String PROP_FOOTER_FONT_SIZE = "footerFontSize";
    private static final String DEFAULT_FONT_NAME = "Monospaced";
    private static final int DEFAULT_FONT_STYLE = 0;
    private static final int DEFAULT_FONT_SIZE = 6;
    private static final String PROP_LINE_ASCENT_CORRECTION = "lineAscentCorrection";

    private PrintPreferences() {
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(PrintPreferences.class);
    }

    public static PageFormat getPageFormat(PrinterJob pj) {
        PageFormat pageFormat = null;
        pageFormat = pj.defaultPage();
        Paper p = pageFormat.getPaper();
        int pageOrientation = PrintPreferences.getPreferences().getInt(PROP_PAGE_ORIENTATION, pageFormat.getOrientation());
        double paperWidth = PrintPreferences.getPreferences().getDouble(PROP_PAGE_WIDTH, p.getWidth());
        double paperHeight = PrintPreferences.getPreferences().getDouble(PROP_PAGE_HEIGHT, p.getHeight());
        double iaWidth = PrintPreferences.getPreferences().getDouble(PROP_PAGE_IMAGEABLEAREA_WIDTH, p.getImageableWidth());
        double iaHeight = PrintPreferences.getPreferences().getDouble(PROP_PAGE_IMAGEABLEAREA_HEIGHT, p.getImageableHeight());
        double iaX = PrintPreferences.getPreferences().getDouble(PROP_PAGE_IMAGEABLEAREA_X, p.getImageableX());
        double iaY = PrintPreferences.getPreferences().getDouble(PROP_PAGE_IMAGEABLEAREA_Y, p.getImageableY());
        pageFormat.setOrientation(pageOrientation);
        p.setSize(paperWidth, paperHeight);
        p.setImageableArea(iaX, iaY, iaWidth, iaHeight);
        pageFormat.setPaper(p);
        return pageFormat;
    }

    public static void setPageFormat(PageFormat pf) {
        PrintPreferences.getPreferences().putInt(PROP_PAGE_ORIENTATION, pf.getOrientation());
        PrintPreferences.getPreferences().putDouble(PROP_PAGE_WIDTH, pf.getPaper().getWidth());
        PrintPreferences.getPreferences().putDouble(PROP_PAGE_HEIGHT, pf.getPaper().getHeight());
        PrintPreferences.getPreferences().putDouble(PROP_PAGE_IMAGEABLEAREA_WIDTH, pf.getPaper().getImageableWidth());
        PrintPreferences.getPreferences().putDouble(PROP_PAGE_IMAGEABLEAREA_HEIGHT, pf.getPaper().getImageableHeight());
        PrintPreferences.getPreferences().putDouble(PROP_PAGE_IMAGEABLEAREA_X, pf.getPaper().getImageableX());
        PrintPreferences.getPreferences().putDouble(PROP_PAGE_IMAGEABLEAREA_Y, pf.getPaper().getImageableY());
    }

    public static boolean getWrap() {
        return PrintPreferences.getPreferences().getBoolean(PROP_WRAP, true);
    }

    public static void setWrap(boolean wrap) {
        if (PrintPreferences.getWrap() == wrap) {
            return;
        }
        PrintPreferences.getPreferences().putBoolean(PROP_WRAP, wrap);
    }

    public static String getHeaderFormat() {
        return PrintPreferences.getPreferences().get(PROP_HEADER_FORMAT, NbBundle.getMessage(PrintPreferences.class, "CTL_Header_format"));
    }

    public static void setHeaderFormat(String s) {
        if (PrintPreferences.getHeaderFormat().equals(s)) {
            return;
        }
        PrintPreferences.getPreferences().put(PROP_HEADER_FORMAT, s);
    }

    public static String getFooterFormat() {
        return PrintPreferences.getPreferences().get(PROP_FOOTER_FORMAT, NbBundle.getMessage(PrintPreferences.class, "CTL_Footer_format"));
    }

    public static void setFooterFormat(String s) {
        if (PrintPreferences.getFooterFormat().equals(s)) {
            return;
        }
        PrintPreferences.getPreferences().put(PROP_FOOTER_FORMAT, s);
    }

    public static Font getHeaderFont() {
        String name = PrintPreferences.getPreferences().get(PROP_HEADER_FONT_NAME, DEFAULT_FONT_NAME);
        int style = PrintPreferences.getPreferences().getInt(PROP_HEADER_FONT_STYLE, 0);
        int size = PrintPreferences.getPreferences().getInt(PROP_HEADER_FONT_SIZE, 6);
        return new Font(name, style, size);
    }

    public static void setHeaderFont(Font f) {
        if (PrintPreferences.getHeaderFont().equals(f)) {
            return;
        }
        PrintPreferences.getPreferences().put(PROP_HEADER_FONT_NAME, f.getName());
        PrintPreferences.getPreferences().putInt(PROP_HEADER_FONT_STYLE, f.getStyle());
        PrintPreferences.getPreferences().putInt(PROP_HEADER_FONT_SIZE, f.getSize());
    }

    public static Font getFooterFont() {
        String name = PrintPreferences.getPreferences().get(PROP_FOOTER_FONT_NAME, DEFAULT_FONT_NAME);
        int style = PrintPreferences.getPreferences().getInt(PROP_FOOTER_FONT_STYLE, 0);
        int size = PrintPreferences.getPreferences().getInt(PROP_FOOTER_FONT_SIZE, 6);
        return new Font(name, style, size);
    }

    public static void setFooterFont(Font f) {
        if (PrintPreferences.getFooterFont().equals(f)) {
            return;
        }
        PrintPreferences.getPreferences().put(PROP_FOOTER_FONT_NAME, f.getName());
        PrintPreferences.getPreferences().putInt(PROP_FOOTER_FONT_STYLE, f.getStyle());
        PrintPreferences.getPreferences().putInt(PROP_FOOTER_FONT_SIZE, f.getSize());
    }

    public static Alignment getHeaderAlignment() {
        return Alignment.valueOf(PrintPreferences.getPreferences().get(PROP_HEADER_ALIGNMENT, Alignment.CENTER.name()));
    }

    public static void setHeaderAlignment(Alignment alignment) {
        if (PrintPreferences.getHeaderAlignment() == alignment) {
            return;
        }
        PrintPreferences.getPreferences().put(PROP_HEADER_ALIGNMENT, alignment.name());
    }

    public static Alignment getFooterAlignment() {
        return Alignment.valueOf(PrintPreferences.getPreferences().get(PROP_FOOTER_ALIGNMENT, Alignment.CENTER.name()));
    }

    public static void setFooterAlignment(Alignment alignment) {
        if (PrintPreferences.getFooterAlignment() == alignment) {
            return;
        }
        PrintPreferences.getPreferences().put(PROP_FOOTER_ALIGNMENT, alignment.name());
    }

    public static float getLineAscentCorrection() {
        return PrintPreferences.getPreferences().getFloat(PROP_LINE_ASCENT_CORRECTION, 1.0f);
    }

    public static void setLineAscentCorrection(float correction) {
        if (PrintPreferences.getLineAscentCorrection() == correction) {
            return;
        }
        if (correction < 0.0f) {
            throw new IllegalArgumentException();
        }
        PrintPreferences.getPreferences().putFloat(PROP_LINE_ASCENT_CORRECTION, correction);
    }

    public static enum Alignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

