/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.tree.IdentifierTree;
import jpt.sun.source.tree.MemberSelectTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.Modifier;
import jpt30.lang.model.element.Name;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.DoubleCheck;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.NbBundle;

public class StaticAccess {
    static final String SUPPRESS_WARNINGS_KEY = "static-access";

    protected static Fix computeFixes(CompilationInfo info, TreePath treePath, int[] bounds, int[] kind, String[] simpleName) {
        Element used;
        if (treePath.getLeaf().getKind() != Tree.Kind.MEMBER_SELECT) {
            return null;
        }
        MemberSelectTree mst = (MemberSelectTree)treePath.getLeaf();
        ExpressionTree expression = mst.getExpression();
        TreePath expr = new TreePath(treePath, expression);
        TypeMirror tm = info.getTrees().getTypeMirror(expr);
        if (!Utilities.isValidType(tm)) {
            return null;
        }
        Element el = info.getTypes().asElement(tm);
        if (el == null || !el.getKind().isClass() && !el.getKind().isInterface()) {
            return null;
        }
        TypeElement type = (TypeElement)el;
        if (StaticAccess.isError(type)) {
            return null;
        }
        Name idName = null;
        if (expression.getKind() == Tree.Kind.MEMBER_SELECT) {
            MemberSelectTree exprSelect = (MemberSelectTree)expression;
            idName = exprSelect.getIdentifier();
        }
        if (expression.getKind() == Tree.Kind.IDENTIFIER) {
            IdentifierTree idt = (IdentifierTree)expression;
            idName = idt.getName();
        }
        if (idName != null) {
            if (idName.equals(type.getSimpleName())) {
                return null;
            }
            if (idName.equals(type.getQualifiedName())) {
                return null;
            }
        }
        if ((used = info.getTrees().getElement(treePath)) == null || !used.getModifiers().contains((Object)Modifier.STATIC)) {
            return null;
        }
        if (StaticAccess.isError(used)) {
            return null;
        }
        kind[0] = used.getKind().isField() ? 0 : (used.getKind() == ElementKind.METHOD ? 1 : 2);
        simpleName[0] = used.getSimpleName().toString();
        return new FixImpl(info, expr, type).toEditorFix();
    }

    private static boolean isError(Element e) {
        if (e == null) {
            return true;
        }
        if (e.getKind() != ElementKind.CLASS) {
            return false;
        }
        TypeMirror type = ((TypeElement)e).asType();
        return type == null || type.getKind() == TypeKind.ERROR;
    }

    public static List<ErrorDescription> run(HintContext ctx) {
        String[] simpleName;
        int[] kind;
        int[] span;
        TreePath treePath;
        CompilationInfo compilationInfo = ctx.getInfo();
        Fix fix = StaticAccess.computeFixes(compilationInfo, treePath = ctx.getPath(), span = new int[2], kind = new int[1], simpleName = new String[1]);
        if (fix == null) {
            return null;
        }
        ErrorDescription ed = ErrorDescriptionFactory.forName(ctx, ctx.getPath(), NbBundle.getMessage(StaticAccess.class, "MSG_StaticAccess", kind[0], simpleName[0]), fix);
        return Collections.singletonList(ed);
    }

    static final class FixImpl
    extends JavaFix {
        private final ElementHandle<TypeElement> desiredType;

        public FixImpl(CompilationInfo info, TreePath expr, TypeElement desiredType) {
            super(info, expr);
            this.desiredType = ElementHandle.create(desiredType);
        }

        @Override
        public String getText() {
            return NbBundle.getMessage(DoubleCheck.class, "MSG_StaticAccessText");
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath tp = ctx.getPath();
            TypeElement element = this.desiredType.resolve(wc);
            if (element == null) {
                Logger.getLogger("org.netbeans.modules.java.hints").log(Level.INFO, "Cannot resolve target element.");
                return;
            }
            ExpressionTree idt = wc.getTreeMaker().QualIdent(element);
            wc.rewrite(tp.getLeaf(), idt);
        }
    }
}

