/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.faces.core;

import jakarta.el.ELException;
import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.FaceletException;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagAttributeException;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagHandler;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.myfaces.config.webparameters.MyfacesConfig;
import org.apache.myfaces.util.lang.ClassUtils;
import org.apache.myfaces.view.facelets.tag.faces.ComponentSupport;

public final class LoadBundleHandler
extends TagHandler {
    private final TagAttribute basename = this.getRequiredAttribute("basename");
    private final TagAttribute var = this.getRequiredAttribute("var");

    public LoadBundleHandler(TagConfig config) {
        super(config);
    }

    @Override
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        UIViewRoot root = ComponentSupport.getViewRoot(ctx, parent);
        ResourceBundle bundle = null;
        try {
            Locale locale;
            ResourceBundle.Control bundleControl = MyfacesConfig.getCurrentInstance().getResourceBundleControl();
            String name = this.basename.getValue(ctx);
            ClassLoader cl = ClassUtils.getContextClassLoader();
            Locale locale2 = locale = root != null && root.getLocale() != null ? root.getLocale() : Locale.getDefault();
            bundle = bundleControl == null ? ResourceBundle.getBundle(name, locale, cl) : ResourceBundle.getBundle(name, locale, cl, bundleControl);
        }
        catch (Exception e) {
            throw new TagAttributeException(this.tag, this.basename, (Throwable)e);
        }
        ResourceBundleMap map = new ResourceBundleMap(bundle);
        FacesContext faces = ctx.getFacesContext();
        faces.getExternalContext().getRequestMap().put(this.var.getValue(ctx), map);
    }

    private static final class ResourceBundleMap
    implements Map<String, String> {
        protected final ResourceBundle bundle;

        public ResourceBundleMap(ResourceBundle bundle) {
            this.bundle = bundle;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.bundle.containsKey(key.toString());
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            Enumeration<String> e = this.bundle.getKeys();
            HashSet<Map.Entry<String, String>> s = new HashSet<Map.Entry<String, String>>();
            while (e.hasMoreElements()) {
                String k = e.nextElement();
                s.add(new ResourceEntry(k, this.bundle.getString(k)));
            }
            return s;
        }

        @Override
        public String get(Object key) {
            try {
                if (this.bundle.containsKey((String)key)) {
                    return this.bundle.getString((String)key);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            return "???" + key + "???";
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Set<String> keySet() {
            Enumeration<String> e = this.bundle.getKeys();
            HashSet<String> s = new HashSet<String>();
            while (e.hasMoreElements()) {
                s.add(e.nextElement());
            }
            return s;
        }

        @Override
        public String put(String key, String value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.keySet().size();
        }

        @Override
        public Collection<String> values() {
            Enumeration<String> e = this.bundle.getKeys();
            HashSet<String> s = new HashSet<String>();
            while (e.hasMoreElements()) {
                s.add(this.bundle.getString(e.nextElement()));
            }
            return s;
        }

        private static final class ResourceEntry
        implements Map.Entry<String, String> {
            protected final String key;
            protected final String value;

            public ResourceEntry(String key, String value) {
                this.key = key;
                this.value = value;
            }

            @Override
            public String getKey() {
                return this.key;
            }

            @Override
            public String getValue() {
                return this.value;
            }

            @Override
            public String setValue(String value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int hashCode() {
                return this.key.hashCode();
            }

            @Override
            public boolean equals(Object obj) {
                return obj instanceof ResourceEntry && this.hashCode() == obj.hashCode();
            }
        }
    }
}

