/*
 * Decompiled with CFR 0.152.
 */
package org.c02e.jpgpj;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.gpg.keybox.PublicKeyRingBlob;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.c02e.jpgpj.JcaContextHelper;
import org.c02e.jpgpj.Key;
import org.c02e.jpgpj.Subkey;
import org.c02e.jpgpj.util.FileDetection;
import org.c02e.jpgpj.util.Util;

public class Ring
implements Cloneable {
    protected List<Key> keys;

    public Ring() {
        this(new ArrayList<Key>());
    }

    public Ring(Key ... keys) {
        this(Arrays.asList(keys));
    }

    public Ring(List<Key> keys) {
        this.setKeys(keys);
    }

    public Ring(String armor) throws IOException, PGPException {
        this();
        this.load(armor);
    }

    public Ring(File file) throws IOException, PGPException {
        this();
        this.load(file);
    }

    public Ring(InputStream stream) throws IOException, PGPException {
        this();
        this.load(stream);
    }

    public Ring clone() {
        try {
            Ring other = (Ring)this.getClass().cast(super.clone());
            List<Key> thisKeys = this.getKeys();
            other.setKeys(thisKeys == null ? null : thisKeys.stream().map(Key::clone).collect(Collectors.toList()));
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException("Unexpected clone failure for " + this);
        }
    }

    public String toString() {
        if (Util.isEmpty(this.keys)) {
            return "ring empty";
        }
        StringBuilder b = new StringBuilder();
        int count = 0;
        for (Key key : this.keys) {
            if (count++ > 0) {
                b.append("\n\n");
            }
            b.append(key.toString());
        }
        return b.toString();
    }

    public boolean asBoolean() {
        return !Util.isEmpty(this.keys);
    }

    public List<Key> getSigningKeys() {
        ArrayList<Key> a = new ArrayList<Key>(this.keys.size());
        for (Key key : this.keys) {
            if (!key.isForSigning()) continue;
            a.add(key);
        }
        return a;
    }

    public List<Key> getVerificationKeys() {
        ArrayList<Key> a = new ArrayList<Key>(this.keys.size());
        for (Key key : this.keys) {
            if (!key.isForVerification()) continue;
            a.add(key);
        }
        return a;
    }

    public List<Key> getEncryptionKeys() {
        ArrayList<Key> a = new ArrayList<Key>(this.keys.size());
        for (Key key : this.keys) {
            if (!key.isForEncryption()) continue;
            a.add(key);
        }
        return a;
    }

    public List<Key> getDecryptionKeys() {
        ArrayList<Key> a = new ArrayList<Key>(this.keys.size());
        for (Key key : this.keys) {
            if (!key.isForDecryption()) continue;
            a.add(key);
        }
        return a;
    }

    public List<Key> getKeys() {
        return this.keys;
    }

    protected void setKeys(List<Key> x) {
        this.keys = x != null ? x : new ArrayList();
    }

    @Deprecated
    public Key findById(Long id) {
        for (Key key : this.keys) {
            if (key.findById(id) == null) continue;
            return key;
        }
        return null;
    }

    public List<Key> findAll(Long id) {
        if (id == null) {
            return Collections.emptyList();
        }
        ArrayList<Key> result = new ArrayList<Key>();
        for (Key key : this.keys) {
            if (key.findById(id) == null) continue;
            result.add(key);
        }
        return result;
    }

    public List<Key> findAll(String id) {
        if (Util.isEmpty(id)) {
            return Collections.emptyList();
        }
        Pattern regex = Pattern.compile(id, 18);
        return this.findAll(regex);
    }

    public List<Key> findAll(Pattern id) {
        if (id == null) {
            return Collections.emptyList();
        }
        ArrayList<Key> result = new ArrayList<Key>();
        for (Key key : this.keys) {
            if (Util.isEmpty(key.findAll(id))) continue;
            result.add(key);
        }
        return result;
    }

    public void clearSecrets() {
        for (Key key : this.keys) {
            key.clearSecrets();
        }
    }

    public List<Key> load(String armor) throws IOException, PGPException {
        return this.load(new ByteArrayInputStream(armor.getBytes("ASCII")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Key> load(File file) throws IOException, PGPException {
        InputStream stream = null;
        try {
            stream = new BufferedInputStream(new FileInputStream(file), 4096);
            List<Key> list = this.load(stream);
            return list;
        }
        finally {
            try {
                stream.close();
            }
            catch (Exception exception) {}
        }
    }

    public List<Key> load(InputStream stream) throws IOException, PGPException {
        ArrayList<Key> keys = new ArrayList<Key>();
        Iterator<?> packets = this.parse(stream);
        while (packets.hasNext()) {
            Object packet = packets.next();
            if (packet instanceof PGPSecretKeyRing) {
                keys.add(this.newKey((PGPSecretKeyRing)packet));
                continue;
            }
            if (packet instanceof PGPPublicKeyRing) {
                keys.add(this.newKey((PGPPublicKeyRing)packet));
                continue;
            }
            if (!(packet instanceof PublicKeyRingBlob)) continue;
            keys.add(this.newKey(((PublicKeyRingBlob)packet).getPGPPublicKeyRing()));
        }
        this.keys.addAll(keys);
        return keys;
    }

    protected Iterator<?> parse(InputStream stream) throws IOException, PGPException {
        FileDetection.DetectionResult result = FileDetection.detectContainer(stream);
        switch (result.type) {
            case ASCII_ARMOR: {
                result.stream = new ArmoredInputStream(result.stream);
            }
            case PGP: {
                return new PGPObjectFactory(result.stream, (KeyFingerPrintCalculator)JcaContextHelper.getJcaKeyFingerprintCalculator()).iterator();
            }
            case KEYBOX: {
                try {
                    return JcaContextHelper.getJcaKeyBoxBuilder().build(result.stream).getKeyBlobs().iterator();
                }
                catch (NoSuchAlgorithmException | NoSuchProviderException e) {
                    throw new PGPException(e.getMessage(), (Exception)e);
                }
            }
        }
        throw new PGPException("not a keyring");
    }

    protected Key newKey(ArrayList<Subkey> subkeys) {
        return new Key(subkeys);
    }

    protected Key newKey(PGPPublicKeyRing ring) throws PGPException {
        ArrayList<Subkey> subkeys = new ArrayList<Subkey>();
        Iterator i = ring.iterator();
        while (i.hasNext()) {
            subkeys.add(this.newSubkey((PGPPublicKey)i.next()));
        }
        return this.newKey(subkeys);
    }

    protected Key newKey(PGPSecretKeyRing ring) throws PGPException {
        ArrayList<Subkey> subkeys = new ArrayList<Subkey>();
        Iterator i = ring.iterator();
        while (i.hasNext()) {
            subkeys.add(this.newSubkey((PGPSecretKey)i.next()));
        }
        return this.newKey(subkeys);
    }

    protected Subkey newSubkey() {
        return new Subkey();
    }

    protected Subkey newSubkey(PGPPublicKey k) throws PGPException {
        Subkey subkey = this.newSubkey();
        subkey.setPublicKey(k);
        return subkey;
    }

    protected Subkey newSubkey(PGPSecretKey k) throws PGPException {
        Subkey subkey = this.newSubkey();
        subkey.setSecretKey(k);
        return subkey;
    }
}

