/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.monitoring;

import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import jersey.repackaged.com.google.common.base.Function;
import jersey.repackaged.com.google.common.collect.Maps;
import org.glassfish.jersey.server.internal.monitoring.ApplicationStatisticsImpl;
import org.glassfish.jersey.server.internal.monitoring.ExceptionMapperStatisticsImpl;
import org.glassfish.jersey.server.internal.monitoring.ExecutionStatisticsImpl;
import org.glassfish.jersey.server.internal.monitoring.ResourceStatisticsImpl;
import org.glassfish.jersey.server.internal.monitoring.ResponseStatisticsImpl;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceModel;
import org.glassfish.jersey.server.monitoring.ApplicationStatistics;
import org.glassfish.jersey.server.monitoring.ExceptionMapperStatistics;
import org.glassfish.jersey.server.monitoring.ExecutionStatistics;
import org.glassfish.jersey.server.monitoring.MonitoringStatistics;
import org.glassfish.jersey.server.monitoring.ResourceStatistics;

class MonitoringStatisticsImpl
implements MonitoringStatistics {
    private final ExecutionStatistics requestStatistics;
    private final ResponseStatisticsImpl responseStatisticsImpl;
    private final ApplicationStatistics applicationStatistics;
    private final ExceptionMapperStatistics exceptionMapperStatistics;
    private final Map<String, ResourceStatistics> uriStatistics;
    private final Map<Class<?>, ResourceStatistics> resourceClassStatistics;

    private MonitoringStatisticsImpl(Map<String, ResourceStatistics> uriStatistics, Map<Class<?>, ResourceStatistics> resourceClassStatistics, ExecutionStatistics requestStatistics, ResponseStatisticsImpl responseStatistics, ApplicationStatistics applicationStatistics, ExceptionMapperStatistics exceptionMapperStatistics) {
        this.uriStatistics = uriStatistics;
        this.resourceClassStatistics = resourceClassStatistics;
        this.requestStatistics = requestStatistics;
        this.responseStatisticsImpl = responseStatistics;
        this.applicationStatistics = applicationStatistics;
        this.exceptionMapperStatistics = exceptionMapperStatistics;
    }

    @Override
    public ExecutionStatistics getRequestStatistics() {
        return this.requestStatistics;
    }

    @Override
    public ResponseStatisticsImpl getResponseStatistics() {
        return this.responseStatisticsImpl;
    }

    @Override
    public Map<String, ResourceStatistics> getUriStatistics() {
        return this.uriStatistics;
    }

    @Override
    public Map<Class<?>, ResourceStatistics> getResourceClassStatistics() {
        return this.resourceClassStatistics;
    }

    @Override
    public ApplicationStatistics getApplicationStatistics() {
        return this.applicationStatistics;
    }

    @Override
    public ExceptionMapperStatistics getExceptionMapperStatistics() {
        return this.exceptionMapperStatistics;
    }

    @Override
    public MonitoringStatistics snapshot() {
        return this;
    }

    static class Builder {
        private ExecutionStatisticsImpl.Builder requestStatisticsBuilder;
        private final ResponseStatisticsImpl.Builder responseStatisticsBuilder;
        private ApplicationStatisticsImpl applicationStatisticsImpl;
        private ExceptionMapperStatisticsImpl.Builder exceptionMapperStatisticsBuilder;
        private SortedMap<String, ResourceStatisticsImpl.Builder> uriStatistics = Maps.newTreeMap();
        private SortedMap<Class<?>, ResourceStatisticsImpl.Builder> resourceClassStatistics = Maps.newTreeMap((Comparator)new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> o1, Class<?> o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });

        Builder() {
            this.requestStatisticsBuilder = new ExecutionStatisticsImpl.Builder();
            this.responseStatisticsBuilder = new ResponseStatisticsImpl.Builder();
            this.exceptionMapperStatisticsBuilder = new ExceptionMapperStatisticsImpl.Builder();
        }

        public Builder(ResourceModel resourceModel) {
            this();
            for (Resource resource : resourceModel.getRootResources()) {
                this.processResource(resource, "");
                for (Resource child : resource.getChildResources()) {
                    this.processResource(child, "/" + resource.getPath());
                }
            }
        }

        private void processResource(Resource resource, String pathPrefix) {
            this.uriStatistics.put(pathPrefix + "/" + resource.getPath(), new ResourceStatisticsImpl.Builder(resource));
            for (ResourceMethod resourceMethod : resource.getResourceMethods()) {
                ResourceStatisticsImpl.Builder builder = this.getOrCreateResourceBuilder(resourceMethod);
                builder.addMethod(resourceMethod);
            }
        }

        private ResourceStatisticsImpl.Builder getOrCreateResourceBuilder(ResourceMethod resourceMethod) {
            Class<?> clazz = resourceMethod.getInvocable().getHandler().getHandlerClass();
            ResourceStatisticsImpl.Builder builder = (ResourceStatisticsImpl.Builder)this.resourceClassStatistics.get(clazz);
            if (builder == null) {
                builder = new ResourceStatisticsImpl.Builder();
                this.resourceClassStatistics.put(clazz, builder);
            }
            return builder;
        }

        ExecutionStatisticsImpl.Builder getRequestStatisticsBuilder() {
            return this.requestStatisticsBuilder;
        }

        ExceptionMapperStatisticsImpl.Builder getExceptionMapperStatisticsBuilder() {
            return this.exceptionMapperStatisticsBuilder;
        }

        void addExecution(String uri, ResourceMethod resourceMethod, long methodTime, long methodDuration, long requestTime, long requestDuration) {
            ResourceStatisticsImpl.Builder uriStatsBuilder = (ResourceStatisticsImpl.Builder)this.uriStatistics.get(uri);
            if (uriStatsBuilder == null) {
                uriStatsBuilder = new ResourceStatisticsImpl.Builder(resourceMethod.getParent());
                this.uriStatistics.put(uri, uriStatsBuilder);
            }
            uriStatsBuilder.addExecution(resourceMethod, methodTime, methodDuration, requestTime, requestDuration);
            ResourceStatisticsImpl.Builder resourceClassBuilder = this.getOrCreateResourceBuilder(resourceMethod);
            resourceClassBuilder.addExecution(resourceMethod, methodTime, methodDuration, requestTime, requestDuration);
        }

        void addResponseCode(int responseCode) {
            this.responseStatisticsBuilder.addResponseCode(responseCode);
        }

        void setApplicationStatisticsImpl(ApplicationStatisticsImpl applicationStatisticsImpl) {
            this.applicationStatisticsImpl = applicationStatisticsImpl;
        }

        MonitoringStatisticsImpl build() {
            Function<ResourceStatisticsImpl.Builder, ResourceStatistics> buildingFunction = new Function<ResourceStatisticsImpl.Builder, ResourceStatistics>(){

                public ResourceStatistics apply(ResourceStatisticsImpl.Builder builder) {
                    return builder.build();
                }
            };
            Map uriStats = Collections.unmodifiableMap(Maps.transformValues(this.uriStatistics, (Function)buildingFunction));
            Map classStats = Collections.unmodifiableMap(Maps.transformValues(this.resourceClassStatistics, (Function)buildingFunction));
            return new MonitoringStatisticsImpl(uriStats, classStats, this.requestStatisticsBuilder.build(), this.responseStatisticsBuilder.build(), this.applicationStatisticsImpl, this.exceptionMapperStatisticsBuilder.build());
        }
    }
}

