/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.token.impl;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.token.impl.TokenStatePeristerMonitorListener;
import org.apache.knox.gateway.services.token.impl.TokenStateServiceMessages;
import org.apache.knox.gateway.util.ExecutorServiceUtils;

class TokenStatePersisterMonitor {
    private static final TokenStateServiceMessages log = (TokenStateServiceMessages)MessagesFactory.get(TokenStateServiceMessages.class);
    private final ExecutorService monitor = Executors.newSingleThreadExecutor((ThreadFactory)new BasicThreadFactory.Builder().namingPattern("TokenStatePeristerMonitor-%d").build());
    private final ScheduledFuture<?> taskToMonitor;
    private final Set<TokenStatePeristerMonitorListener> listeners;

    TokenStatePersisterMonitor(ScheduledFuture<?> taskToMonitor, TokenStatePeristerMonitorListener listener) {
        this(taskToMonitor, Collections.singleton(listener));
    }

    TokenStatePersisterMonitor(ScheduledFuture<?> taskToMonitor, Set<TokenStatePeristerMonitorListener> listeners) {
        this.taskToMonitor = taskToMonitor;
        this.listeners = listeners;
    }

    void startMonitor() {
        this.monitor.submit(this::monitorPersisterTask);
    }

    private void monitorPersisterTask() {
        try {
            this.taskToMonitor.get();
        }
        catch (CancellationException e) {
            log.cancelingTokenStateAliasePersisterTask();
        }
        catch (Throwable e) {
            log.errorRunningTokenStateAliasePersisterTask(e);
            this.listeners.forEach(listener -> listener.onTokenStatePeristerTaskError(e));
        }
        finally {
            ExecutorServiceUtils.shutdownAndAwaitTermination((ExecutorService)this.monitor, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        }
    }
}

