/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.service;

import org.apache.camel.RuntimeCamelException;
import org.apache.camel.ServiceStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseService {
    protected static final byte NEW = 0;
    protected static final byte BUILDED = 1;
    protected static final byte INITIALIZING = 2;
    protected static final byte INITIALIZED = 3;
    protected static final byte STARTING = 4;
    protected static final byte STARTED = 5;
    protected static final byte SUSPENDING = 6;
    protected static final byte SUSPENDED = 7;
    protected static final byte STOPPING = 8;
    protected static final byte STOPPED = 9;
    protected static final byte SHUTTINGDOWN = 10;
    protected static final byte SHUTDOWN = 11;
    protected static final byte FAILED = 12;
    private static final Logger LOG = LoggerFactory.getLogger(BaseService.class);
    protected final Object lock = new Object();
    protected volatile byte status = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build() {
        if (this.status == 0) {
            Object object = this.lock;
            synchronized (object) {
                if (this.status == 0) {
                    LOG.trace("Building service: {}", (Object)this);
                    try (AutoCloseable ignored = this.doLifecycleChange();){
                        this.doBuild();
                    }
                    catch (Exception e) {
                        this.doFail(e);
                    }
                    this.status = 1;
                    LOG.trace("Built service: {}", (Object)this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (this.status <= 1 || this.status >= 9) {
            Object object = this.lock;
            synchronized (object) {
                if (this.status <= 1 || this.status >= 9) {
                    this.build();
                    LOG.trace("Initializing service: {}", (Object)this);
                    try (AutoCloseable ignored = this.doLifecycleChange();){
                        this.status = (byte)2;
                        this.doInit();
                        this.status = (byte)3;
                        LOG.trace("Initialized service: {}", (Object)this);
                    }
                    catch (Exception e) {
                        LOG.trace("Error while initializing service: " + this, (Throwable)e);
                        this.fail(e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == 5) {
                LOG.trace("Service: {} already started", (Object)this);
                return;
            }
            if (this.status == 4) {
                LOG.trace("Service: {} already starting", (Object)this);
                return;
            }
            this.init();
            try (AutoCloseable ignored = this.doLifecycleChange();){
                this.status = (byte)4;
                LOG.trace("Starting service: {}", (Object)this);
                this.doStart();
                this.status = (byte)5;
                LOG.trace("Started service: {}", (Object)this);
            }
            catch (Exception e) {
                try {
                    this.stop();
                }
                catch (Exception e2) {
                    LOG.trace("Error while stopping service after it failed to start: " + this + ". This exception is ignored", (Throwable)e);
                }
                LOG.trace("Error while starting service: " + this, (Throwable)e);
                this.fail(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == 12) {
                LOG.trace("Service: {} failed and regarded as already stopped", (Object)this);
                return;
            }
            if (this.status == 9 || this.status == 10 || this.status == 11) {
                LOG.trace("Service: {} already stopped", (Object)this);
                return;
            }
            if (this.status == 8) {
                LOG.trace("Service: {} already stopping", (Object)this);
                return;
            }
            this.status = (byte)8;
            LOG.trace("Stopping service: {}", (Object)this);
            try (AutoCloseable ignored = this.doLifecycleChange();){
                this.doStop();
                this.status = (byte)9;
                LOG.trace("Stopped: {} service", (Object)this);
            }
            catch (Exception e) {
                LOG.trace("Error while stopping service: " + this, (Throwable)e);
                this.fail(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == 7) {
                LOG.trace("Service: {} already suspended", (Object)this);
                return;
            }
            if (this.status == 6) {
                LOG.trace("Service: {} already suspending", (Object)this);
                return;
            }
            this.status = (byte)6;
            LOG.trace("Suspending service: {}", (Object)this);
            try (AutoCloseable ignored = this.doLifecycleChange();){
                this.doSuspend();
                this.status = (byte)7;
                LOG.trace("Suspended service: {}", (Object)this);
            }
            catch (Exception e) {
                LOG.trace("Error while suspending service: " + this, (Throwable)e);
                this.fail(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.lock;
        synchronized (object) {
            if (this.status != 7) {
                LOG.trace("Service is not suspended: {}", (Object)this);
                return;
            }
            this.status = (byte)4;
            LOG.trace("Resuming service: {}", (Object)this);
            try (AutoCloseable ignored = this.doLifecycleChange();){
                this.doResume();
                this.status = (byte)5;
                LOG.trace("Resumed service: {}", (Object)this);
            }
            catch (Exception e) {
                LOG.trace("Error while resuming service: " + this, (Throwable)e);
                this.fail(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == 11) {
                LOG.trace("Service: {} already shutdown", (Object)this);
                return;
            }
            if (this.status == 10) {
                LOG.trace("Service: {} already shutting down", (Object)this);
                return;
            }
            this.stop();
            this.status = (byte)11;
            LOG.trace("Shutting down service: {}", (Object)this);
            try (AutoCloseable ignored = this.doLifecycleChange();){
                this.doShutdown();
                LOG.trace("Shutdown service: {}", (Object)this);
                this.status = (byte)11;
            }
            catch (Exception e) {
                LOG.trace("Error shutting down service: " + this, (Throwable)e);
                this.fail(e);
            }
        }
    }

    public ServiceStatus getStatus() {
        switch (this.status) {
            case 2: {
                return ServiceStatus.Initializing;
            }
            case 3: {
                return ServiceStatus.Initialized;
            }
            case 4: {
                return ServiceStatus.Starting;
            }
            case 5: {
                return ServiceStatus.Started;
            }
            case 6: {
                return ServiceStatus.Suspending;
            }
            case 7: {
                return ServiceStatus.Suspended;
            }
            case 8: {
                return ServiceStatus.Stopping;
            }
        }
        return ServiceStatus.Stopped;
    }

    public boolean isNew() {
        return this.status == 0;
    }

    public boolean isBuild() {
        return this.status == 1;
    }

    public boolean isInit() {
        return this.status == 3;
    }

    public boolean isStarted() {
        return this.status == 5;
    }

    public boolean isStarting() {
        return this.status == 4;
    }

    public boolean isStopping() {
        return this.status == 8;
    }

    public boolean isStopped() {
        return this.status < 4 || this.status >= 9;
    }

    public boolean isSuspending() {
        return this.status == 6;
    }

    public boolean isSuspended() {
        return this.status == 7;
    }

    public boolean isRunAllowed() {
        return this.status >= 4 && this.status <= 7;
    }

    public boolean isShutdown() {
        return this.status == 11;
    }

    public boolean isStoppingOrStopped() {
        return this.status < 4 || this.status > 7;
    }

    public boolean isSuspendingOrSuspended() {
        return this.status == 6 || this.status == 7;
    }

    public boolean isStartingOrStarted() {
        return this.status == 4 || this.status == 5;
    }

    protected void fail(Exception e) {
        try {
            this.doFail(e);
        }
        finally {
            this.status = (byte)12;
        }
    }

    protected void doBuild() throws Exception {
    }

    protected void doInit() throws Exception {
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    protected void doSuspend() throws Exception {
    }

    protected void doResume() throws Exception {
    }

    protected void doShutdown() throws Exception {
    }

    protected void doFail(Exception e) {
        throw RuntimeCamelException.wrapRuntimeException(e);
    }

    protected AutoCloseable doLifecycleChange() {
        return null;
    }
}

