/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.result;

import aQute.bnd.exceptions.ConsumerWithException;
import aQute.bnd.exceptions.Exceptions;
import aQute.bnd.exceptions.FunctionWithException;
import aQute.bnd.exceptions.SupplierWithException;
import aQute.bnd.result.Result;
import aQute.bnd.result.ResultException;
import java.util.Objects;
import java.util.Optional;

final class Err<V>
implements Result<V> {
    private final String error;

    Err(CharSequence error) {
        this.error = Objects.requireNonNull(error.toString());
    }

    @Override
    public boolean isOk() {
        return false;
    }

    @Override
    public boolean isErr() {
        return true;
    }

    @Override
    public Optional<V> value() {
        return Optional.empty();
    }

    @Override
    public Optional<String> error() {
        return Optional.of(this.error);
    }

    @Override
    public V unwrap() {
        throw new ResultException("Not an Ok value");
    }

    @Override
    public V unwrap(CharSequence message) throws ResultException {
        throw new ResultException(message.toString());
    }

    @Override
    public V orElse(V orElse) {
        return orElse;
    }

    @Override
    public V orElseGet(SupplierWithException<? extends V> orElseSupplier) {
        try {
            return orElseSupplier.get();
        }
        catch (Exception e) {
            throw Exceptions.duck(e);
        }
    }

    @Override
    public <R extends Throwable> V orElseThrow(FunctionWithException<? super String, ? extends R> throwableSupplier) throws R {
        Throwable r;
        Objects.requireNonNull(throwableSupplier);
        try {
            r = Objects.requireNonNull((Throwable)throwableSupplier.apply(this.error));
        }
        catch (Exception e) {
            throw Exceptions.duck(e);
        }
        throw r;
    }

    @Override
    public <U> Result<U> map(FunctionWithException<? super V, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return this.asError();
    }

    @Override
    public Result<V> mapErr(FunctionWithException<? super String, ? extends CharSequence> mapper) {
        try {
            return Result.err(mapper.apply(this.error));
        }
        catch (Exception e) {
            throw Exceptions.duck(e);
        }
    }

    @Override
    public <U> Result<U> flatMap(FunctionWithException<? super V, ? extends Result<? extends U>> mapper) {
        Objects.requireNonNull(mapper);
        return this.asError();
    }

    @Override
    public Result<V> recover(FunctionWithException<? super String, ? extends V> recover) {
        try {
            V v = recover.apply(this.error);
            return v != null ? Result.ok(v) : this;
        }
        catch (Exception e) {
            throw Exceptions.duck(e);
        }
    }

    @Override
    public Result<V> recoverWith(FunctionWithException<? super String, ? extends Result<? extends V>> recover) {
        try {
            Result<? extends V> result = Objects.requireNonNull(recover.apply(this.error));
            return result;
        }
        catch (Exception e) {
            throw Exceptions.duck(e);
        }
    }

    @Override
    public void accept(ConsumerWithException<? super V> ok, ConsumerWithException<? super String> err) {
        Objects.requireNonNull(ok);
        try {
            err.accept(this.error);
        }
        catch (Exception e) {
            throw Exceptions.duck(e);
        }
    }

    @Override
    public <U> Result<U> asError() {
        Err coerced = this;
        return coerced;
    }

    public String toString() {
        return String.format("Err(%s)", this.error);
    }
}

