/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.BinaryPredicate;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.util.ObjectHelper;

public final class PredicateAssertHelper {
    private PredicateAssertHelper() {
    }

    public static void assertMatches(Predicate predicate, String text, Exchange exchange) {
        ObjectHelper.notNull((Object)predicate, (String)"predicate");
        ObjectHelper.notNull((Object)exchange, (String)"exchange");
        if (predicate instanceof BinaryPredicate) {
            BinaryPredicate eval = (BinaryPredicate)predicate;
            String evalText = eval.matchesReturningFailureMessage(exchange);
            if (evalText != null) {
                throw new AssertionError((Object)(text + predicate + " evaluated as: " + evalText + " on " + exchange));
            }
        } else {
            PredicateAssertHelper.doAssertMatches(predicate, text, exchange);
        }
    }

    private static void doAssertMatches(Predicate predicate, String text, Exchange exchange) {
        if (!predicate.matches(exchange)) {
            if (text == null) {
                throw new AssertionError((Object)(predicate + " on " + exchange));
            }
            throw new AssertionError((Object)(text + predicate + " on " + exchange));
        }
    }
}

