/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.compression;

import java.io.Closeable;
import org.eclipse.jetty.util.ConcurrentPool;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.Pool;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;

@ManagedObject
public abstract class CompressionPool<T>
extends ContainerLifeCycle {
    public static final int DEFAULT_CAPACITY = 1024;
    private int _capacity;
    private Pool<Entry> _pool;

    public CompressionPool(int capacity) {
        this._capacity = capacity;
    }

    public int getCapacity() {
        return this._capacity;
    }

    public void setCapacity(int capacity) {
        if (this.isStarted()) {
            throw new IllegalStateException("Already Started");
        }
        this._capacity = capacity;
    }

    public Pool<Entry> getPool() {
        return this._pool;
    }

    protected abstract T newPooled();

    protected abstract void end(T var1);

    protected abstract void reset(T var1);

    public Entry acquire() {
        Pool.Entry<Entry> acquiredEntry;
        Entry entry = null;
        if (this._pool != null && (acquiredEntry = this._pool.acquire(e2 -> new Entry(this.newPooled(), (Pool.Entry<Entry>)e2))) != null) {
            entry = acquiredEntry.getPooled();
        }
        return entry == null ? new Entry(this.newPooled()) : entry;
    }

    public void release(Entry entry) {
        entry.release();
    }

    @Override
    protected void doStart() throws Exception {
        if (this._capacity > 0) {
            this._pool = new ConcurrentPool<Entry>(ConcurrentPool.StrategyType.THREAD_ID, this._capacity);
            this.addBean(this._pool);
        }
        super.doStart();
    }

    @Override
    public void doStop() throws Exception {
        super.doStop();
        if (this._pool != null) {
            this.removeBean(this._pool);
            this._pool.terminate().stream().map(Pool.Entry::getPooled).forEach(IO::close);
        }
    }

    @Override
    public String toString() {
        return String.format("%s@%x{%s,size=%d,capacity=%s}", TypeUtil.toShortName(this.getClass()), this.hashCode(), this.getState(), this._pool == null ? -1 : this._pool.size(), this._capacity);
    }

    public class Entry
    implements Closeable {
        private final T _value;
        private final Pool.Entry<Entry> _entry;

        Entry(T value) {
            this(value, null);
        }

        Entry(T value, Pool.Entry<Entry> entry) {
            this._value = value;
            this._entry = entry;
        }

        public T get() {
            return this._value;
        }

        public void release() {
            CompressionPool.this.reset(this._value);
            if (this._entry != null) {
                if (!this._entry.release() && this._entry.remove()) {
                    this.close();
                }
            } else {
                this.close();
            }
        }

        @Override
        public void close() {
            CompressionPool.this.end(this._value);
        }
    }
}

