/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.sis.metadata.CacheKey;
import org.apache.sis.metadata.HashCode;
import org.apache.sis.metadata.IndexMap;
import org.apache.sis.metadata.InformationMap;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.metadata.NameMap;
import org.apache.sis.metadata.ObjectPair;
import org.apache.sis.metadata.PropertyAccessor;
import org.apache.sis.metadata.SpecialCases;
import org.apache.sis.metadata.StandardImplementation;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.TreeTableView;
import org.apache.sis.metadata.TypeMap;
import org.apache.sis.metadata.TypeValuePolicy;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.metadata.ValueMap;
import org.apache.sis.metadata.simple.SimpleCitation;
import org.apache.sis.system.Semaphores;
import org.apache.sis.system.SystemListener;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.internal.Strings;
import org.opengis.metadata.ExtendedElementInformation;
import org.opengis.metadata.citation.Citation;

public class MetadataStandard
implements Serializable {
    private static final long serialVersionUID = 7549790450195184843L;
    static final boolean IMPLEMENTATION_CAN_ALTER_API = true;
    static final MetadataStandard[] INSTANCES;
    public static final MetadataStandard ISO_19115;
    public static final MetadataStandard ISO_19157;
    public static final MetadataStandard ISO_19111;
    public static final MetadataStandard ISO_19123;
    final Citation citation;
    final String interfacePackage;
    private final MetadataStandard[] dependencies;
    private transient ConcurrentMap<CacheKey, Object> accessors;

    public MetadataStandard(Citation citation, Package interfacePackage, MetadataStandard ... dependencies) {
        ArgumentChecks.ensureNonNull("citation", citation);
        ArgumentChecks.ensureNonNull("interfacePackage", interfacePackage);
        ArgumentChecks.ensureNonNull("dependencies", dependencies);
        this.citation = citation;
        this.interfacePackage = interfacePackage.getName() + ".";
        this.accessors = new ConcurrentHashMap<CacheKey, Object>();
        if (dependencies.length == 0) {
            this.dependencies = null;
        } else {
            dependencies = (MetadataStandard[])dependencies.clone();
            this.dependencies = dependencies;
            for (int i = 0; i < dependencies.length; ++i) {
                ArgumentChecks.ensureNonNullElement("dependencies", i, dependencies[i]);
            }
        }
    }

    MetadataStandard(String citation, String interfacePackage, MetadataStandard ... dependencies) {
        this.citation = new SimpleCitation(citation);
        this.interfacePackage = interfacePackage;
        this.accessors = new ConcurrentHashMap<CacheKey, Object>();
        this.dependencies = dependencies;
    }

    final boolean isSupported(String classname) {
        return classname.startsWith(this.interfacePackage);
    }

    public static MetadataStandard forClass(Class<?> type) {
        String classname = type.getName();
        for (MetadataStandard metadataStandard : INSTANCES) {
            if (!metadataStandard.isSupported(classname)) continue;
            return metadataStandard;
        }
        for (Serializable serializable : Classes.getAllInterfaces(type)) {
            classname = ((Class)serializable).getName();
            for (MetadataStandard candidate : INSTANCES) {
                if (!candidate.isSupported(classname)) continue;
                return candidate;
            }
        }
        return null;
    }

    static void clearCache() {
        for (MetadataStandard standard : INSTANCES) {
            standard.accessors.clear();
        }
    }

    public Citation getCitation() {
        return this.citation;
    }

    private CacheKey createCacheKey(Class<?> type) {
        Class<?> implementation = this.getImplementation(type);
        if (implementation != null) {
            type = implementation;
        }
        return new CacheKey(type);
    }

    final PropertyAccessor getAccessor(CacheKey key, boolean mandatory) {
        Class<?> type;
        Object value = this.accessors.get(key);
        if (value instanceof PropertyAccessor) {
            return (PropertyAccessor)value;
        }
        if (value instanceof Class) {
            type = (Class<?>)value;
            assert (type == this.findInterface(key)) : key;
        } else if (key.isValid()) {
            type = this.findInterface(key);
            if (type == null) {
                if (this.dependencies != null) {
                    for (MetadataStandard dependency : this.dependencies) {
                        PropertyAccessor accessor = dependency.getAccessor(key, false);
                        if (accessor == null) continue;
                        this.accessors.put(key, accessor);
                        return accessor;
                    }
                }
                if (mandatory) {
                    throw new ClassCastException(key.unrecognized());
                }
                return null;
            }
        } else {
            throw new ClassCastException(key.invalid());
        }
        return (PropertyAccessor)this.accessors.compute(key, (k, v) -> {
            if (v instanceof PropertyAccessor) {
                return v;
            }
            Class standardImpl = this.getImplementation(type);
            PropertyAccessor accessor = SpecialCases.isSpecialCase(type) ? new SpecialCases(type, k.type, standardImpl) : new PropertyAccessor(type, k.type, standardImpl);
            return accessor;
        });
    }

    public boolean isMetadata(Class<?> type) {
        return type != null && !type.isPrimitive() && this.isMetadata(new CacheKey(type));
    }

    private boolean isMetadata(CacheKey key) {
        Class<?> standardType;
        assert (key.isValid()) : key;
        if (this.accessors.containsKey(key)) {
            return true;
        }
        if (this.dependencies != null) {
            for (MetadataStandard dependency : this.dependencies) {
                if (!dependency.isMetadata(key)) continue;
                this.accessors.putIfAbsent(key, dependency);
                return true;
            }
        }
        if ((standardType = this.findInterface(key)) != null) {
            this.accessors.putIfAbsent(key, standardType);
            return true;
        }
        return false;
    }

    boolean isPendingAPI(Class<?> type) {
        return false;
    }

    private Class<?> findInterface(CacheKey key) {
        assert (key.isValid()) : key;
        if (key.type.isInterface()) {
            if (this.isSupported(key.type.getName())) {
                return key.type;
            }
        } else {
            Class candidate;
            LinkedHashSet interfaces = new LinkedHashSet();
            for (Class<?> t = key.type; t != null; t = t.getSuperclass()) {
                this.getInterfaces(t, key.propertyType, interfaces);
            }
            Iterator it = interfaces.iterator();
            block1: while (it.hasNext()) {
                candidate = (Class)it.next();
                for (Class clazz : interfaces) {
                    if (candidate == clazz || !candidate.isAssignableFrom(clazz)) continue;
                    it.remove();
                    continue block1;
                }
            }
            it = interfaces.iterator();
            if (it.hasNext()) {
                candidate = (Class)it.next();
                if (!it.hasNext()) {
                    return candidate;
                }
            } else if (this.isPendingAPI(key.type)) {
                return key.type;
            }
        }
        return null;
    }

    private void getInterfaces(Class<?> type, Class<?> propertyType, Collection<Class<?>> interfaces) {
        for (Class<?> candidate : type.getInterfaces()) {
            if (propertyType.isAssignableFrom(candidate)) {
                if (this.isSupported(candidate.getName())) {
                    interfaces.add(candidate);
                }
                this.getInterfaces(candidate, propertyType, interfaces);
                continue;
            }
            if (!this.isPendingAPI(propertyType) || !this.isSupported(candidate.getName())) continue;
            interfaces.add(candidate);
        }
    }

    public <T> Class<? super T> getInterface(Class<T> type) throws ClassCastException {
        ArgumentChecks.ensureNonNull("type", type);
        return this.getInterface(new CacheKey(type));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final <T> Class<? super T> getInterface(CacheKey key) throws ClassCastException {
        void var2_7;
        Object value = this.accessors.get(key);
        if (value instanceof PropertyAccessor) {
            Class<?> clazz = ((PropertyAccessor)value).type;
        } else if (value instanceof Class) {
            Class clazz = (Class)value;
        } else if (value instanceof MetadataStandard) {
            Class<T> clazz = ((MetadataStandard)value).getInterface(key);
        } else {
            if (!key.isValid()) throw new ClassCastException(key.invalid());
            Class<?> clazz = this.findInterface(key);
            if (clazz != null) {
                this.accessors.putIfAbsent(key, clazz);
            } else {
                if (this.dependencies == null) throw new ClassCastException(key.unrecognized());
                for (MetadataStandard dependency : this.dependencies) {
                    if (!dependency.isMetadata(key)) continue;
                    this.accessors.putIfAbsent(key, dependency);
                    return dependency.getInterface(key);
                }
                throw new ClassCastException(key.unrecognized());
            }
        }
        assert (var2_7.isAssignableFrom(key.type)) : key;
        return var2_7;
    }

    public <T> Class<? extends T> getImplementation(Class<T> type) {
        return null;
    }

    final Object getTitle(Object metadata) {
        TitleProperty an;
        Class<?> type;
        PropertyAccessor accessor;
        if (metadata != null && (accessor = this.getAccessor(this.createCacheKey(type = metadata.getClass()), false)) != null && ((an = type.getAnnotation(TitleProperty.class)) != null || (an = accessor.implementation.getAnnotation(TitleProperty.class)) != null)) {
            return accessor.get(accessor.indexOf(an.name(), false), metadata);
        }
        return null;
    }

    public Map<String, String> asNameMap(Class<?> type, KeyNamePolicy keyPolicy, KeyNamePolicy valuePolicy) throws ClassCastException {
        ArgumentChecks.ensureNonNull("type", type);
        ArgumentChecks.ensureNonNull("keyPolicy", (Object)keyPolicy);
        ArgumentChecks.ensureNonNull("valuePolicy", (Object)valuePolicy);
        return new NameMap(this.getAccessor(this.createCacheKey(type), true), keyPolicy, valuePolicy);
    }

    public Map<String, Class<?>> asTypeMap(Class<?> type, KeyNamePolicy keyPolicy, TypeValuePolicy valuePolicy) throws ClassCastException {
        ArgumentChecks.ensureNonNull("type", type);
        ArgumentChecks.ensureNonNull("keyPolicy", (Object)keyPolicy);
        ArgumentChecks.ensureNonNull("valuePolicy", (Object)valuePolicy);
        return new TypeMap(this.getAccessor(this.createCacheKey(type), true), keyPolicy, valuePolicy);
    }

    public Map<String, ExtendedElementInformation> asInformationMap(Class<?> type, KeyNamePolicy keyPolicy) throws ClassCastException {
        ArgumentChecks.ensureNonNull("type", type);
        ArgumentChecks.ensureNonNull("keyNames", (Object)keyPolicy);
        return new InformationMap(this.citation, this.getAccessor(this.createCacheKey(type), true), keyPolicy);
    }

    public Map<String, Integer> asIndexMap(Class<?> type, KeyNamePolicy keyPolicy) throws ClassCastException {
        ArgumentChecks.ensureNonNull("type", type);
        ArgumentChecks.ensureNonNull("keyPolicy", (Object)keyPolicy);
        return new IndexMap(this.getAccessor(this.createCacheKey(type), true), keyPolicy);
    }

    public Map<String, Object> asValueMap(Object metadata, Class<?> baseType, KeyNamePolicy keyPolicy, ValueExistencePolicy valuePolicy) throws ClassCastException {
        ArgumentChecks.ensureNonNull("metadata", metadata);
        ArgumentChecks.ensureNonNull("keyPolicy", (Object)keyPolicy);
        ArgumentChecks.ensureNonNull("valuePolicy", (Object)valuePolicy);
        return new ValueMap(metadata, this.getAccessor(new CacheKey(metadata.getClass(), baseType), true), keyPolicy, valuePolicy);
    }

    public TreeTable asTreeTable(Object metadata, Class<?> baseType, ValueExistencePolicy valuePolicy) throws ClassCastException {
        ArgumentChecks.ensureNonNull("metadata", metadata);
        ArgumentChecks.ensureNonNull("valuePolicy", (Object)valuePolicy);
        if (baseType == null) {
            baseType = this.getInterface(metadata.getClass());
        }
        return new TreeTableView(this, metadata, baseType, valuePolicy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object metadata1, Object metadata2, ComparisonMode mode) throws ClassCastException {
        Class<?> type2;
        if (metadata1 == metadata2) {
            return true;
        }
        if (metadata1 == null || metadata2 == null) {
            return false;
        }
        Class<?> type1 = metadata1.getClass();
        if (type1 != (type2 = metadata2.getClass()) && mode == ComparisonMode.STRICT) {
            return false;
        }
        PropertyAccessor accessor = this.getAccessor(new CacheKey(type1), true);
        if (!(type1 == type2 || accessor.type.isAssignableFrom(type2) && accessor.type == this.getAccessor((CacheKey)new CacheKey(type2), (boolean)false).type)) {
            return false;
        }
        ObjectPair pair = new ObjectPair(metadata1, metadata2);
        Set<ObjectPair> inProgress = ObjectPair.CURRENT.get();
        if (inProgress.add(pair)) {
            boolean allowNull = Semaphores.queryAndSet(1);
            try {
                boolean bl = accessor.equals(metadata1, metadata2, mode);
                return bl;
            }
            finally {
                inProgress.remove(pair);
                Semaphores.clear(1, allowNull);
            }
        }
        return true;
    }

    public int hashCode(Object metadata) throws ClassCastException {
        Integer hash;
        if (metadata != null && (hash = (Integer)HashCode.getOrCreate().walk(this, null, metadata, true)) != null) {
            return hash;
        }
        return 0;
    }

    public String toString() {
        return Strings.bracket(this.getClass(), (Object)this.citation.getTitle());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.accessors = new ConcurrentHashMap<CacheKey, Object>();
    }

    static {
        String[] acronyms = new String[]{"CoordinateSystem", "CS", "CoordinateReferenceSystem", "CRS"};
        ISO_19115 = new StandardImplementation("ISO 19115", "org.opengis.metadata.", "org.apache.sis.metadata.iso.", null, (MetadataStandard[])null);
        ISO_19157 = new StandardImplementation("ISO 19157", "org.opengis.metadata.quality.", "org.apache.sis.metadata.iso.quality.", null, ISO_19115);
        ISO_19111 = new StandardImplementation("ISO 19111", "org.opengis.referencing.", "org.apache.sis.referencing.", acronyms, ISO_19157, ISO_19115);
        ISO_19123 = new MetadataStandard("ISO 19123", "org.opengis.coverage.", ISO_19111);
        INSTANCES = new MetadataStandard[]{ISO_19157, ISO_19115, ISO_19111, ISO_19123};
        SystemListener.add(new SystemListener("org.apache.sis.metadata"){

            @Override
            protected void classpathChanged() {
                MetadataStandard.clearCache();
            }
        });
    }
}

