/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.base.recordbuffer;

import java.nio.ByteBuffer;
import org.apache.jena.dboe.base.block.Block;
import org.apache.jena.dboe.base.block.BlockMgr;
import org.apache.jena.dboe.base.block.BlockType;
import org.apache.jena.dboe.base.page.BlockConverter;
import org.apache.jena.dboe.base.page.PageBlockMgr;
import org.apache.jena.dboe.base.record.RecordException;
import org.apache.jena.dboe.base.record.RecordFactory;
import org.apache.jena.dboe.base.recordbuffer.RecordBufferPage;

public final class RecordBufferPageMgr
extends PageBlockMgr<RecordBufferPage> {
    private final RecordFactory factory;

    public RecordBufferPageMgr(RecordFactory factory, BlockMgr blockMgr) {
        super(new Block2RecordBufferPage(factory), blockMgr);
        this.factory = factory;
    }

    public RecordFactory getRecordFactory() {
        return this.factory;
    }

    public RecordBufferPage create() {
        return (RecordBufferPage)super.create(BlockType.RECORD_BLOCK);
    }

    public static class Block2RecordBufferPage
    implements BlockConverter<RecordBufferPage> {
        private RecordFactory factory;

        public Block2RecordBufferPage(RecordFactory factory) {
            this.factory = factory;
        }

        @Override
        public RecordBufferPage createFromBlock(Block block, BlockType blkType) {
            if (blkType != BlockType.RECORD_BLOCK) {
                throw new RecordException("Not RECORD_BLOCK: " + String.valueOf(blkType));
            }
            RecordBufferPage rb = RecordBufferPage.createBlank(block, this.factory);
            return rb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RecordBufferPage fromBlock(Block block) {
            Block block2 = block;
            synchronized (block2) {
                RecordBufferPage rb = RecordBufferPage.format(block, this.factory);
                return rb;
            }
        }

        @Override
        public Block toBlock(RecordBufferPage rbp) {
            int count = rbp.getRecordBuffer().size();
            ByteBuffer bb = rbp.getBackingBlock().getByteBuffer();
            bb.putInt(0, rbp.getCount());
            bb.putInt(4, rbp.getLink());
            return rbp.getBackingBlock();
        }
    }
}

