/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.logging;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.logging.LogCtlJUL;
import org.apache.jena.atlas.logging.LogCtlLog4j2;
import org.slf4j.Logger;

public class LogCtl {
    private static final boolean hasLog4j2 = LogCtl.hasClass("org.apache.logging.slf4j.Log4jLoggerFactory");
    private static final boolean hasLog4j1 = LogCtl.hasClass("org.slf4j.impl.Log4jLoggerFactory");
    private static final boolean hasJUL = LogCtl.hasClass("org.slf4j.impl.JDK14LoggerFactory");
    private static final boolean hasLogback = LogCtl.hasClass("ch.qos.logback.core.LogbackException");
    public static final String log4j2ConfigFileProperty = "log4j2.configurationFile";
    public static final String log4j2ConfigFilePropertyLegacy = "log4j.configurationFile";
    private static final String[] log4j2files = new String[]{"log4j2.properties", "log4j2.xml"};
    public static final String envLogLoggingProperty = "JENA_LOGLOGGING";
    public static final String logLoggingProperty = "jena.logLogging";
    private static final boolean LogLogging = System.getenv("JENA_LOGLOGGING") != null || System.getProperty("jena.logLogging") != null;
    private static boolean loggingInitialized = false;
    private static String JUL_PROPERTY = "java.util.logging.configuration";

    private static boolean hasClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e2) {
            return false;
        }
    }

    public static void set(Logger logger, String level) {
        LogCtl.setLevel(logger.getName(), level);
    }

    public static void setLevel(Class<?> cls, String level) {
        LogCtl.setLevel(cls.getName(), level);
    }

    public static void setLevel(Logger logger, String level) {
        LogCtl.setLevel(logger.getName(), level);
    }

    public static void setLevel(String logger, String level) {
        LogCtl.setLevelLog4j2(logger, level);
        LogCtl.setLevelJUL(logger, level);
    }

    public static String getLevel(Logger logger) {
        return LogCtl.getLevel(logger.getName());
    }

    public static String getLevel(Class<?> logger) {
        return LogCtl.getLevel(logger.getName());
    }

    public static String getLevel(String logger) {
        String s2 = LogCtl.getLevelLog4j2(logger);
        if (s2 != null) {
            return s2;
        }
        String s3 = LogCtl.getLevelJUL(logger);
        if (s3 != null) {
            return s3;
        }
        return null;
    }

    private static String getLevelLog4j2(String logger) {
        if (!hasLog4j2) {
            return null;
        }
        return LogCtlLog4j2.getLoggerlevel(logger);
    }

    private static String getLevelJUL(String logger) {
        if (!hasJUL) {
            return null;
        }
        return LogCtlJUL.getLevelJUL(logger);
    }

    private static void setLevelJUL(String logger, String levelName) {
        if (!hasJUL) {
            return;
        }
        LogCtlJUL.setLevelJUL(logger, levelName);
    }

    private static void setLevelLog4j2(String logger, String levelName) {
        if (!hasLog4j2) {
            return;
        }
        LogCtlLog4j2.setLoggerlevel(logger, levelName);
    }

    public static void enable(Logger logger) {
        LogCtl.enable(logger.getName());
    }

    public static void enable(String logger) {
        LogCtl.setLevel(logger, "all");
    }

    public static void enable(Class<?> logger) {
        LogCtl.setLevel(logger.getName(), "ALL");
    }

    public static void disable(Logger logger) {
        LogCtl.setLevel(logger.getName(), "OFF");
    }

    public static void disable(String logger) {
        LogCtl.setLevel(logger, "OFF");
    }

    public static void disable(Class<?> logger) {
        LogCtl.setLevel(logger.getName(), "OFF");
    }

    public static void setInfo(String logger) {
        LogCtl.setLevel(logger, "info");
    }

    public static void setInfo(Class<?> logger) {
        LogCtl.setLevel(logger.getName(), "info");
    }

    public static void setWarn(String logger) {
        LogCtl.setLevel(logger, "warn");
    }

    public static void setWarn(Class<?> logger) {
        LogCtl.setLevel(logger.getName(), "warn");
    }

    public static void setError(String logger) {
        LogCtl.setLevel(logger, "error");
    }

    public static void setError(Class<?> logger) {
        LogCtl.setLevel(logger.getName(), "error");
    }

    public static void setLogging() {
        if (hasLog4j2) {
            LogCtl.setLog4j2();
            return;
        }
        if (hasJUL) {
            LogCtl.setJavaLogging();
            return;
        }
    }

    private static void logLogging(String fmt, Object ... args) {
        if (LogLogging) {
            System.err.print("Jena Logging: ");
            System.err.printf(fmt, args);
            System.err.println();
        }
    }

    public static void setLog4j2() {
        if (loggingInitialized) {
            return;
        }
        loggingInitialized = true;
        if (!LogCtl.isSetLog4j2property()) {
            LogCtl.logLogging("Set logging", new Object[0]);
            LogCtl.setLog4j2property();
            if (LogCtl.isSetLog4j2property()) {
                return;
            }
            LogCtl.logLogging("Log4j2: built-in default", new Object[0]);
            LogCtlLog4j2.reconfigureLog4j2fromString(LogCtlLog4j2.log4j2setup, LogCtlLog4j2.SyntaxHint.PROPERTIES);
        } else if (LogCtl.isSetLog4j2property(log4j2ConfigFilePropertyLegacy)) {
            LogCtl.logLogging("Already set: %s=%s", log4j2ConfigFilePropertyLegacy, System.getProperty(log4j2ConfigFilePropertyLegacy));
        } else {
            LogCtl.logLogging("Already set: %s=%s", log4j2ConfigFileProperty, System.getProperty(log4j2ConfigFileProperty));
        }
    }

    static boolean isSetLog4j2property() {
        return LogCtl.isSetLog4j2property(log4j2ConfigFileProperty) || LogCtl.isSetLog4j2property(log4j2ConfigFilePropertyLegacy);
    }

    private static boolean isSetLog4j2property(String systemProperty) {
        return System.getProperty(systemProperty) != null;
    }

    static void setLog4j2property() {
        if (LogCtl.isSetLog4j2property()) {
            return;
        }
        for (String fn : log4j2files) {
            File f = new File(fn);
            if (!f.exists()) continue;
            String fileURL = "file:" + fn;
            LogCtl.logLogging("Set %s=%s", log4j2ConfigFileProperty, fileURL);
            System.setProperty(log4j2ConfigFileProperty, fileURL);
            return;
        }
    }

    public static void setJavaLogging() {
        LogCtl.logLogging("Ensure java.util.logging setup", new Object[0]);
        if (System.getProperty(JUL_PROPERTY) != null) {
            LogCtl.logLogging(JUL_PROPERTY + "=" + System.getProperty(JUL_PROPERTY), new Object[0]);
            return;
        }
        LogCtl.logLogging("java.util.logging reset logging", new Object[0]);
        LogCtlJUL.resetJavaLogging();
    }

    public static void setJavaLogging(String filename) {
        try {
            InputStream details = new FileInputStream(filename);
            details = new BufferedInputStream(details);
            LogCtlJUL.readJavaLoggingConfiguration(details);
        }
        catch (Exception ex) {
            throw new AtlasException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withLevel(Logger logger, String execLevel, Runnable action) {
        String currentLevel = LogCtl.getLevel(logger);
        try {
            LogCtl.setLevel(logger, execLevel);
            action.run();
        }
        finally {
            LogCtl.setLevel(logger, currentLevel);
        }
    }
}

