/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfs.engine;

import java.util.Objects;
import java.util.stream.Stream;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdfs.engine.MapperX;
import org.apache.jena.rdfs.engine.Mappers;
import org.apache.jena.rdfs.engine.Match;

public final class MatchAdapter<X, T>
implements Match<Node, Triple> {
    private Match<X, T> below;
    private MapperX<X, T> mapper;

    public MatchAdapter(Match<X, T> below, MapperX<X, T> mapper) {
        this.mapper = Objects.requireNonNull(mapper);
        this.below = Objects.requireNonNull(below);
    }

    @Override
    public Stream<Triple> match(Node s, Node p, Node o) {
        X sd = this.down(s);
        X pd = this.down(p);
        X od = this.down(o);
        return this.below.match(sd, pd, od).map(this::up);
    }

    private X down(Node node) {
        return this.mapper.fromNode(node);
    }

    private Triple up(T tuple) {
        X sd = this.mapper.subject(tuple);
        X pd = this.mapper.predicate(tuple);
        X od = this.mapper.object(tuple);
        Node s = this.mapper.toNode(sd);
        Node p = this.mapper.toNode(pd);
        Node o = this.mapper.toNode(od);
        return this.dstCreate(s, p, o);
    }

    private Triple dstCreate(Node s, Node p, Node o) {
        return Triple.create((Node)s, (Node)p, (Node)o);
    }

    @Override
    public MapperX<Node, Triple> getMapper() {
        return Mappers.mapperTriple();
    }
}

