/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim;

import org.apache.james.jdkim.tagvalue.SignatureRecordImpl;
import org.junit.Assert;
import org.junit.Test;

public class SignatureRecordTest {
    @Test
    public void testBasic() {
        SignatureRecordImpl sign = new SignatureRecordImpl("v=1; a=rsa-sha256; c=relaxed/relaxed;\r\n        d=gmail.com; s=beta;\r\n        h=domainkey-signature:received:received:message-id:date:from:to:subject:mime-version:content-type;\r\n        bh=9sd6eO/xnGLInYGPFN86r9q27iClGpwfkl4PBc5XEuQ=;\r\n        b=tGQtBQg1sO+JKopOylApWLngylEqeMcXwCEUQN+S2PSpi9c1G9Nm5df9pMShus3iFaQb0PPvTfpw++cAC8/N0p3Gi/lVLc+Yh7xWEIPZ3Nxd3xqTQy7grIkBpV0q6559dEhhfFoEyLS0OK/IrqFIUVDRIMnsMjimXV7u+Sgoi7Q=");
        sign.validate();
    }

    @Test
    public void testWrongOrMissingVersion() {
        SignatureRecordImpl sign2;
        try {
            sign2 = new SignatureRecordImpl("a=rsa-sha1; c=relaxed/relaxed;\r\n        d=gmail.com; s=beta;\r\n        h=domainkey-signature:received:received:message-id:date:from:to:subject:mime-version:content-type;\r\n        b=Kw/TqnjB4L5ZC7DX1ibiNkuIw630uHZvzuozn/e6yTm3U8ObWEz/rJK5GO8RSrF56JrCA/xo8W2CGmyNmpQYbEpLl5P9/NcJSYUmln/O6GSa4Usyv4FdEU4FVjkyW0ToGFHNkw9Mm0urveA4Lcfk9gClJczXnvGBdiv/bkVBEJk=");
            sign2.validate();
            Assert.fail((String)"expected error on missing v=");
        }
        catch (IllegalStateException sign2) {
            // empty catch block
        }
        try {
            sign2 = new SignatureRecordImpl("v=2; a=rsa-sha256; c=relaxed/relaxed;\r\n        d=gmail.com; s=beta;\r\n        h=domainkey-signature:received:received:message-id:date:from:to:subject:mime-version:content-type;\r\n        bh=9sd6eO/xnGLInYGPFN86r9q27iClGpwfkl4PBc5XEuQ=;\r\n        b=tGQtBQg1sO+JKopOylApWLngylEqeMcXwCEUQN+S2PSpi9c1G9Nm5df9pMShus3iFaQb0PPvTfpw++cAC8/N0p3Gi/lVLc+Yh7xWEIPZ3Nxd3xqTQy7grIkBpV0q6559dEhhfFoEyLS0OK/IrqFIUVDRIMnsMjimXV7u+Sgoi7Q=");
            sign2.validate();
            Assert.fail((String)"expected error on wrong v=");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testMissingRequired() {
        try {
            SignatureRecordImpl sign = new SignatureRecordImpl("v=1; a=rsa-sha256; c=relaxed/relaxed;\r\n        d=gmail.com; s=beta;\r\n        h=domainkey-signature:received:received:message-id:date:from:to:subject:mime-version:content-type;\r\n        b=tGQtBQg1sO+JKopOylApWLngylEqeMcXwCEUQN+S2PSpi9c1G9Nm5df9pMShus3iFaQb0PPvTfpw++cAC8/N0p3Gi/lVLc+Yh7xWEIPZ3Nxd3xqTQy7grIkBpV0q6559dEhhfFoEyLS0OK/IrqFIUVDRIMnsMjimXV7u+Sgoi7Q=");
            sign.validate();
            Assert.fail((String)"expected error on missing bh=");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testDomainMismatch() {
        try {
            SignatureRecordImpl sign = new SignatureRecordImpl("v=1; a=rsa-sha256; c=relaxed/relaxed;\r\n        d=gmail.com; s=beta; i=@agmail.com;\r\n        h=domainkey-signature:received:received:message-id:date:from:to:subject:mime-version:content-type;\r\n        bh=9sd6eO/xnGLInYGPFN86r9q27iClGpwfkl4PBc5XEuQ=;\r\n        b=tGQtBQg1sO+JKopOylApWLngylEqeMcXwCEUQN+S2PSpi9c1G9Nm5df9pMShus3iFaQb0PPvTfpw++cAC8/N0p3Gi/lVLc+Yh7xWEIPZ3Nxd3xqTQy7grIkBpV0q6559dEhhfFoEyLS0OK/IrqFIUVDRIMnsMjimXV7u+Sgoi7Q=");
            sign.validate();
            Assert.fail((String)"expected error on domain mismatch");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testMissingFrom() {
        try {
            SignatureRecordImpl sign = new SignatureRecordImpl("v=1; a=rsa-sha256; c=relaxed/relaxed;\r\n        d=gmail.com; s=beta; i=@subdomain.gmail.com;\r\n        h=domainkey-signature:received:received:message-id:date:fram:to:subject:mime-version:content-type;\r\n        bh=9sd6eO/xnGLInYGPFN86r9q27iClGpwfkl4PBc5XEuQ=;\r\n        b=tGQtBQg1sO+JKopOylApWLngylEqeMcXwCEUQN+S2PSpi9c1G9Nm5df9pMShus3iFaQb0PPvTfpw++cAC8/N0p3Gi/lVLc+Yh7xWEIPZ3Nxd3xqTQy7grIkBpV0q6559dEhhfFoEyLS0OK/IrqFIUVDRIMnsMjimXV7u+Sgoi7Q=");
            sign.validate();
            Assert.fail((String)"expected error on missing 'from' header");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

