/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.executor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.service.metric.PerformanceOverviewMetrics;
import org.apache.iotdb.consensus.IConsensus;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.consensus.exception.ConsensusGroupNotExistException;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.consensus.DataRegionConsensusImpl;
import org.apache.iotdb.db.consensus.SchemaRegionConsensusImpl;
import org.apache.iotdb.db.exception.metadata.MeasurementAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.SchemaQuotaExceededException;
import org.apache.iotdb.db.protocol.thrift.impl.DataNodeRegionManager;
import org.apache.iotdb.db.queryengine.execution.executor.RegionExecutionResult;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.ActivateTemplateNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.AlterTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.BatchActivateTemplateNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.CreateAlignedTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.CreateMultiTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.CreateTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.InternalBatchActivateTemplateNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.InternalCreateMultiTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.InternalCreateTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.MeasurementGroup;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.view.CreateLogicalViewNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.pipe.PipeEnrichedDeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.pipe.PipeEnrichedInsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.pipe.PipeEnrichedWritePlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.DeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertMultiTabletsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsOfOneDeviceNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.schemaengine.SchemaEngine;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.schemaengine.template.ClusterTemplateManager;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.db.trigger.executor.TriggerFireResult;
import org.apache.iotdb.db.trigger.executor.TriggerFireVisitor;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.trigger.api.enums.TriggerEvent;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionWriteExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegionWriteExecutor.class);
    private static final PerformanceOverviewMetrics PERFORMANCE_OVERVIEW_METRICS = PerformanceOverviewMetrics.getInstance();
    private static final String METADATA_ERROR_MSG = "Metadata error: ";
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private final IConsensus dataRegionConsensus;
    private final IConsensus schemaRegionConsensus;
    private final DataNodeRegionManager regionManager;
    private final SchemaEngine schemaEngine;
    private final ClusterTemplateManager clusterTemplateManager;
    private final TriggerFireVisitor triggerFireVisitor;
    private final WritePlanNodeExecutionVisitor executionVisitor;
    private final PipeEnrichedWriteSchemaNodeExecutionVisitor pipeExecutionVisitor;

    public RegionWriteExecutor() {
        this.dataRegionConsensus = DataRegionConsensusImpl.getInstance();
        this.schemaRegionConsensus = SchemaRegionConsensusImpl.getInstance();
        this.regionManager = DataNodeRegionManager.getInstance();
        this.schemaEngine = SchemaEngine.getInstance();
        this.clusterTemplateManager = ClusterTemplateManager.getInstance();
        this.triggerFireVisitor = new TriggerFireVisitor();
        this.executionVisitor = new WritePlanNodeExecutionVisitor();
        this.pipeExecutionVisitor = new PipeEnrichedWriteSchemaNodeExecutionVisitor(this.executionVisitor);
    }

    public RegionWriteExecutor(IConsensus dataRegionConsensus, IConsensus schemaRegionConsensus, DataNodeRegionManager regionManager, SchemaEngine schemaEngine, ClusterTemplateManager clusterTemplateManager, TriggerFireVisitor triggerFireVisitor) {
        this.dataRegionConsensus = dataRegionConsensus;
        this.schemaRegionConsensus = schemaRegionConsensus;
        this.regionManager = regionManager;
        this.schemaEngine = schemaEngine;
        this.clusterTemplateManager = clusterTemplateManager;
        this.triggerFireVisitor = triggerFireVisitor;
        this.executionVisitor = new WritePlanNodeExecutionVisitor();
        this.pipeExecutionVisitor = new PipeEnrichedWriteSchemaNodeExecutionVisitor(this.executionVisitor);
    }

    public RegionExecutionResult execute(ConsensusGroupId groupId, PlanNode planNode) {
        try {
            ReentrantReadWriteLock lock = this.regionManager.getRegionLock(groupId);
            if (lock == null) {
                return RegionExecutionResult.create(false, "Failed to get the lock of the region because the region is not existed.", RpcUtils.getStatus((TSStatusCode)TSStatusCode.NO_AVAILABLE_REGION_GROUP));
            }
            return planNode.accept(this.executionVisitor, new WritePlanNodeExecutionContext(groupId, lock));
        }
        catch (Throwable e) {
            if (Objects.isNull(this.regionManager.getRegionLock(groupId))) {
                String errorMsg = "Exception " + e.getClass().getSimpleName() + " encountered during region removal, will retry. Message: " + e.getMessage();
                LOGGER.info(errorMsg);
                return RegionExecutionResult.create(false, errorMsg, RpcUtils.getStatus((TSStatusCode)TSStatusCode.NO_AVAILABLE_REGION_GROUP));
            }
            LOGGER.warn(e.getMessage(), e);
            return RegionExecutionResult.create(false, e.getMessage(), RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage()));
        }
    }

    private class PipeEnrichedWriteSchemaNodeExecutionVisitor
    extends PlanVisitor<RegionExecutionResult, WritePlanNodeExecutionContext> {
        WritePlanNodeExecutionVisitor visitor;

        private PipeEnrichedWriteSchemaNodeExecutionVisitor(WritePlanNodeExecutionVisitor visitor) {
            this.visitor = visitor;
        }

        @Override
        public RegionExecutionResult visitPlan(PlanNode node, WritePlanNodeExecutionContext context) {
            throw new UnsupportedOperationException("PipeEnrichedWriteSchemaNodeExecutionVisitor does not support visiting general plan.");
        }

        @Override
        public RegionExecutionResult visitCreateTimeSeries(CreateTimeSeriesNode node, WritePlanNodeExecutionContext context) {
            return this.visitor.executeCreateTimeSeries(node, context, true);
        }

        @Override
        public RegionExecutionResult visitCreateAlignedTimeSeries(CreateAlignedTimeSeriesNode node, WritePlanNodeExecutionContext context) {
            return this.visitor.executeCreateAlignedTimeSeries(node, context, true);
        }

        @Override
        public RegionExecutionResult visitCreateMultiTimeSeries(CreateMultiTimeSeriesNode node, WritePlanNodeExecutionContext context) {
            return this.visitor.executeCreateMultiTimeSeries(node, context, true);
        }

        @Override
        public RegionExecutionResult visitInternalCreateTimeSeries(InternalCreateTimeSeriesNode node, WritePlanNodeExecutionContext context) {
            return this.visitor.executeInternalCreateTimeSeries(node, context, true);
        }

        @Override
        public RegionExecutionResult visitInternalCreateMultiTimeSeries(InternalCreateMultiTimeSeriesNode node, WritePlanNodeExecutionContext context) {
            return this.visitor.executeInternalCreateMultiTimeSeries(node, context, true);
        }

        @Override
        public RegionExecutionResult visitAlterTimeSeries(AlterTimeSeriesNode node, WritePlanNodeExecutionContext context) {
            return this.visitor.executeAlterTimeSeries(node, context, true);
        }

        @Override
        public RegionExecutionResult visitActivateTemplate(ActivateTemplateNode node, WritePlanNodeExecutionContext context) {
            return this.visitor.executeActivateTemplate(node, context, true);
        }

        @Override
        public RegionExecutionResult visitBatchActivateTemplate(BatchActivateTemplateNode node, WritePlanNodeExecutionContext context) {
            return this.visitor.executeBatchActivateTemplate(node, context, true);
        }

        @Override
        public RegionExecutionResult visitInternalBatchActivateTemplate(InternalBatchActivateTemplateNode node, WritePlanNodeExecutionContext context) {
            return this.visitor.executeInternalBatchActivateTemplate(node, context, true);
        }

        @Override
        public RegionExecutionResult visitCreateLogicalView(CreateLogicalViewNode node, WritePlanNodeExecutionContext context) {
            return this.visitor.executeCreateLogicalView(node, context, true);
        }
    }

    private class WritePlanNodeExecutionVisitor
    extends PlanVisitor<RegionExecutionResult, WritePlanNodeExecutionContext> {
        private WritePlanNodeExecutionVisitor() {
        }

        @Override
        public RegionExecutionResult visitPlan(PlanNode node, WritePlanNodeExecutionContext context) {
            if (CommonDescriptor.getInstance().getConfig().isReadOnly()) {
                return RegionExecutionResult.create(false, "Fail to do non-query operations because system is read-only.", RpcUtils.getStatus((TSStatusCode)TSStatusCode.SYSTEM_READ_ONLY, (String)"Fail to do non-query operations because system is read-only."));
            }
            try {
                TSStatus status = this.executePlanNodeInConsensusLayer(context.getRegionId(), node);
                return RegionExecutionResult.create(TSStatusCode.SUCCESS_STATUS.getStatusCode() == status.getCode(), status.getMessage(), status);
            }
            catch (ConsensusException e) {
                LOGGER.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
                TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)e.getMessage());
                if (e instanceof ConsensusGroupNotExistException) {
                    status.setCode(TSStatusCode.NO_AVAILABLE_REGION_GROUP.getStatusCode());
                }
                return RegionExecutionResult.create(false, e.toString(), status);
            }
        }

        private TSStatus executePlanNodeInConsensusLayer(ConsensusGroupId groupId, PlanNode planNode) throws ConsensusException {
            if (groupId instanceof DataRegionId) {
                return RegionWriteExecutor.this.dataRegionConsensus.write(groupId, (IConsensusRequest)planNode);
            }
            return RegionWriteExecutor.this.schemaRegionConsensus.write(groupId, (IConsensusRequest)planNode);
        }

        @Override
        public RegionExecutionResult visitInsertRow(InsertRowNode node, WritePlanNodeExecutionContext context) {
            return this.executeDataInsert(node, context);
        }

        @Override
        public RegionExecutionResult visitInsertTablet(InsertTabletNode node, WritePlanNodeExecutionContext context) {
            return this.executeDataInsert(node, context);
        }

        @Override
        public RegionExecutionResult visitInsertRows(InsertRowsNode node, WritePlanNodeExecutionContext context) {
            return this.executeDataInsert(node, context);
        }

        @Override
        public RegionExecutionResult visitInsertMultiTablets(InsertMultiTabletsNode node, WritePlanNodeExecutionContext context) {
            return this.executeDataInsert(node, context);
        }

        @Override
        public RegionExecutionResult visitInsertRowsOfOneDevice(InsertRowsOfOneDeviceNode node, WritePlanNodeExecutionContext context) {
            return this.executeDataInsert(node, context);
        }

        @Override
        public RegionExecutionResult visitPipeEnrichedInsertNode(PipeEnrichedInsertNode node, WritePlanNodeExecutionContext context) {
            return this.executeDataInsert(node, context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RegionExecutionResult executeDataInsert(InsertNode insertNode, WritePlanNodeExecutionContext context) {
            if (context.getRegionWriteValidationRWLock() == null) {
                String message = "Failed to get the lock of the region because the region is not existed.";
                return RegionExecutionResult.create(false, "Failed to get the lock of the region because the region is not existed.", RpcUtils.getStatus((TSStatusCode)TSStatusCode.NO_AVAILABLE_REGION_GROUP, (String)"Failed to get the lock of the region because the region is not existed."));
            }
            context.getRegionWriteValidationRWLock().readLock().lock();
            try {
                TSStatus status = this.fireTriggerAndInsert(context.getRegionId(), insertNode);
                RegionExecutionResult regionExecutionResult = RegionExecutionResult.create(TSStatusCode.SUCCESS_STATUS.getStatusCode() == status.getCode(), status.message, status);
                return regionExecutionResult;
            }
            catch (ConsensusException e) {
                LOGGER.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
                TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.WRITE_PROCESS_ERROR, (String)e.toString());
                if (e instanceof ConsensusGroupNotExistException) {
                    status.setCode(TSStatusCode.NO_AVAILABLE_REGION_GROUP.getStatusCode());
                }
                RegionExecutionResult regionExecutionResult = RegionExecutionResult.create(false, e.toString(), status);
                return regionExecutionResult;
            }
            finally {
                context.getRegionWriteValidationRWLock().readLock().unlock();
            }
        }

        private TSStatus fireTriggerAndInsert(ConsensusGroupId groupId, InsertNode insertNode) throws ConsensusException {
            TSStatus status;
            long triggerCostTime = 0L;
            long startTime = System.nanoTime();
            TriggerFireResult result = RegionWriteExecutor.this.triggerFireVisitor.process((PlanNode)insertNode, TriggerEvent.BEFORE_INSERT);
            triggerCostTime += System.nanoTime() - startTime;
            if (result.equals((Object)TriggerFireResult.TERMINATION)) {
                status = RpcUtils.getStatus((int)TSStatusCode.TRIGGER_FIRE_ERROR.getStatusCode(), (String)"Failed to complete the insertion because trigger error before the insertion.");
            } else {
                long startWriteTime = System.nanoTime();
                status = RegionWriteExecutor.this.dataRegionConsensus.write(groupId, (IConsensusRequest)insertNode);
                PERFORMANCE_OVERVIEW_METRICS.recordScheduleStorageCost(System.nanoTime() - startWriteTime);
                startTime = System.nanoTime();
                boolean hasFailedTriggerBeforeInsertion = result.equals((Object)TriggerFireResult.FAILED_NO_TERMINATION);
                result = RegionWriteExecutor.this.triggerFireVisitor.process((PlanNode)insertNode, TriggerEvent.AFTER_INSERT);
                if (hasFailedTriggerBeforeInsertion || !result.equals((Object)TriggerFireResult.SUCCESS)) {
                    status = RpcUtils.getStatus((int)TSStatusCode.TRIGGER_FIRE_ERROR.getStatusCode(), (String)"Meet trigger error before/after the insertion, the insertion itself is completed.");
                }
                triggerCostTime += System.nanoTime() - startTime;
            }
            PERFORMANCE_OVERVIEW_METRICS.recordScheduleTriggerCost(triggerCostTime);
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RegionExecutionResult visitPipeEnrichedDeleteDataNode(PipeEnrichedDeleteDataNode node, WritePlanNodeExecutionContext context) {
            context.getRegionWriteValidationRWLock().writeLock().lock();
            try {
                RegionExecutionResult regionExecutionResult = (RegionExecutionResult)super.visitPipeEnrichedDeleteDataNode(node, context);
                return regionExecutionResult;
            }
            finally {
                context.getRegionWriteValidationRWLock().writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RegionExecutionResult visitDeleteData(DeleteDataNode node, WritePlanNodeExecutionContext context) {
            context.getRegionWriteValidationRWLock().writeLock().lock();
            try {
                RegionExecutionResult regionExecutionResult = (RegionExecutionResult)super.visitDeleteData(node, context);
                return regionExecutionResult;
            }
            finally {
                context.getRegionWriteValidationRWLock().writeLock().unlock();
            }
        }

        @Override
        public RegionExecutionResult visitCreateTimeSeries(CreateTimeSeriesNode node, WritePlanNodeExecutionContext context) {
            return this.executeCreateTimeSeries(node, context, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RegionExecutionResult executeCreateTimeSeries(CreateTimeSeriesNode node, WritePlanNodeExecutionContext context, boolean receivedFromPipe) {
            ISchemaRegion schemaRegion = RegionWriteExecutor.this.schemaEngine.getSchemaRegion((SchemaRegionId)context.getRegionId());
            RegionExecutionResult result = this.checkQuotaBeforeCreatingTimeSeries(schemaRegion, node.getPath().getDevicePath(), 1);
            if (result != null) {
                return result;
            }
            if (CONFIG.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus") && !receivedFromPipe) {
                context.getRegionWriteValidationRWLock().writeLock().lock();
                try {
                    Map<Integer, MetadataException> failingMeasurementMap = schemaRegion.checkMeasurementExistence(node.getPath().getDevicePath(), Collections.singletonList(node.getPath().getMeasurement()), Collections.singletonList(node.getAlias()));
                    if (failingMeasurementMap.isEmpty()) {
                        RegionExecutionResult regionExecutionResult = (RegionExecutionResult)super.visitCreateTimeSeries(node, context);
                        return regionExecutionResult;
                    }
                    MetadataException metadataException = failingMeasurementMap.get(0);
                    LOGGER.warn(RegionWriteExecutor.METADATA_ERROR_MSG, (Throwable)metadataException);
                    RegionExecutionResult regionExecutionResult = RegionExecutionResult.create(false, metadataException.getMessage(), RpcUtils.getStatus((int)metadataException.getErrorCode(), (String)metadataException.getMessage()));
                    return regionExecutionResult;
                }
                finally {
                    context.getRegionWriteValidationRWLock().writeLock().unlock();
                }
            }
            return receivedFromPipe ? (RegionExecutionResult)super.visitPipeEnrichedWritePlanNode(new PipeEnrichedWritePlanNode(node), context) : (RegionExecutionResult)super.visitCreateTimeSeries(node, context);
        }

        @Override
        public RegionExecutionResult visitCreateAlignedTimeSeries(CreateAlignedTimeSeriesNode node, WritePlanNodeExecutionContext context) {
            return this.executeCreateAlignedTimeSeries(node, context, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RegionExecutionResult executeCreateAlignedTimeSeries(CreateAlignedTimeSeriesNode node, WritePlanNodeExecutionContext context, boolean receivedFromPipe) {
            ISchemaRegion schemaRegion = RegionWriteExecutor.this.schemaEngine.getSchemaRegion((SchemaRegionId)context.getRegionId());
            RegionExecutionResult result = this.checkQuotaBeforeCreatingTimeSeries(schemaRegion, node.getDevicePath(), node.getMeasurements().size());
            if (result != null) {
                return result;
            }
            if (CONFIG.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus") && !receivedFromPipe) {
                context.getRegionWriteValidationRWLock().writeLock().lock();
                try {
                    Map<Integer, MetadataException> failingMeasurementMap = schemaRegion.checkMeasurementExistence(node.getDevicePath(), node.getMeasurements(), node.getAliasList());
                    if (failingMeasurementMap.isEmpty()) {
                        RegionExecutionResult regionExecutionResult = (RegionExecutionResult)super.visitCreateAlignedTimeSeries(node, context);
                        return regionExecutionResult;
                    }
                    MetadataException metadataException = failingMeasurementMap.values().iterator().next();
                    LOGGER.warn(RegionWriteExecutor.METADATA_ERROR_MSG, (Throwable)metadataException);
                    RegionExecutionResult regionExecutionResult = RegionExecutionResult.create(false, metadataException.getMessage(), RpcUtils.getStatus((int)metadataException.getErrorCode(), (String)metadataException.getMessage()));
                    return regionExecutionResult;
                }
                finally {
                    context.getRegionWriteValidationRWLock().writeLock().unlock();
                }
            }
            return receivedFromPipe ? (RegionExecutionResult)super.visitPipeEnrichedWritePlanNode(new PipeEnrichedWritePlanNode(node), context) : (RegionExecutionResult)super.visitCreateAlignedTimeSeries(node, context);
        }

        @Override
        public RegionExecutionResult visitCreateMultiTimeSeries(CreateMultiTimeSeriesNode node, WritePlanNodeExecutionContext context) {
            return this.executeCreateMultiTimeSeries(node, context, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RegionExecutionResult executeCreateMultiTimeSeries(CreateMultiTimeSeriesNode node, WritePlanNodeExecutionContext context, boolean receivedFromPipe) {
            ISchemaRegion schemaRegion = RegionWriteExecutor.this.schemaEngine.getSchemaRegion((SchemaRegionId)context.getRegionId());
            for (Map.Entry<PartialPath, MeasurementGroup> entry : node.getMeasurementGroupMap().entrySet()) {
                RegionExecutionResult result = this.checkQuotaBeforeCreatingTimeSeries(schemaRegion, entry.getKey(), entry.getValue().getMeasurements().size());
                if (result == null) continue;
                return result;
            }
            if (CONFIG.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus") && !receivedFromPipe) {
                context.getRegionWriteValidationRWLock().writeLock().lock();
                try {
                    ArrayList<TSStatus> failingStatus = new ArrayList<TSStatus>();
                    Map<PartialPath, MeasurementGroup> measurementGroupMap = node.getMeasurementGroupMap();
                    ArrayList<PartialPath> emptyDeviceList = new ArrayList<PartialPath>();
                    this.checkMeasurementExistence(measurementGroupMap, schemaRegion, failingStatus, emptyDeviceList);
                    for (Object emptyDevice : emptyDeviceList) {
                        measurementGroupMap.remove(emptyDevice);
                    }
                    RegionExecutionResult executionResult = this.registerTimeSeries(measurementGroupMap, node, context, failingStatus);
                    if (executionResult != null) {
                        Object emptyDevice;
                        emptyDevice = executionResult;
                        return emptyDevice;
                    }
                    TSStatus status = RpcUtils.getStatus(failingStatus);
                    RegionExecutionResult regionExecutionResult = RegionExecutionResult.create(false, status.getMessage(), status);
                    return regionExecutionResult;
                }
                finally {
                    context.getRegionWriteValidationRWLock().writeLock().unlock();
                }
            }
            return receivedFromPipe ? (RegionExecutionResult)super.visitPipeEnrichedWritePlanNode(new PipeEnrichedWritePlanNode(node), context) : (RegionExecutionResult)super.visitCreateMultiTimeSeries(node, context);
        }

        private void checkMeasurementExistence(Map<PartialPath, MeasurementGroup> measurementGroupMap, ISchemaRegion schemaRegion, List<TSStatus> failingStatus, List<PartialPath> emptyDeviceList) {
            for (Map.Entry<PartialPath, MeasurementGroup> entry : measurementGroupMap.entrySet()) {
                Map<Integer, MetadataException> failingMeasurementMap = schemaRegion.checkMeasurementExistence(entry.getKey(), entry.getValue().getMeasurements(), entry.getValue().getAliasList());
                if (failingMeasurementMap.isEmpty()) continue;
                for (Map.Entry<Integer, MetadataException> failingMeasurement : failingMeasurementMap.entrySet()) {
                    LOGGER.warn(RegionWriteExecutor.METADATA_ERROR_MSG, (Throwable)failingMeasurement.getValue());
                    failingStatus.add(RpcUtils.getStatus((int)failingMeasurement.getValue().getErrorCode(), (String)failingMeasurement.getValue().getMessage()));
                }
                entry.getValue().removeMeasurements(failingMeasurementMap.keySet());
                if (!entry.getValue().isEmpty()) continue;
                emptyDeviceList.add(entry.getKey());
            }
        }

        private RegionExecutionResult registerTimeSeries(Map<PartialPath, MeasurementGroup> measurementGroupMap, CreateMultiTimeSeriesNode node, WritePlanNodeExecutionContext context, List<TSStatus> failingStatus) {
            if (!measurementGroupMap.isEmpty()) {
                RegionExecutionResult executionResult = (RegionExecutionResult)super.visitCreateMultiTimeSeries(node, context);
                if (failingStatus.isEmpty()) {
                    return executionResult;
                }
                TSStatus executionStatus = executionResult.getStatus();
                if (executionStatus.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                    failingStatus.addAll(executionStatus.getSubStatus());
                } else if (executionStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    failingStatus.add(executionStatus);
                }
            }
            return null;
        }

        @Override
        public RegionExecutionResult visitInternalCreateTimeSeries(InternalCreateTimeSeriesNode node, WritePlanNodeExecutionContext context) {
            return this.executeInternalCreateTimeSeries(node, context, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RegionExecutionResult executeInternalCreateTimeSeries(InternalCreateTimeSeriesNode node, WritePlanNodeExecutionContext context, boolean receivedFromPipe) {
            ISchemaRegion schemaRegion = RegionWriteExecutor.this.schemaEngine.getSchemaRegion((SchemaRegionId)context.getRegionId());
            RegionExecutionResult result = this.checkQuotaBeforeCreatingTimeSeries(schemaRegion, node.getDevicePath(), node.getMeasurementGroup().size());
            if (result != null) {
                return result;
            }
            if (CONFIG.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus") && !receivedFromPipe) {
                context.getRegionWriteValidationRWLock().writeLock().lock();
                try {
                    ArrayList<TSStatus> failingStatus = new ArrayList<TSStatus>();
                    ArrayList<TSStatus> alreadyExistingStatus = new ArrayList<TSStatus>();
                    MeasurementGroup measurementGroup = node.getMeasurementGroup();
                    Map<Integer, MetadataException> failingMeasurementMap = schemaRegion.checkMeasurementExistence(node.getDevicePath(), measurementGroup.getMeasurements(), measurementGroup.getAliasList());
                    for (Map.Entry<Integer, MetadataException> failingMeasurement : failingMeasurementMap.entrySet()) {
                        MetadataException metadataException = failingMeasurement.getValue();
                        if (metadataException.getErrorCode() == TSStatusCode.TIMESERIES_ALREADY_EXIST.getStatusCode()) {
                            alreadyExistingStatus.add(RpcUtils.getStatus((int)metadataException.getErrorCode(), (String)PartialPath.transformDataToString((PartialPath)((MeasurementAlreadyExistException)metadataException).getMeasurementPath())));
                            continue;
                        }
                        int errorCode = metadataException.getErrorCode();
                        if (errorCode != TSStatusCode.PATH_ALREADY_EXIST.getStatusCode() || errorCode != TSStatusCode.ALIAS_ALREADY_EXIST.getStatusCode()) {
                            LOGGER.info(RegionWriteExecutor.METADATA_ERROR_MSG, (Throwable)metadataException);
                        }
                        failingStatus.add(RpcUtils.getStatus((int)metadataException.getErrorCode(), (String)metadataException.getMessage()));
                    }
                    measurementGroup.removeMeasurements(failingMeasurementMap.keySet());
                    RegionExecutionResult regionExecutionResult = this.processExecutionResultOfInternalCreateSchema(!measurementGroup.isEmpty() ? (RegionExecutionResult)super.visitInternalCreateTimeSeries(node, context) : RegionExecutionResult.create(true, "Execute successfully", RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully")), failingStatus, alreadyExistingStatus);
                    return regionExecutionResult;
                }
                finally {
                    context.getRegionWriteValidationRWLock().writeLock().unlock();
                }
            }
            return receivedFromPipe ? (RegionExecutionResult)super.visitPipeEnrichedWritePlanNode(new PipeEnrichedWritePlanNode(node), context) : (RegionExecutionResult)super.visitInternalCreateTimeSeries(node, context);
        }

        @Override
        public RegionExecutionResult visitInternalCreateMultiTimeSeries(InternalCreateMultiTimeSeriesNode node, WritePlanNodeExecutionContext context) {
            return this.executeInternalCreateMultiTimeSeries(node, context, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RegionExecutionResult executeInternalCreateMultiTimeSeries(InternalCreateMultiTimeSeriesNode node, WritePlanNodeExecutionContext context, boolean receivedFromPipe) {
            ISchemaRegion schemaRegion = RegionWriteExecutor.this.schemaEngine.getSchemaRegion((SchemaRegionId)context.getRegionId());
            for (Map.Entry<PartialPath, Pair<Boolean, MeasurementGroup>> deviceEntry : node.getDeviceMap().entrySet()) {
                RegionExecutionResult result = this.checkQuotaBeforeCreatingTimeSeries(schemaRegion, deviceEntry.getKey(), ((MeasurementGroup)deviceEntry.getValue().getRight()).size());
                if (result == null) continue;
                return result;
            }
            if (CONFIG.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus") && !receivedFromPipe) {
                context.getRegionWriteValidationRWLock().writeLock().lock();
                try {
                    ArrayList<TSStatus> failingStatus = new ArrayList<TSStatus>();
                    ArrayList<TSStatus> alreadyExistingStatus = new ArrayList<TSStatus>();
                    Iterator<Map.Entry<PartialPath, Pair<Boolean, MeasurementGroup>>> iterator = node.getDeviceMap().entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<PartialPath, Pair<Boolean, MeasurementGroup>> deviceEntry = iterator.next();
                        MeasurementGroup measurementGroup = (MeasurementGroup)deviceEntry.getValue().right;
                        Map<Integer, MetadataException> failingMeasurementMap = schemaRegion.checkMeasurementExistence(deviceEntry.getKey(), measurementGroup.getMeasurements(), measurementGroup.getAliasList());
                        for (Map.Entry<Integer, MetadataException> failingMeasurement : failingMeasurementMap.entrySet()) {
                            MetadataException metadataException = failingMeasurement.getValue();
                            if (metadataException.getErrorCode() == TSStatusCode.TIMESERIES_ALREADY_EXIST.getStatusCode()) {
                                alreadyExistingStatus.add(RpcUtils.getStatus((int)metadataException.getErrorCode(), (String)PartialPath.transformDataToString((PartialPath)((MeasurementAlreadyExistException)metadataException).getMeasurementPath())));
                                continue;
                            }
                            LOGGER.warn(RegionWriteExecutor.METADATA_ERROR_MSG, (Throwable)metadataException);
                            failingStatus.add(RpcUtils.getStatus((int)metadataException.getErrorCode(), (String)metadataException.getMessage()));
                        }
                        measurementGroup.removeMeasurements(failingMeasurementMap.keySet());
                        if (!measurementGroup.isEmpty()) continue;
                        iterator.remove();
                    }
                    RegionExecutionResult regionExecutionResult = this.processExecutionResultOfInternalCreateSchema(!node.getDeviceMap().isEmpty() ? (RegionExecutionResult)super.visitInternalCreateMultiTimeSeries(node, context) : RegionExecutionResult.create(true, "Execute successfully", RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully")), failingStatus, alreadyExistingStatus);
                    return regionExecutionResult;
                }
                finally {
                    context.getRegionWriteValidationRWLock().writeLock().unlock();
                }
            }
            return receivedFromPipe ? (RegionExecutionResult)super.visitPipeEnrichedWritePlanNode(new PipeEnrichedWritePlanNode(node), context) : (RegionExecutionResult)super.visitInternalCreateMultiTimeSeries(node, context);
        }

        private RegionExecutionResult checkQuotaBeforeCreatingTimeSeries(ISchemaRegion schemaRegion, PartialPath path, int size) {
            try {
                schemaRegion.checkSchemaQuota(path, size);
            }
            catch (SchemaQuotaExceededException e) {
                return RegionExecutionResult.create(false, e.getMessage(), RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
            }
            return null;
        }

        private RegionExecutionResult processExecutionResultOfInternalCreateSchema(RegionExecutionResult executionResult, List<TSStatus> failingStatus, List<TSStatus> alreadyExistingStatus) {
            TSStatus status;
            TSStatus executionStatus = executionResult.getStatus();
            this.separateMeasurementAlreadyExistException(failingStatus, executionStatus, alreadyExistingStatus);
            boolean isAccepted = true;
            if (failingStatus.isEmpty() && alreadyExistingStatus.isEmpty()) {
                status = RpcUtils.SUCCESS_STATUS;
            } else if (failingStatus.isEmpty()) {
                status = RpcUtils.getStatus(alreadyExistingStatus);
            } else {
                status = RpcUtils.getStatus(failingStatus);
                isAccepted = false;
            }
            return RegionExecutionResult.create(isAccepted, status.getMessage(), status);
        }

        private void separateMeasurementAlreadyExistException(List<TSStatus> failingStatus, TSStatus executionStatus, List<TSStatus> alreadyExistingStatus) {
            if (failingStatus.isEmpty()) {
                if (executionStatus.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                    if (((TSStatus)executionStatus.getSubStatus().get(0)).getCode() == TSStatusCode.TIMESERIES_ALREADY_EXIST.getStatusCode()) {
                        alreadyExistingStatus.addAll(executionStatus.getSubStatus());
                    } else {
                        failingStatus.addAll(executionStatus.getSubStatus());
                    }
                } else if (executionStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    failingStatus.add(executionStatus);
                }
            } else if (executionStatus.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                if (((TSStatus)executionStatus.getSubStatus().get(0)).getCode() != TSStatusCode.TIMESERIES_ALREADY_EXIST.getStatusCode()) {
                    failingStatus.addAll(executionStatus.getSubStatus());
                }
            } else if (executionStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                failingStatus.add(executionStatus);
            }
        }

        @Override
        public RegionExecutionResult visitAlterTimeSeries(AlterTimeSeriesNode node, WritePlanNodeExecutionContext context) {
            return this.executeAlterTimeSeries(node, context, false);
        }

        private RegionExecutionResult executeAlterTimeSeries(AlterTimeSeriesNode node, WritePlanNodeExecutionContext context, boolean receivedFromPipe) {
            ISchemaRegion schemaRegion = RegionWriteExecutor.this.schemaEngine.getSchemaRegion((SchemaRegionId)context.getRegionId());
            try {
                MeasurementPath measurementPath = schemaRegion.fetchMeasurementPath(node.getPath());
                if (node.isAlterView() && !measurementPath.getMeasurementSchema().isLogicalView()) {
                    throw new MetadataException(String.format("%s is not view.", measurementPath.getFullPath()));
                }
                return receivedFromPipe ? (RegionExecutionResult)super.visitPipeEnrichedWritePlanNode(new PipeEnrichedWritePlanNode(node), context) : (RegionExecutionResult)super.visitAlterTimeSeries(node, context);
            }
            catch (MetadataException e) {
                return RegionExecutionResult.create(true, e.getMessage(), RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
            }
        }

        @Override
        public RegionExecutionResult visitActivateTemplate(ActivateTemplateNode node, WritePlanNodeExecutionContext context) {
            return this.executeActivateTemplate(node, context, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RegionExecutionResult executeActivateTemplate(ActivateTemplateNode node, WritePlanNodeExecutionContext context, boolean receivedFromPipe) {
            context.getRegionWriteValidationRWLock().readLock().lock();
            try {
                Pair<Template, PartialPath> templateSetInfo = RegionWriteExecutor.this.clusterTemplateManager.checkTemplateSetInfo(node.getActivatePath());
                if (templateSetInfo == null) {
                    String message = String.format("Template is being unsetting from path %s. Please try activating later.", node.getPathSetTemplate());
                    RegionExecutionResult regionExecutionResult = RegionExecutionResult.create(false, message, RpcUtils.getStatus((TSStatusCode)TSStatusCode.METADATA_ERROR, (String)message));
                    return regionExecutionResult;
                }
                ISchemaRegion schemaRegion = RegionWriteExecutor.this.schemaEngine.getSchemaRegion((SchemaRegionId)context.getRegionId());
                RegionExecutionResult result = this.checkQuotaBeforeCreatingTimeSeries(schemaRegion, node.getActivatePath(), ((Template)templateSetInfo.left).getMeasurementNumber());
                if (result == null) {
                    RegionExecutionResult regionExecutionResult = receivedFromPipe ? (RegionExecutionResult)super.visitPipeEnrichedWritePlanNode(new PipeEnrichedWritePlanNode(node), context) : (RegionExecutionResult)super.visitActivateTemplate(node, context);
                    return regionExecutionResult;
                }
                RegionExecutionResult regionExecutionResult = result;
                return regionExecutionResult;
            }
            finally {
                context.getRegionWriteValidationRWLock().readLock().unlock();
            }
        }

        @Override
        public RegionExecutionResult visitBatchActivateTemplate(BatchActivateTemplateNode node, WritePlanNodeExecutionContext context) {
            return this.executeBatchActivateTemplate(node, context, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RegionExecutionResult executeBatchActivateTemplate(BatchActivateTemplateNode node, WritePlanNodeExecutionContext context, boolean receivedFromPipe) {
            context.getRegionWriteValidationRWLock().readLock().lock();
            try {
                ISchemaRegion schemaRegion = RegionWriteExecutor.this.schemaEngine.getSchemaRegion((SchemaRegionId)context.getRegionId());
                for (PartialPath devicePath : node.getTemplateActivationMap().keySet()) {
                    Pair<Template, PartialPath> templateSetInfo = RegionWriteExecutor.this.clusterTemplateManager.checkTemplateSetInfo(devicePath);
                    if (templateSetInfo == null) {
                        String message = String.format("Template is being unsetting from path %s. Please try activating later.", node.getPathSetTemplate(devicePath));
                        RegionExecutionResult regionExecutionResult = RegionExecutionResult.create(false, message, RpcUtils.getStatus((TSStatusCode)TSStatusCode.METADATA_ERROR, (String)message));
                        return regionExecutionResult;
                    }
                    RegionExecutionResult result = this.checkQuotaBeforeCreatingTimeSeries(schemaRegion, devicePath, ((Template)templateSetInfo.left).getMeasurementNumber());
                    if (result == null) continue;
                    RegionExecutionResult regionExecutionResult = result;
                    return regionExecutionResult;
                }
                RegionExecutionResult regionExecutionResult = receivedFromPipe ? (RegionExecutionResult)super.visitPipeEnrichedWritePlanNode(new PipeEnrichedWritePlanNode(node), context) : (RegionExecutionResult)super.visitBatchActivateTemplate(node, context);
                return regionExecutionResult;
            }
            finally {
                context.getRegionWriteValidationRWLock().readLock().unlock();
            }
        }

        @Override
        public RegionExecutionResult visitInternalBatchActivateTemplate(InternalBatchActivateTemplateNode node, WritePlanNodeExecutionContext context) {
            return this.executeInternalBatchActivateTemplate(node, context, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RegionExecutionResult executeInternalBatchActivateTemplate(InternalBatchActivateTemplateNode node, WritePlanNodeExecutionContext context, boolean receivedFromPipe) {
            context.getRegionWriteValidationRWLock().readLock().lock();
            try {
                ISchemaRegion schemaRegion = RegionWriteExecutor.this.schemaEngine.getSchemaRegion((SchemaRegionId)context.getRegionId());
                for (Map.Entry<PartialPath, Pair<Integer, Integer>> entry : node.getTemplateActivationMap().entrySet()) {
                    Pair<Template, PartialPath> templateSetInfo = RegionWriteExecutor.this.clusterTemplateManager.checkTemplateSetInfo(entry.getKey());
                    if (templateSetInfo == null) {
                        String message = String.format("Template is being unsetting from prefix path of %s. Please try activating later.", new PartialPath(Arrays.copyOf(entry.getKey().getNodes(), (Integer)entry.getValue().right + 1)).getFullPath());
                        RegionExecutionResult regionExecutionResult = RegionExecutionResult.create(false, message, RpcUtils.getStatus((TSStatusCode)TSStatusCode.METADATA_ERROR, (String)message));
                        return regionExecutionResult;
                    }
                    RegionExecutionResult result = this.checkQuotaBeforeCreatingTimeSeries(schemaRegion, entry.getKey(), ((Template)templateSetInfo.left).getMeasurementNumber());
                    if (result == null) continue;
                    RegionExecutionResult regionExecutionResult = result;
                    return regionExecutionResult;
                }
                RegionExecutionResult regionExecutionResult = receivedFromPipe ? (RegionExecutionResult)super.visitPipeEnrichedWritePlanNode(new PipeEnrichedWritePlanNode(node), context) : (RegionExecutionResult)super.visitInternalBatchActivateTemplate(node, context);
                return regionExecutionResult;
            }
            finally {
                context.getRegionWriteValidationRWLock().readLock().unlock();
            }
        }

        @Override
        public RegionExecutionResult visitCreateLogicalView(CreateLogicalViewNode node, WritePlanNodeExecutionContext context) {
            return this.executeCreateLogicalView(node, context, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RegionExecutionResult executeCreateLogicalView(CreateLogicalViewNode node, WritePlanNodeExecutionContext context, boolean receivedFromPipe) {
            ISchemaRegion schemaRegion = RegionWriteExecutor.this.schemaEngine.getSchemaRegion((SchemaRegionId)context.getRegionId());
            if (CONFIG.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus")) {
                context.getRegionWriteValidationRWLock().writeLock().lock();
                try {
                    List<PartialPath> targetPaths = node.getViewPathList();
                    ArrayList<MetadataException> failingMetadataException = new ArrayList<MetadataException>();
                    for (PartialPath thisPath : targetPaths) {
                        Map<Integer, MetadataException> failingMeasurementMap = schemaRegion.checkMeasurementExistence(thisPath.getDevicePath(), Collections.singletonList(thisPath.getMeasurement()), null);
                        for (Map.Entry<Integer, MetadataException> entry : failingMeasurementMap.entrySet()) {
                            failingMetadataException.add(entry.getValue());
                        }
                    }
                    if (!failingMetadataException.isEmpty()) {
                        MetadataException metadataException = (MetadataException)((Object)failingMetadataException.get(0));
                        LOGGER.warn(RegionWriteExecutor.METADATA_ERROR_MSG, (Throwable)metadataException);
                        RegionExecutionResult regionExecutionResult = RegionExecutionResult.create(false, metadataException.getMessage(), RpcUtils.getStatus((int)metadataException.getErrorCode(), (String)metadataException.getMessage()));
                        return regionExecutionResult;
                    }
                    RegionExecutionResult regionExecutionResult = receivedFromPipe ? (RegionExecutionResult)super.visitPipeEnrichedWritePlanNode(new PipeEnrichedWritePlanNode(node), context) : (RegionExecutionResult)super.visitCreateLogicalView(node, context);
                    return regionExecutionResult;
                }
                finally {
                    context.getRegionWriteValidationRWLock().writeLock().unlock();
                }
            }
            return receivedFromPipe ? (RegionExecutionResult)super.visitPipeEnrichedWritePlanNode(new PipeEnrichedWritePlanNode(node), context) : (RegionExecutionResult)super.visitCreateLogicalView(node, context);
        }

        @Override
        public RegionExecutionResult visitPipeEnrichedWritePlanNode(PipeEnrichedWritePlanNode node, WritePlanNodeExecutionContext context) {
            return node.getWritePlanNode().accept(RegionWriteExecutor.this.pipeExecutionVisitor, context);
        }
    }

    private static class WritePlanNodeExecutionContext {
        private final ConsensusGroupId regionId;
        private final ReentrantReadWriteLock regionRWLock;

        WritePlanNodeExecutionContext(ConsensusGroupId regionId, ReentrantReadWriteLock regionRWLock) {
            this.regionId = regionId;
            this.regionRWLock = regionRWLock;
        }

        public ConsensusGroupId getRegionId() {
            return this.regionId;
        }

        public ReentrantReadWriteLock getRegionWriteValidationRWLock() {
            return this.regionRWLock;
        }
    }
}

