/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility.primitive;

import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.impl.factory.primitive.ShortLists;
import org.eclipse.collections.impl.lazy.primitive.CollectShortToObjectIterable;
import org.eclipse.collections.impl.lazy.primitive.FlatCollectShortToObjectIterable;
import org.eclipse.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.SelectShortIterable;
import org.eclipse.collections.impl.lazy.primitive.TapShortIterable;

public final class LazyShortIterate {
    private static final LazyShortIterable EMPTY_ITERABLE = ShortLists.immutable.empty().asLazy();

    private LazyShortIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static LazyShortIterable adapt(ShortIterable iterable) {
        return new LazyShortIterableAdapter(iterable);
    }

    public static LazyShortIterable select(ShortIterable iterable, ShortPredicate predicate) {
        return new SelectShortIterable(iterable, predicate);
    }

    public static <V> LazyIterable<V> collect(ShortIterable iterable, ShortToObjectFunction<? extends V> function) {
        return new CollectShortToObjectIterable<V>(iterable, function);
    }

    public static <V> LazyIterable<V> flatCollect(ShortIterable iterable, ShortToObjectFunction<? extends Iterable<V>> function) {
        return new FlatCollectShortToObjectIterable(iterable, function);
    }

    public static <V> LazyIterable<V> collectIf(ShortIterable iterable, ShortPredicate predicate, ShortToObjectFunction<? extends V> function) {
        return LazyShortIterate.select(iterable, predicate).collect((ShortToObjectFunction)function);
    }

    public static LazyShortIterable empty() {
        return EMPTY_ITERABLE;
    }

    public static LazyShortIterable tap(ShortIterable iterable, ShortProcedure procedure) {
        return new TapShortIterable(iterable, procedure);
    }
}

