/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.parallel;

import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.impl.parallel.Combiner;
import org.eclipse.collections.impl.parallel.ObjectIntProcedureFJTask;
import org.eclipse.collections.impl.parallel.ObjectIntProcedureFactory;
import org.eclipse.collections.impl.utility.ArrayIterate;

public final class ObjectIntProcedureFJTaskRunner<T, BT extends ObjectIntProcedure<? super T>> {
    private final Function<ObjectIntProcedureFJTask<T, BT>, BT> procedureFunction = new ObjectIntProcedureExtractor();
    private ObjectIntProcedureFJTask<T, BT>[] procedures;
    private Throwable error;
    private final Combiner<BT> combiner;
    private final int taskCount;
    private final BlockingQueue<BT> outputQueue;
    private final CountDownLatch latch;

    public ObjectIntProcedureFJTaskRunner(Combiner<BT> newCombiner, int taskCount) {
        this(newCombiner, taskCount, ObjectIntProcedureFJTaskRunner.buildQueue(newCombiner, taskCount), ObjectIntProcedureFJTaskRunner.buildCountDownLatch(newCombiner, taskCount));
    }

    ObjectIntProcedureFJTaskRunner(Combiner<BT> newCombiner, int taskCount, BlockingQueue<BT> queue, CountDownLatch latch) {
        this.combiner = newCombiner;
        this.taskCount = taskCount;
        this.outputQueue = queue;
        this.latch = latch;
    }

    private static <BT> CountDownLatch buildCountDownLatch(Combiner<BT> newCombiner, int taskCount) {
        return newCombiner.useCombineOne() ? null : new CountDownLatch(taskCount);
    }

    private static <BT> ArrayBlockingQueue<BT> buildQueue(Combiner<BT> newCombiner, int taskCount) {
        return newCombiner.useCombineOne() ? new ArrayBlockingQueue(taskCount) : null;
    }

    private void createAndExecuteTasks(Executor executor, ObjectIntProcedureFactory<BT> procedureFactory, List<T> list) {
        this.procedures = new ObjectIntProcedureFJTask[this.taskCount];
        int sectionSize = list.size() / this.taskCount;
        for (int index = 0; index < this.taskCount; ++index) {
            ObjectIntProcedureFJTask<T, BT> procedureFJTask = new ObjectIntProcedureFJTask<T, BT>(this, procedureFactory, list, index, sectionSize, index == this.taskCount - 1);
            this.procedures[index] = procedureFJTask;
            executor.execute(procedureFJTask);
        }
    }

    public void setFailed(Throwable newError) {
        this.error = newError;
    }

    public void taskCompleted(ObjectIntProcedureFJTask<T, BT> task) {
        if (this.combiner.useCombineOne()) {
            this.outputQueue.add(task.getProcedure());
        } else {
            this.latch.countDown();
        }
    }

    public void executeAndCombine(Executor executor, ObjectIntProcedureFactory<BT> procedureFactory, List<T> list) {
        this.createAndExecuteTasks(executor, procedureFactory, list);
        this.join();
        if (this.error != null) {
            throw new RuntimeException("One or more parallel tasks failed", this.error);
        }
        this.combineTasks();
    }

    private void join() {
        try {
            if (this.combiner.useCombineOne()) {
                for (int remaingTaskCount = this.taskCount; remaingTaskCount > 0; --remaingTaskCount) {
                    this.combiner.combineOne(this.outputQueue.take());
                }
            } else {
                this.latch.await();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Combine failed", e);
        }
    }

    private void combineTasks() {
        if (!this.combiner.useCombineOne()) {
            this.combiner.combineAll(ArrayIterate.collect(this.procedures, this.procedureFunction));
        }
    }

    private final class ObjectIntProcedureExtractor
    implements Function<ObjectIntProcedureFJTask<T, BT>, BT> {
        private static final long serialVersionUID = 1L;

        private ObjectIntProcedureExtractor() {
        }

        @Override
        public BT valueOf(ObjectIntProcedureFJTask<T, BT> object) {
            return object.getProcedure();
        }
    }
}

