/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class RepublishRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=830");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=832");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=831");
    private final RequestHeader requestHeader;
    private final UInteger subscriptionId;
    private final UInteger retransmitSequenceNumber;

    public RepublishRequest(RequestHeader requestHeader, UInteger subscriptionId, UInteger retransmitSequenceNumber) {
        this.requestHeader = requestHeader;
        this.subscriptionId = subscriptionId;
        this.retransmitSequenceNumber = retransmitSequenceNumber;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public UInteger getSubscriptionId() {
        return this.subscriptionId;
    }

    public UInteger getRetransmitSequenceNumber() {
        return this.retransmitSequenceNumber;
    }

    protected RepublishRequest(RepublishRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((RepublishRequestBuilder)b).requestHeader;
        this.subscriptionId = ((RepublishRequestBuilder)b).subscriptionId;
        this.retransmitSequenceNumber = ((RepublishRequestBuilder)b).retransmitSequenceNumber;
    }

    public static RepublishRequestBuilder<?, ?> builder() {
        return new RepublishRequestBuilderImpl();
    }

    public RepublishRequestBuilder<?, ?> toBuilder() {
        return new RepublishRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RepublishRequest)) {
            return false;
        }
        RepublishRequest other = (RepublishRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        UInteger this$subscriptionId = this.getSubscriptionId();
        UInteger other$subscriptionId = other.getSubscriptionId();
        if (this$subscriptionId == null ? other$subscriptionId != null : !((Object)this$subscriptionId).equals(other$subscriptionId)) {
            return false;
        }
        UInteger this$retransmitSequenceNumber = this.getRetransmitSequenceNumber();
        UInteger other$retransmitSequenceNumber = other.getRetransmitSequenceNumber();
        return !(this$retransmitSequenceNumber == null ? other$retransmitSequenceNumber != null : !((Object)this$retransmitSequenceNumber).equals(other$retransmitSequenceNumber));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RepublishRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        UInteger $subscriptionId = this.getSubscriptionId();
        result = result * 59 + ($subscriptionId == null ? 43 : ((Object)$subscriptionId).hashCode());
        UInteger $retransmitSequenceNumber = this.getRetransmitSequenceNumber();
        result = result * 59 + ($retransmitSequenceNumber == null ? 43 : ((Object)$retransmitSequenceNumber).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "RepublishRequest(requestHeader=" + this.getRequestHeader() + ", subscriptionId=" + this.getSubscriptionId() + ", retransmitSequenceNumber=" + this.getRetransmitSequenceNumber() + ")";
    }

    private static final class RepublishRequestBuilderImpl
    extends RepublishRequestBuilder<RepublishRequest, RepublishRequestBuilderImpl> {
        private RepublishRequestBuilderImpl() {
        }

        @Override
        protected RepublishRequestBuilderImpl self() {
            return this;
        }

        @Override
        public RepublishRequest build() {
            return new RepublishRequest(this);
        }
    }

    public static abstract class RepublishRequestBuilder<C extends RepublishRequest, B extends RepublishRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private UInteger subscriptionId;
        private UInteger retransmitSequenceNumber;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            RepublishRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(RepublishRequest instance, RepublishRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.subscriptionId(instance.subscriptionId);
            b.retransmitSequenceNumber(instance.retransmitSequenceNumber);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B subscriptionId(UInteger subscriptionId) {
            this.subscriptionId = subscriptionId;
            return (B)this.self();
        }

        public B retransmitSequenceNumber(UInteger retransmitSequenceNumber) {
            this.retransmitSequenceNumber = retransmitSequenceNumber;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "RepublishRequest.RepublishRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", subscriptionId=" + this.subscriptionId + ", retransmitSequenceNumber=" + this.retransmitSequenceNumber + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<RepublishRequest> {
        @Override
        public Class<RepublishRequest> getType() {
            return RepublishRequest.class;
        }

        @Override
        public RepublishRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            UInteger subscriptionId = decoder.readUInt32("SubscriptionId");
            UInteger retransmitSequenceNumber = decoder.readUInt32("RetransmitSequenceNumber");
            return new RepublishRequest(requestHeader, subscriptionId, retransmitSequenceNumber);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, RepublishRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeUInt32("SubscriptionId", value.getSubscriptionId());
            encoder.writeUInt32("RetransmitSequenceNumber", value.getRetransmitSequenceNumber());
        }
    }
}

