/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryEventFieldList;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class HistoryEvent
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=659");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=660");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=661");
    private final HistoryEventFieldList[] events;

    public HistoryEvent(HistoryEventFieldList[] events) {
        this.events = events;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public HistoryEventFieldList[] getEvents() {
        return this.events;
    }

    protected HistoryEvent(HistoryEventBuilder<?, ?> b) {
        super(b);
        this.events = ((HistoryEventBuilder)b).events;
    }

    public static HistoryEventBuilder<?, ?> builder() {
        return new HistoryEventBuilderImpl();
    }

    public HistoryEventBuilder<?, ?> toBuilder() {
        return new HistoryEventBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HistoryEvent)) {
            return false;
        }
        HistoryEvent other = (HistoryEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.deepEquals(this.getEvents(), other.getEvents());
    }

    protected boolean canEqual(Object other) {
        return other instanceof HistoryEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getEvents());
        return result;
    }

    @Override
    public String toString() {
        return "HistoryEvent(events=" + Arrays.deepToString(this.getEvents()) + ")";
    }

    private static final class HistoryEventBuilderImpl
    extends HistoryEventBuilder<HistoryEvent, HistoryEventBuilderImpl> {
        private HistoryEventBuilderImpl() {
        }

        @Override
        protected HistoryEventBuilderImpl self() {
            return this;
        }

        @Override
        public HistoryEvent build() {
            return new HistoryEvent(this);
        }
    }

    public static abstract class HistoryEventBuilder<C extends HistoryEvent, B extends HistoryEventBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private HistoryEventFieldList[] events;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            HistoryEventBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(HistoryEvent instance, HistoryEventBuilder<?, ?> b) {
            b.events(instance.events);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B events(HistoryEventFieldList[] events) {
            this.events = events;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "HistoryEvent.HistoryEventBuilder(super=" + super.toString() + ", events=" + Arrays.deepToString(this.events) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<HistoryEvent> {
        @Override
        public Class<HistoryEvent> getType() {
            return HistoryEvent.class;
        }

        @Override
        public HistoryEvent decode(SerializationContext context, UaDecoder decoder) {
            HistoryEventFieldList[] events = (HistoryEventFieldList[])decoder.readStructArray("Events", HistoryEventFieldList.TYPE_ID);
            return new HistoryEvent(events);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, HistoryEvent value) {
            encoder.writeStructArray("Events", (Object[])value.getEvents(), HistoryEventFieldList.TYPE_ID);
        }
    }
}

