/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception;

import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.tsfile.read.common.TimeRange;

public class CompactionStatisticsCheckFailedException
extends RuntimeException {
    public CompactionStatisticsCheckFailedException(String msg) {
        super(msg);
    }

    public CompactionStatisticsCheckFailedException(IDeviceID deviceID, TimeRange deviceTimeRange, TimeRange actualDeviceTimeRange) {
        super(CompactionStatisticsCheckFailedException.getExceptionMsg(deviceID, "The time range of current device is " + deviceTimeRange + ", which should equals actual device time range " + actualDeviceTimeRange));
    }

    public CompactionStatisticsCheckFailedException(IDeviceID deviceID, TimeseriesMetadata timeseriesMetadata, TimeRange actualTimeRange) {
        super(CompactionStatisticsCheckFailedException.getExceptionMsg(deviceID, "Current timeseriesMetadata is " + timeseriesMetadata + ", which should equals actual time range " + actualTimeRange));
    }

    public CompactionStatisticsCheckFailedException(IDeviceID deviceID, ChunkMetadata chunkMetadata, TimeRange actualChunkTimeRange) {
        super(CompactionStatisticsCheckFailedException.getExceptionMsg(deviceID, "Current chunkMetadata is " + chunkMetadata + ", which should equals actual chunk time range " + actualChunkTimeRange));
    }

    public CompactionStatisticsCheckFailedException(IDeviceID deviceID, PageHeader pageHeader, TimeRange pageDataTimeRange) {
        super(CompactionStatisticsCheckFailedException.getExceptionMsg(deviceID, "Current page is " + pageHeader + ", which should contains actual page data time range " + pageDataTimeRange));
    }

    private static String getExceptionMsg(IDeviceID deviceID, String detail) {
        return "The device(" + deviceID + ")'s time range verification failed. " + detail;
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }
}

