/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.exchange;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.sync.SyncDataNodeMPPDataExchangeServiceClient;
import org.apache.iotdb.db.queryengine.common.DataNodeEndPoints;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.execution.driver.DriverContext;
import org.apache.iotdb.db.queryengine.execution.exchange.IMPPDataExchangeManager;
import org.apache.iotdb.db.queryengine.execution.exchange.IMPPDataExchangeManagerCallback;
import org.apache.iotdb.db.queryengine.execution.exchange.SharedTsBlockQueue;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.DownStreamChannelIndex;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.DownStreamChannelLocation;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.ISink;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.ISinkChannel;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.ISinkHandle;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.LocalSinkChannel;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.ShuffleSinkHandle;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.SinkChannel;
import org.apache.iotdb.db.queryengine.execution.exchange.source.ISourceHandle;
import org.apache.iotdb.db.queryengine.execution.exchange.source.LocalSourceHandle;
import org.apache.iotdb.db.queryengine.execution.exchange.source.PipelineSourceHandle;
import org.apache.iotdb.db.queryengine.execution.exchange.source.SourceHandle;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.memory.LocalMemoryManager;
import org.apache.iotdb.db.queryengine.metric.DataExchangeCostMetricSet;
import org.apache.iotdb.db.queryengine.metric.DataExchangeCountMetricSet;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.iotdb.mpp.rpc.thrift.MPPDataExchangeService;
import org.apache.iotdb.mpp.rpc.thrift.TAcknowledgeDataBlockEvent;
import org.apache.iotdb.mpp.rpc.thrift.TCloseSinkChannelEvent;
import org.apache.iotdb.mpp.rpc.thrift.TEndOfDataBlockEvent;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceId;
import org.apache.iotdb.mpp.rpc.thrift.TGetDataBlockRequest;
import org.apache.iotdb.mpp.rpc.thrift.TGetDataBlockResponse;
import org.apache.iotdb.mpp.rpc.thrift.TNewDataBlockEvent;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.apache.tsfile.read.common.block.column.TsBlockSerde;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MPPDataExchangeManager
implements IMPPDataExchangeManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MPPDataExchangeManager.class);
    private final LocalMemoryManager localMemoryManager;
    private final Supplier<TsBlockSerde> tsBlockSerdeFactory;
    private final ExecutorService executorService;
    private final IClientManager<TEndPoint, SyncDataNodeMPPDataExchangeServiceClient> mppDataExchangeServiceClientManager;
    private final Map<TFragmentInstanceId, Map<String, ISourceHandle>> sourceHandles;
    private final Map<TFragmentInstanceId, ISinkHandle> shuffleSinkHandles;
    private MPPDataExchangeServiceImpl mppDataExchangeService;

    public MPPDataExchangeManager(LocalMemoryManager localMemoryManager, Supplier<TsBlockSerde> tsBlockSerdeFactory, ExecutorService executorService, IClientManager<TEndPoint, SyncDataNodeMPPDataExchangeServiceClient> mppDataExchangeServiceClientManager) {
        this.localMemoryManager = (LocalMemoryManager)Validate.notNull((Object)localMemoryManager, (String)"localMemoryManager is null.", (Object[])new Object[0]);
        this.tsBlockSerdeFactory = (Supplier)Validate.notNull(tsBlockSerdeFactory, (String)"tsBlockSerdeFactory is null.", (Object[])new Object[0]);
        this.executorService = (ExecutorService)Validate.notNull((Object)executorService, (String)"executorService is null.", (Object[])new Object[0]);
        this.mppDataExchangeServiceClientManager = (IClientManager)Validate.notNull(mppDataExchangeServiceClientManager, (String)"mppDataExchangeServiceClientManager is null.", (Object[])new Object[0]);
        this.sourceHandles = new ConcurrentHashMap<TFragmentInstanceId, Map<String, ISourceHandle>>();
        this.shuffleSinkHandles = new ConcurrentHashMap<TFragmentInstanceId, ISinkHandle>();
    }

    public MPPDataExchangeServiceImpl getOrCreateMPPDataExchangeServiceImpl() {
        if (this.mppDataExchangeService == null) {
            this.mppDataExchangeService = new MPPDataExchangeServiceImpl();
        }
        return this.mppDataExchangeService;
    }

    public void deRegisterFragmentInstanceFromMemoryPool(String queryId, String fragmentInstanceId, boolean forceDeregister) {
        this.localMemoryManager.getQueryPool().deRegisterFragmentInstanceFromQueryMemoryMap(queryId, fragmentInstanceId, forceDeregister);
    }

    public LocalMemoryManager getLocalMemoryManager() {
        return this.localMemoryManager;
    }

    public int getShuffleSinkHandleSize() {
        return this.shuffleSinkHandles.size();
    }

    public int getSourceHandleSize() {
        return this.sourceHandles.values().stream().mapToInt(Map::size).sum();
    }

    private synchronized ISinkChannel createLocalSinkChannel(TFragmentInstanceId localFragmentInstanceId, TFragmentInstanceId remoteFragmentInstanceId, String remotePlanNodeId, String localPlanNodeId, FragmentInstanceContext instanceContext, AtomicInteger cnt) {
        SharedTsBlockQueue queue;
        Map<String, ISourceHandle> sourceHandleMap;
        LocalSourceHandle localSourceHandle;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Create local sink handle to plan node {} of {} for {}", new Object[]{remotePlanNodeId, remoteFragmentInstanceId, localFragmentInstanceId});
        }
        LocalSourceHandle localSourceHandle2 = localSourceHandle = (sourceHandleMap = this.sourceHandles.get(remoteFragmentInstanceId)) == null ? null : (LocalSourceHandle)sourceHandleMap.get(remotePlanNodeId);
        if (localSourceHandle != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Get SharedTsBlockQueue from local source handle");
            }
            queue = localSourceHandle.getSharedTsBlockQueue();
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Create SharedTsBlockQueue");
            }
            queue = new SharedTsBlockQueue(localFragmentInstanceId, localPlanNodeId, this.localMemoryManager, this.executorService);
        }
        return new LocalSinkChannel(localFragmentInstanceId, queue, new ISinkChannelListenerImpl(localFragmentInstanceId, instanceContext, instanceContext::failed, cnt));
    }

    @Override
    public ISinkChannel createLocalSinkChannelForPipeline(DriverContext driverContext, String planNodeId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Create local sink handle for {}", (Object)driverContext.getDriverTaskID());
        }
        SharedTsBlockQueue queue = new SharedTsBlockQueue(driverContext.getDriverTaskID().getFragmentInstanceId().toThrift(), planNodeId, this.localMemoryManager, this.executorService);
        queue.allowAddingTsBlock();
        return new LocalSinkChannel(queue, new PipelineSinkListenerImpl(driverContext.getFragmentInstanceContext(), driverContext::failed));
    }

    private ISinkChannel createSinkChannel(TFragmentInstanceId localFragmentInstanceId, TEndPoint remoteEndpoint, TFragmentInstanceId remoteFragmentInstanceId, String remotePlanNodeId, String localPlanNodeId, FragmentInstanceContext instanceContext, AtomicInteger cnt) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Create sink handle to plan node {} of {} for {}", new Object[]{remotePlanNodeId, remoteFragmentInstanceId, localFragmentInstanceId});
        }
        return new SinkChannel(remoteEndpoint, remoteFragmentInstanceId, remotePlanNodeId, localPlanNodeId, localFragmentInstanceId, this.localMemoryManager, this.executorService, this.tsBlockSerdeFactory.get(), new ISinkChannelListenerImpl(localFragmentInstanceId, instanceContext, instanceContext::failed, cnt), this.mppDataExchangeServiceClientManager);
    }

    @Override
    public ISinkHandle createShuffleSinkHandle(List<DownStreamChannelLocation> downStreamChannelLocationList, DownStreamChannelIndex downStreamChannelIndex, ShuffleSinkHandle.ShuffleStrategyEnum shuffleStrategyEnum, TFragmentInstanceId localFragmentInstanceId, String localPlanNodeId, FragmentInstanceContext instanceContext) {
        if (this.shuffleSinkHandles.containsKey(localFragmentInstanceId)) {
            throw new IllegalStateException("ShuffleSinkHandle for " + localFragmentInstanceId + " is in the map.");
        }
        int channelNum = downStreamChannelLocationList.size();
        AtomicInteger cnt = new AtomicInteger(channelNum);
        List<ISinkChannel> downStreamChannelList = downStreamChannelLocationList.stream().map(downStreamChannelLocation -> this.createChannelForShuffleSink(localFragmentInstanceId, localPlanNodeId, (DownStreamChannelLocation)downStreamChannelLocation, instanceContext, cnt)).collect(Collectors.toList());
        ShuffleSinkHandle shuffleSinkHandle = new ShuffleSinkHandle(localFragmentInstanceId, downStreamChannelList, downStreamChannelIndex, shuffleStrategyEnum, new ShuffleSinkListenerImpl(instanceContext, instanceContext::failed));
        this.shuffleSinkHandles.put(localFragmentInstanceId, shuffleSinkHandle);
        return shuffleSinkHandle;
    }

    private ISinkChannel createChannelForShuffleSink(TFragmentInstanceId localFragmentInstanceId, String localPlanNodeId, DownStreamChannelLocation downStreamChannelLocation, FragmentInstanceContext instanceContext, AtomicInteger cnt) {
        if (DataNodeEndPoints.isSameNode(downStreamChannelLocation.getRemoteEndpoint())) {
            return this.createLocalSinkChannel(localFragmentInstanceId, downStreamChannelLocation.getRemoteFragmentInstanceId(), downStreamChannelLocation.getRemotePlanNodeId(), localPlanNodeId, instanceContext, cnt);
        }
        return this.createSinkChannel(localFragmentInstanceId, downStreamChannelLocation.getRemoteEndpoint(), downStreamChannelLocation.getRemoteFragmentInstanceId(), downStreamChannelLocation.getRemotePlanNodeId(), localPlanNodeId, instanceContext, cnt);
    }

    @Override
    public ISourceHandle createLocalSourceHandleForPipeline(SharedTsBlockQueue queue, DriverContext context) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Create local source handle for {}", (Object)context.getDriverTaskID());
        }
        return new PipelineSourceHandle(queue, new PipelineSourceHandleListenerImpl(context::failed), context.getDriverTaskID().toString());
    }

    @Override
    public synchronized ISourceHandle createLocalSourceHandleForFragment(TFragmentInstanceId localFragmentInstanceId, String localPlanNodeId, String remotePlanNodeId, TFragmentInstanceId remoteFragmentInstanceId, int index, IMPPDataExchangeManagerCallback<Throwable> onFailureCallback) {
        SharedTsBlockQueue queue;
        ISinkHandle sinkHandle;
        if (this.sourceHandles.containsKey(localFragmentInstanceId) && this.sourceHandles.get(localFragmentInstanceId).containsKey(localPlanNodeId)) {
            throw new IllegalStateException("Source handle for plan node " + localPlanNodeId + " of " + localFragmentInstanceId + " exists.");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Create local source handle from {} for plan node {} of {}", new Object[]{remoteFragmentInstanceId, localPlanNodeId, localFragmentInstanceId});
        }
        if ((sinkHandle = this.shuffleSinkHandles.get(remoteFragmentInstanceId)) != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Get SharedTsBlockQueue from local sink handle");
            }
            queue = ((LocalSinkChannel)sinkHandle.getChannel(index)).getSharedTsBlockQueue();
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Create SharedTsBlockQueue");
            }
            queue = new SharedTsBlockQueue(remoteFragmentInstanceId, remotePlanNodeId, this.localMemoryManager, this.executorService);
        }
        LocalSourceHandle localSourceHandle = new LocalSourceHandle(localFragmentInstanceId, localPlanNodeId, queue, new SourceHandleListenerImpl(onFailureCallback));
        this.sourceHandles.computeIfAbsent(localFragmentInstanceId, key -> new ConcurrentHashMap()).put(localPlanNodeId, localSourceHandle);
        return localSourceHandle;
    }

    @Override
    public ISourceHandle createSourceHandle(TFragmentInstanceId localFragmentInstanceId, String localPlanNodeId, int indexOfUpstreamSinkHandle, TEndPoint remoteEndpoint, TFragmentInstanceId remoteFragmentInstanceId, IMPPDataExchangeManagerCallback<Throwable> onFailureCallback) {
        Map<String, ISourceHandle> sourceHandleMap = this.sourceHandles.get(localFragmentInstanceId);
        if (sourceHandleMap != null && sourceHandleMap.containsKey(localPlanNodeId)) {
            throw new IllegalStateException("Source handle for plan node " + localPlanNodeId + " of " + localFragmentInstanceId + " exists.");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Create source handle from {} for plan node {} of {}", new Object[]{remoteFragmentInstanceId, localPlanNodeId, localFragmentInstanceId});
        }
        SourceHandle sourceHandle = new SourceHandle(remoteEndpoint, remoteFragmentInstanceId, localFragmentInstanceId, localPlanNodeId, indexOfUpstreamSinkHandle, this.localMemoryManager, this.executorService, this.tsBlockSerdeFactory.get(), new SourceHandleListenerImpl(onFailureCallback), this.mppDataExchangeServiceClientManager);
        this.sourceHandles.computeIfAbsent(localFragmentInstanceId, key -> new ConcurrentHashMap()).put(localPlanNodeId, sourceHandle);
        return sourceHandle;
    }

    @Override
    public void forceDeregisterFragmentInstance(TFragmentInstanceId fragmentInstanceId) {
        Map<String, ISourceHandle> planNodeIdToSourceHandle;
        ISink sinkHandle;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[StartForceReleaseFIDataExchangeResource]");
        }
        if ((sinkHandle = (ISink)this.shuffleSinkHandles.get(fragmentInstanceId)) != null) {
            sinkHandle.abort();
            this.shuffleSinkHandles.remove(fragmentInstanceId);
        }
        if ((planNodeIdToSourceHandle = this.sourceHandles.get(fragmentInstanceId)) != null) {
            for (Map.Entry<String, ISourceHandle> entry : planNodeIdToSourceHandle.entrySet()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[CloseSourceHandle] {}", (Object)entry.getKey());
                }
                entry.getValue().abort();
            }
            this.sourceHandles.remove(fragmentInstanceId);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[EndForceReleaseFIDataExchangeResource]");
        }
    }

    public static String createFullIdFrom(TFragmentInstanceId fragmentInstanceId, String suffix) {
        return FragmentInstanceId.createFullId(fragmentInstanceId.queryId, fragmentInstanceId.fragmentId, fragmentInstanceId.instanceId) + "." + suffix;
    }

    class MPPDataExchangeServiceImpl
    implements MPPDataExchangeService.Iface {
        private final DataExchangeCostMetricSet DATA_EXCHANGE_COST_METRICS = DataExchangeCostMetricSet.getInstance();
        private final DataExchangeCountMetricSet DATA_EXCHANGE_COUNT_METRICS = DataExchangeCountMetricSet.getInstance();

        MPPDataExchangeServiceImpl() {
        }

        /*
         * Exception decompiling
         */
        public TGetDataBlockResponse getDataBlock(TGetDataBlockRequest req) throws TException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK], 15[FORLOOP]], but top level block is 6[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void onAcknowledgeDataBlockEvent(TAcknowledgeDataBlockEvent e) {
            long startTime = System.nanoTime();
            try (SetThreadName fragmentInstanceName = new SetThreadName(FragmentInstanceId.createFullId(e.sourceFragmentInstanceId.queryId, e.sourceFragmentInstanceId.fragmentId, e.sourceFragmentInstanceId.instanceId));){
                ISinkHandle sinkHandle;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Received AcknowledgeDataBlockEvent for TsBlocks whose sequence ID are in [{}, {}) from {}.", new Object[]{e.getStartSequenceId(), e.getEndSequenceId(), e.getSourceFragmentInstanceId()});
                }
                if ((sinkHandle = (ISinkHandle)MPPDataExchangeManager.this.shuffleSinkHandles.get(e.getSourceFragmentInstanceId())) == null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("received ACK event but target FragmentInstance[{}] is not found.", (Object)e.getSourceFragmentInstanceId());
                    }
                    return;
                }
                ((SinkChannel)sinkHandle.getChannel(e.getIndex())).acknowledgeTsBlock(e.getStartSequenceId(), e.getEndSequenceId());
            }
            catch (Throwable t) {
                LOGGER.warn("ack TsBlock [{}, {}) failed.", new Object[]{e.getStartSequenceId(), e.getEndSequenceId(), t});
                throw t;
            }
            finally {
                this.DATA_EXCHANGE_COST_METRICS.recordDataExchangeCost("on_acknowledge_data_block_event_task_server", System.nanoTime() - startTime);
                this.DATA_EXCHANGE_COUNT_METRICS.recordDataBlockNum("on_acknowledge_data_block_num_server", e.getEndSequenceId() - e.getStartSequenceId());
            }
        }

        public void onCloseSinkChannelEvent(TCloseSinkChannelEvent e) throws TException {
            try (SetThreadName fragmentInstanceName = new SetThreadName(FragmentInstanceId.createFullId(e.sourceFragmentInstanceId.queryId, e.sourceFragmentInstanceId.fragmentId, e.sourceFragmentInstanceId.instanceId));){
                ISinkHandle sinkHandle;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Closed source handle of ShuffleSinkHandle {}, channel index: {}.", (Object)e.getSourceFragmentInstanceId(), (Object)e.getIndex());
                }
                if ((sinkHandle = (ISinkHandle)MPPDataExchangeManager.this.shuffleSinkHandles.get(e.getSourceFragmentInstanceId())) == null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("received CloseSinkChannelEvent but target FragmentInstance[{}] is not found.", (Object)e.getSourceFragmentInstanceId());
                    }
                    return;
                }
                sinkHandle.getChannel(e.getIndex()).close();
            }
            catch (Throwable t) {
                LOGGER.warn("Close channel of ShuffleSinkHandle {}, index {} failed.", new Object[]{e.getSourceFragmentInstanceId(), e.getIndex(), t});
                throw t;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNewDataBlockEvent(TNewDataBlockEvent e) throws TException {
            long startTime = System.nanoTime();
            try (SetThreadName fragmentInstanceName = new SetThreadName(MPPDataExchangeManager.createFullIdFrom(e.targetFragmentInstanceId, e.targetPlanNodeId));){
                Map sourceHandleMap;
                SourceHandle sourceHandle;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("New data block event received, for plan node {} of {} from {}.", new Object[]{e.getTargetPlanNodeId(), e.getTargetFragmentInstanceId(), e.getSourceFragmentInstanceId()});
                }
                SourceHandle sourceHandle2 = sourceHandle = (sourceHandleMap = (Map)MPPDataExchangeManager.this.sourceHandles.get(e.getTargetFragmentInstanceId())) == null ? null : (SourceHandle)sourceHandleMap.get(e.getTargetPlanNodeId());
                if (sourceHandle == null || sourceHandle.isAborted() || sourceHandle.isFinished()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("received NewDataBlockEvent but the downstream FragmentInstance[{}] is not found", (Object)e.getTargetFragmentInstanceId());
                    }
                    return;
                }
                sourceHandle.updatePendingDataBlockInfo(e.getStartSequenceId(), e.getBlockSizes());
            }
            finally {
                this.DATA_EXCHANGE_COST_METRICS.recordDataExchangeCost("send_new_data_block_event_task_server", System.nanoTime() - startTime);
                this.DATA_EXCHANGE_COUNT_METRICS.recordDataBlockNum("send_new_data_block_num_server", e.getBlockSizes().size());
            }
        }

        public void onEndOfDataBlockEvent(TEndOfDataBlockEvent e) throws TException {
            try (SetThreadName fragmentInstanceName = new SetThreadName(MPPDataExchangeManager.createFullIdFrom(e.targetFragmentInstanceId, e.targetPlanNodeId));){
                Map sourceHandleMap;
                SourceHandle sourceHandle;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("End of data block event received, for plan node {} of {} from {}.", new Object[]{e.getTargetPlanNodeId(), e.getTargetFragmentInstanceId(), e.getSourceFragmentInstanceId()});
                }
                SourceHandle sourceHandle2 = sourceHandle = (sourceHandleMap = (Map)MPPDataExchangeManager.this.sourceHandles.get(e.getTargetFragmentInstanceId())) == null ? null : (SourceHandle)sourceHandleMap.get(e.getTargetPlanNodeId());
                if (sourceHandle == null || sourceHandle.isAborted() || sourceHandle.isFinished()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("received onEndOfDataBlockEvent but the downstream FragmentInstance[{}] is not found", (Object)e.getTargetFragmentInstanceId());
                    }
                    return;
                }
                sourceHandle.setNoMoreTsBlocks(e.getLastSequenceId());
            }
        }

        public TSStatus testConnectionEmptyRPC() throws TException {
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
    }

    class ISinkChannelListenerImpl
    implements SinkListener {
        private final TFragmentInstanceId shuffleSinkHandleId;
        private final FragmentInstanceContext context;
        private final IMPPDataExchangeManagerCallback<Throwable> onFailureCallback;
        private final AtomicInteger cnt;
        private final AtomicBoolean hasDecremented = new AtomicBoolean(false);

        public ISinkChannelListenerImpl(TFragmentInstanceId localFragmentInstanceId, FragmentInstanceContext context, IMPPDataExchangeManagerCallback<Throwable> onFailureCallback, AtomicInteger cnt) {
            this.shuffleSinkHandleId = localFragmentInstanceId;
            this.context = context;
            this.onFailureCallback = onFailureCallback;
            this.cnt = cnt;
        }

        @Override
        public void onFinish(ISink sink) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[SkHListenerOnFinish]");
            }
            this.decrementCnt();
        }

        @Override
        public void onEndOfBlocks(ISink sink) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[SkHListenerOnEndOfTsBlocks]");
            }
        }

        @Override
        public Optional<Throwable> onAborted(ISink sink) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[SkHListenerOnAbort]");
            }
            this.decrementCnt();
            return this.context.getFailureCause();
        }

        @Override
        public void onFailure(ISink sink, Throwable t) {
            LOGGER.warn("ISinkChannel failed due to", t);
            this.decrementCnt();
            if (this.onFailureCallback != null) {
                this.onFailureCallback.call(t);
            }
        }

        private void decrementCnt() {
            if (this.hasDecremented.compareAndSet(false, true) && this.cnt.decrementAndGet() == 0) {
                this.closeShuffleSinkHandle();
            }
        }

        private void closeShuffleSinkHandle() {
            ISinkHandle sinkHandle = (ISinkHandle)MPPDataExchangeManager.this.shuffleSinkHandles.remove(this.shuffleSinkHandleId);
            if (sinkHandle != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Close ShuffleSinkHandle: {}", (Object)this.shuffleSinkHandleId);
                }
                sinkHandle.close();
            }
        }
    }

    public static interface SinkListener {
        public void onFinish(ISink var1);

        public void onEndOfBlocks(ISink var1);

        public Optional<Throwable> onAborted(ISink var1);

        public void onFailure(ISink var1, Throwable var2);
    }

    static class PipelineSinkListenerImpl
    implements SinkListener {
        private final FragmentInstanceContext context;
        private final IMPPDataExchangeManagerCallback<Throwable> onFailureCallback;

        public PipelineSinkListenerImpl(FragmentInstanceContext context, IMPPDataExchangeManagerCallback<Throwable> onFailureCallback) {
            this.context = context;
            this.onFailureCallback = onFailureCallback;
        }

        @Override
        public void onFinish(ISink sink) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[SkHListenerOnFinish]");
            }
        }

        @Override
        public void onEndOfBlocks(ISink sink) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[SkHListenerOnEndOfTsBlocks]");
            }
        }

        @Override
        public Optional<Throwable> onAborted(ISink sink) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[SkHListenerOnAbort]");
            }
            return this.context.getFailureCause();
        }

        @Override
        public void onFailure(ISink sink, Throwable t) {
            LOGGER.warn("Sink handle failed due to", t);
            if (this.onFailureCallback != null) {
                this.onFailureCallback.call(t);
            }
        }
    }

    class ShuffleSinkListenerImpl
    implements SinkListener {
        private final FragmentInstanceContext context;
        private final IMPPDataExchangeManagerCallback<Throwable> onFailureCallback;

        public ShuffleSinkListenerImpl(FragmentInstanceContext context, IMPPDataExchangeManagerCallback<Throwable> onFailureCallback) {
            this.context = context;
            this.onFailureCallback = onFailureCallback;
        }

        @Override
        public void onFinish(ISink sink) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[ShuffleSinkHandleListenerOnFinish]");
            }
            MPPDataExchangeManager.this.shuffleSinkHandles.remove(sink.getLocalFragmentInstanceId());
            this.context.finished();
        }

        @Override
        public void onEndOfBlocks(ISink sink) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[ShuffleSinkHandleListenerOnEndOfTsBlocks]");
            }
            this.context.transitionToFlushing();
        }

        @Override
        public Optional<Throwable> onAborted(ISink sink) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[ShuffleSinkHandleListenerOnAbort]");
            }
            MPPDataExchangeManager.this.shuffleSinkHandles.remove(sink.getLocalFragmentInstanceId());
            return this.context.getFailureCause();
        }

        @Override
        public void onFailure(ISink sink, Throwable t) {
            LOGGER.warn("Sink failed due to", t);
            if (this.onFailureCallback != null) {
                this.onFailureCallback.call(t);
            }
        }
    }

    static class PipelineSourceHandleListenerImpl
    implements SourceHandleListener {
        private final IMPPDataExchangeManagerCallback<Throwable> onFailureCallback;

        public PipelineSourceHandleListenerImpl(IMPPDataExchangeManagerCallback<Throwable> onFailureCallback) {
            this.onFailureCallback = onFailureCallback;
        }

        @Override
        public void onFinished(ISourceHandle sourceHandle) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[ScHListenerOnFinish]");
            }
        }

        @Override
        public void onAborted(ISourceHandle sourceHandle) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[ScHListenerOnAbort]");
            }
        }

        @Override
        public void onFailure(ISourceHandle sourceHandle, Throwable t) {
            LOGGER.warn("Source handle failed due to: ", t);
            if (this.onFailureCallback != null) {
                this.onFailureCallback.call(t);
            }
        }
    }

    public static interface SourceHandleListener {
        public void onFinished(ISourceHandle var1);

        public void onAborted(ISourceHandle var1);

        public void onFailure(ISourceHandle var1, Throwable var2);
    }

    class SourceHandleListenerImpl
    implements SourceHandleListener {
        private final IMPPDataExchangeManagerCallback<Throwable> onFailureCallback;

        public SourceHandleListenerImpl(IMPPDataExchangeManagerCallback<Throwable> onFailureCallback) {
            this.onFailureCallback = onFailureCallback;
        }

        @Override
        public void onFinished(ISourceHandle sourceHandle) {
            Map sourceHandleMap;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[ScHListenerOnFinish]");
            }
            if (((sourceHandleMap = (Map)MPPDataExchangeManager.this.sourceHandles.get(sourceHandle.getLocalFragmentInstanceId())) == null || sourceHandleMap.remove(sourceHandle.getLocalPlanNodeId()) == null) && LOGGER.isDebugEnabled()) {
                LOGGER.debug("[ScHListenerAlreadyReleased]");
            }
            if (sourceHandleMap != null && sourceHandleMap.isEmpty()) {
                MPPDataExchangeManager.this.sourceHandles.remove(sourceHandle.getLocalFragmentInstanceId());
            }
        }

        @Override
        public void onAborted(ISourceHandle sourceHandle) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[ScHListenerOnAbort]");
            }
            this.onFinished(sourceHandle);
        }

        @Override
        public void onFailure(ISourceHandle sourceHandle, Throwable t) {
            LOGGER.warn("Source handle failed due to: ", t);
            if (this.onFailureCallback != null) {
                this.onFailureCallback.call(t);
            }
        }
    }
}

