/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.fileSystem.fileOutputFactory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tsfile.fileSystem.FSPath;
import org.apache.tsfile.fileSystem.FSType;
import org.apache.tsfile.fileSystem.fileOutputFactory.FileOutputFactory;
import org.apache.tsfile.fileSystem.fileOutputFactory.HDFSOutputFactory;
import org.apache.tsfile.fileSystem.fileOutputFactory.LocalFSOutputFactory;
import org.apache.tsfile.fileSystem.fileOutputFactory.OSFileOutputFactory;
import org.apache.tsfile.utils.FSUtils;
import org.apache.tsfile.write.writer.TsFileOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HybridFileOutputFactory
implements FileOutputFactory {
    private static final Logger logger = LoggerFactory.getLogger(HybridFileOutputFactory.class);
    private static final Map<FSType, FileOutputFactory> outputFactories = new ConcurrentHashMap<FSType, FileOutputFactory>();

    private FileOutputFactory getFileOutputFactory(FSType fsType) {
        return outputFactories.compute(fsType, (k, v) -> {
            if (v != null) {
                return v;
            }
            switch (fsType) {
                case LOCAL: {
                    return new LocalFSOutputFactory();
                }
                case OBJECT_STORAGE: {
                    return new OSFileOutputFactory();
                }
                case HDFS: {
                    return new HDFSOutputFactory();
                }
            }
            return null;
        });
    }

    @Override
    public TsFileOutput getTsFileOutput(String filePath, boolean append) {
        FSPath path = FSUtils.parse(filePath);
        return this.getFileOutputFactory(path.getFsType()).getTsFileOutput(path.getPath(), append);
    }
}

