/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.agent.task.progress;

import java.util.Objects;

public class CommitterKey {
    private final String pipeName;
    private final long creationTime;
    private final int regionId;
    private final int restartTimes;

    CommitterKey(String pipeName, long creationTime, int regionId) {
        this(pipeName, creationTime, regionId, -1);
    }

    public CommitterKey(String pipeName, long creationTime, int regionId, int restartTimes) {
        this.pipeName = pipeName;
        this.creationTime = creationTime;
        this.regionId = regionId;
        this.restartTimes = restartTimes;
    }

    public String getPipeName() {
        return this.pipeName;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public int getRegionId() {
        return this.regionId;
    }

    public int getRestartTimes() {
        return this.restartTimes;
    }

    public String stringify() {
        return String.format("%s_%s_%s_%s", this.pipeName, this.regionId, this.creationTime, this.restartTimes);
    }

    public int hashCode() {
        return Objects.hash(this.pipeName, this.creationTime, this.regionId, this.restartTimes);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CommitterKey that = (CommitterKey)obj;
        return Objects.equals(this.pipeName, that.pipeName) && Objects.equals(this.creationTime, that.creationTime) && Objects.equals(this.regionId, that.regionId) && Objects.equals(this.restartTimes, that.restartTimes);
    }

    public String toString() {
        return "CommitterKey{pipeName=" + this.pipeName + ", creationTime=" + this.creationTime + ", regionId=" + this.regionId + ", restartTimes=" + this.restartTimes + "}";
    }
}

