/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class ServerOnNetwork
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12189");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12195");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12207");
    private final UInteger recordId;
    private final String serverName;
    private final String discoveryUrl;
    private final String[] serverCapabilities;

    public ServerOnNetwork(UInteger recordId, String serverName, String discoveryUrl, String[] serverCapabilities) {
        this.recordId = recordId;
        this.serverName = serverName;
        this.discoveryUrl = discoveryUrl;
        this.serverCapabilities = serverCapabilities;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public UInteger getRecordId() {
        return this.recordId;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getDiscoveryUrl() {
        return this.discoveryUrl;
    }

    public String[] getServerCapabilities() {
        return this.serverCapabilities;
    }

    protected ServerOnNetwork(ServerOnNetworkBuilder<?, ?> b) {
        super(b);
        this.recordId = ((ServerOnNetworkBuilder)b).recordId;
        this.serverName = ((ServerOnNetworkBuilder)b).serverName;
        this.discoveryUrl = ((ServerOnNetworkBuilder)b).discoveryUrl;
        this.serverCapabilities = ((ServerOnNetworkBuilder)b).serverCapabilities;
    }

    public static ServerOnNetworkBuilder<?, ?> builder() {
        return new ServerOnNetworkBuilderImpl();
    }

    public ServerOnNetworkBuilder<?, ?> toBuilder() {
        return new ServerOnNetworkBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerOnNetwork)) {
            return false;
        }
        ServerOnNetwork other = (ServerOnNetwork)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UInteger this$recordId = this.getRecordId();
        UInteger other$recordId = other.getRecordId();
        if (this$recordId == null ? other$recordId != null : !((Object)this$recordId).equals(other$recordId)) {
            return false;
        }
        String this$serverName = this.getServerName();
        String other$serverName = other.getServerName();
        if (this$serverName == null ? other$serverName != null : !this$serverName.equals(other$serverName)) {
            return false;
        }
        String this$discoveryUrl = this.getDiscoveryUrl();
        String other$discoveryUrl = other.getDiscoveryUrl();
        if (this$discoveryUrl == null ? other$discoveryUrl != null : !this$discoveryUrl.equals(other$discoveryUrl)) {
            return false;
        }
        return Arrays.deepEquals(this.getServerCapabilities(), other.getServerCapabilities());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerOnNetwork;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UInteger $recordId = this.getRecordId();
        result = result * 59 + ($recordId == null ? 43 : ((Object)$recordId).hashCode());
        String $serverName = this.getServerName();
        result = result * 59 + ($serverName == null ? 43 : $serverName.hashCode());
        String $discoveryUrl = this.getDiscoveryUrl();
        result = result * 59 + ($discoveryUrl == null ? 43 : $discoveryUrl.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getServerCapabilities());
        return result;
    }

    @Override
    public String toString() {
        return "ServerOnNetwork(recordId=" + this.getRecordId() + ", serverName=" + this.getServerName() + ", discoveryUrl=" + this.getDiscoveryUrl() + ", serverCapabilities=" + Arrays.deepToString(this.getServerCapabilities()) + ")";
    }

    private static final class ServerOnNetworkBuilderImpl
    extends ServerOnNetworkBuilder<ServerOnNetwork, ServerOnNetworkBuilderImpl> {
        private ServerOnNetworkBuilderImpl() {
        }

        @Override
        protected ServerOnNetworkBuilderImpl self() {
            return this;
        }

        @Override
        public ServerOnNetwork build() {
            return new ServerOnNetwork(this);
        }
    }

    public static abstract class ServerOnNetworkBuilder<C extends ServerOnNetwork, B extends ServerOnNetworkBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private UInteger recordId;
        private String serverName;
        private String discoveryUrl;
        private String[] serverCapabilities;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ServerOnNetworkBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ServerOnNetwork instance, ServerOnNetworkBuilder<?, ?> b) {
            b.recordId(instance.recordId);
            b.serverName(instance.serverName);
            b.discoveryUrl(instance.discoveryUrl);
            b.serverCapabilities(instance.serverCapabilities);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B recordId(UInteger recordId) {
            this.recordId = recordId;
            return (B)this.self();
        }

        public B serverName(String serverName) {
            this.serverName = serverName;
            return (B)this.self();
        }

        public B discoveryUrl(String discoveryUrl) {
            this.discoveryUrl = discoveryUrl;
            return (B)this.self();
        }

        public B serverCapabilities(String[] serverCapabilities) {
            this.serverCapabilities = serverCapabilities;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ServerOnNetwork.ServerOnNetworkBuilder(super=" + super.toString() + ", recordId=" + this.recordId + ", serverName=" + this.serverName + ", discoveryUrl=" + this.discoveryUrl + ", serverCapabilities=" + Arrays.deepToString(this.serverCapabilities) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ServerOnNetwork> {
        @Override
        public Class<ServerOnNetwork> getType() {
            return ServerOnNetwork.class;
        }

        @Override
        public ServerOnNetwork decode(SerializationContext context, UaDecoder decoder) {
            UInteger recordId = decoder.readUInt32("RecordId");
            String serverName = decoder.readString("ServerName");
            String discoveryUrl = decoder.readString("DiscoveryUrl");
            String[] serverCapabilities = decoder.readStringArray("ServerCapabilities");
            return new ServerOnNetwork(recordId, serverName, discoveryUrl, serverCapabilities);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ServerOnNetwork value) {
            encoder.writeUInt32("RecordId", value.getRecordId());
            encoder.writeString("ServerName", value.getServerName());
            encoder.writeString("DiscoveryUrl", value.getDiscoveryUrl());
            encoder.writeStringArray("ServerCapabilities", value.getServerCapabilities());
        }
    }
}

