/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceNode;
import org.eclipse.milo.opcua.stack.core.types.structured.TypeNode;

public class ReferenceTypeNode
extends TypeNode
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=273");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=275");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=274");
    private final Boolean isAbstract;
    private final Boolean symmetric;
    private final LocalizedText inverseName;

    public ReferenceTypeNode(NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, ReferenceNode[] references, Boolean isAbstract, Boolean symmetric, LocalizedText inverseName) {
        super(nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, references);
        this.isAbstract = isAbstract;
        this.symmetric = symmetric;
        this.inverseName = inverseName;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public Boolean getIsAbstract() {
        return this.isAbstract;
    }

    public Boolean getSymmetric() {
        return this.symmetric;
    }

    public LocalizedText getInverseName() {
        return this.inverseName;
    }

    protected ReferenceTypeNode(ReferenceTypeNodeBuilder<?, ?> b) {
        super((TypeNode.TypeNodeBuilder<?, ?>)b);
        this.isAbstract = ((ReferenceTypeNodeBuilder)b).isAbstract;
        this.symmetric = ((ReferenceTypeNodeBuilder)b).symmetric;
        this.inverseName = ((ReferenceTypeNodeBuilder)b).inverseName;
    }

    public static ReferenceTypeNodeBuilder<?, ?> builder() {
        return new ReferenceTypeNodeBuilderImpl();
    }

    @Override
    public ReferenceTypeNodeBuilder<?, ?> toBuilder() {
        return new ReferenceTypeNodeBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReferenceTypeNode)) {
            return false;
        }
        ReferenceTypeNode other = (ReferenceTypeNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isAbstract = this.getIsAbstract();
        Boolean other$isAbstract = other.getIsAbstract();
        if (this$isAbstract == null ? other$isAbstract != null : !((Object)this$isAbstract).equals(other$isAbstract)) {
            return false;
        }
        Boolean this$symmetric = this.getSymmetric();
        Boolean other$symmetric = other.getSymmetric();
        if (this$symmetric == null ? other$symmetric != null : !((Object)this$symmetric).equals(other$symmetric)) {
            return false;
        }
        LocalizedText this$inverseName = this.getInverseName();
        LocalizedText other$inverseName = other.getInverseName();
        return !(this$inverseName == null ? other$inverseName != null : !((Object)this$inverseName).equals(other$inverseName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ReferenceTypeNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isAbstract = this.getIsAbstract();
        result = result * 59 + ($isAbstract == null ? 43 : ((Object)$isAbstract).hashCode());
        Boolean $symmetric = this.getSymmetric();
        result = result * 59 + ($symmetric == null ? 43 : ((Object)$symmetric).hashCode());
        LocalizedText $inverseName = this.getInverseName();
        result = result * 59 + ($inverseName == null ? 43 : ((Object)$inverseName).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ReferenceTypeNode(isAbstract=" + this.getIsAbstract() + ", symmetric=" + this.getSymmetric() + ", inverseName=" + this.getInverseName() + ")";
    }

    private static final class ReferenceTypeNodeBuilderImpl
    extends ReferenceTypeNodeBuilder<ReferenceTypeNode, ReferenceTypeNodeBuilderImpl> {
        private ReferenceTypeNodeBuilderImpl() {
        }

        @Override
        protected ReferenceTypeNodeBuilderImpl self() {
            return this;
        }

        @Override
        public ReferenceTypeNode build() {
            return new ReferenceTypeNode(this);
        }
    }

    public static abstract class ReferenceTypeNodeBuilder<C extends ReferenceTypeNode, B extends ReferenceTypeNodeBuilder<C, B>>
    extends TypeNode.TypeNodeBuilder<C, B> {
        private Boolean isAbstract;
        private Boolean symmetric;
        private LocalizedText inverseName;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ReferenceTypeNodeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ReferenceTypeNode instance, ReferenceTypeNodeBuilder<?, ?> b) {
            b.isAbstract(instance.isAbstract);
            b.symmetric(instance.symmetric);
            b.inverseName(instance.inverseName);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B isAbstract(Boolean isAbstract) {
            this.isAbstract = isAbstract;
            return (B)this.self();
        }

        public B symmetric(Boolean symmetric) {
            this.symmetric = symmetric;
            return (B)this.self();
        }

        public B inverseName(LocalizedText inverseName) {
            this.inverseName = inverseName;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ReferenceTypeNode.ReferenceTypeNodeBuilder(super=" + super.toString() + ", isAbstract=" + this.isAbstract + ", symmetric=" + this.symmetric + ", inverseName=" + this.inverseName + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ReferenceTypeNode> {
        @Override
        public Class<ReferenceTypeNode> getType() {
            return ReferenceTypeNode.class;
        }

        @Override
        public ReferenceTypeNode decode(SerializationContext context, UaDecoder decoder) {
            NodeId nodeId = decoder.readNodeId("NodeId");
            NodeClass nodeClass = decoder.readEnum("NodeClass", NodeClass.class);
            QualifiedName browseName = decoder.readQualifiedName("BrowseName");
            LocalizedText displayName = decoder.readLocalizedText("DisplayName");
            LocalizedText description = decoder.readLocalizedText("Description");
            UInteger writeMask = decoder.readUInt32("WriteMask");
            UInteger userWriteMask = decoder.readUInt32("UserWriteMask");
            ReferenceNode[] references = (ReferenceNode[])decoder.readStructArray("References", ReferenceNode.TYPE_ID);
            Boolean isAbstract = decoder.readBoolean("IsAbstract");
            Boolean symmetric = decoder.readBoolean("Symmetric");
            LocalizedText inverseName = decoder.readLocalizedText("InverseName");
            return new ReferenceTypeNode(nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, references, isAbstract, symmetric, inverseName);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ReferenceTypeNode value) {
            encoder.writeNodeId("NodeId", value.getNodeId());
            encoder.writeEnum("NodeClass", value.getNodeClass());
            encoder.writeQualifiedName("BrowseName", value.getBrowseName());
            encoder.writeLocalizedText("DisplayName", value.getDisplayName());
            encoder.writeLocalizedText("Description", value.getDescription());
            encoder.writeUInt32("WriteMask", value.getWriteMask());
            encoder.writeUInt32("UserWriteMask", value.getUserWriteMask());
            encoder.writeStructArray("References", (Object[])value.getReferences(), ReferenceNode.TYPE_ID);
            encoder.writeBoolean("IsAbstract", value.getIsAbstract());
            encoder.writeBoolean("Symmetric", value.getSymmetric());
            encoder.writeLocalizedText("InverseName", value.getInverseName());
        }
    }
}

