/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.client.request;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;

public class AsyncRequestContext<Request, Response, RequestType, NodeLocation> {
    protected final RequestType requestType;
    private final Map<Integer, Request> requestMap;
    private final ConcurrentHashMap<Integer, NodeLocation> nodeLocationMap;
    private final Map<Integer, Response> responseMap;
    private CountDownLatch countDownLatch;

    public AsyncRequestContext(RequestType requestType) {
        this.requestType = requestType;
        this.requestMap = new ConcurrentHashMap<Integer, Request>();
        this.nodeLocationMap = new ConcurrentHashMap();
        this.responseMap = new ConcurrentHashMap<Integer, Response>();
    }

    public void putRequest(int requestId, Request request) {
        this.requestMap.put(requestId, request);
    }

    public void putNodeLocation(int requestId, NodeLocation nodeLocation) {
        this.nodeLocationMap.put(requestId, nodeLocation);
    }

    public AsyncRequestContext(RequestType requestType, Map<Integer, NodeLocation> nodeLocationMap) {
        this.requestType = requestType;
        this.nodeLocationMap = new ConcurrentHashMap<Integer, NodeLocation>(nodeLocationMap);
        this.requestMap = new ConcurrentHashMap<Integer, Request>();
        this.responseMap = new ConcurrentHashMap<Integer, Response>();
    }

    public AsyncRequestContext(RequestType requestType, Request request, Map<Integer, NodeLocation> nodeLocationMap) {
        this.requestType = requestType;
        this.nodeLocationMap = new ConcurrentHashMap<Integer, NodeLocation>(nodeLocationMap);
        this.requestMap = new ConcurrentHashMap<Integer, Request>();
        ((ConcurrentHashMap.KeySetView)this.nodeLocationMap.keySet()).forEach(nodeId -> this.requestMap.put((Integer)nodeId, request));
        this.responseMap = new ConcurrentHashMap<Integer, Response>();
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public List<Integer> getRequestIndices() {
        return new ArrayList<Integer>(this.nodeLocationMap.keySet());
    }

    public Request getRequest(int requestId) {
        return this.requestMap.get(requestId);
    }

    public NodeLocation getNodeLocation(int requestId) {
        return this.nodeLocationMap.get(requestId);
    }

    public Map<Integer, NodeLocation> getNodeLocationMap() {
        return this.nodeLocationMap;
    }

    public List<Response> getResponseList() {
        return new ArrayList<Response>(this.responseMap.values());
    }

    public Map<Integer, Response> getResponseMap() {
        return this.responseMap;
    }

    public void resetCountDownLatch() {
        this.countDownLatch = new CountDownLatch(this.nodeLocationMap.size());
    }

    public CountDownLatch getCountDownLatch() {
        return this.countDownLatch;
    }
}

