/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.schema;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.runtime.ThriftSerDeException;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.utils.ThriftConfigNodeSerDeUtils;
import org.apache.iotdb.confignode.client.async.CnToDnAsyncRequestType;
import org.apache.iotdb.confignode.client.async.CnToDnInternalServiceAsyncRequestManager;
import org.apache.iotdb.confignode.client.async.handlers.DataNodeAsyncRequestContext;
import org.apache.iotdb.confignode.consensus.request.write.database.PreDeleteDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.write.region.OfferRegionMaintainTasksPlan;
import org.apache.iotdb.confignode.manager.partition.PartitionMetrics;
import org.apache.iotdb.confignode.persistence.partition.maintainer.RegionDeleteTask;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.state.schema.DeleteStorageGroupState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteDatabaseProcedure
extends StateMachineProcedure<ConfigNodeProcedureEnv, DeleteStorageGroupState> {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteDatabaseProcedure.class);
    private static final int RETRY_THRESHOLD = 5;
    private TDatabaseSchema deleteDatabaseSchema;

    public DeleteDatabaseProcedure(boolean isGeneratedByPipe) {
        super(isGeneratedByPipe);
    }

    public DeleteDatabaseProcedure(TDatabaseSchema deleteDatabaseSchema, boolean isGeneratedByPipe) {
        super(isGeneratedByPipe);
        this.deleteDatabaseSchema = deleteDatabaseSchema;
    }

    public TDatabaseSchema getDeleteDatabaseSchema() {
        return this.deleteDatabaseSchema;
    }

    public void setDeleteDatabaseSchema(TDatabaseSchema deleteDatabaseSchema) {
        this.deleteDatabaseSchema = deleteDatabaseSchema;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, DeleteStorageGroupState state) throws InterruptedException {
        block18: {
            if (this.deleteDatabaseSchema == null) {
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
            try {
                switch (state) {
                    case PRE_DELETE_DATABASE: {
                        LOG.info("[DeleteDatabaseProcedure] Pre delete database: {}", (Object)this.deleteDatabaseSchema.getName());
                        env.preDeleteDatabase(PreDeleteDatabasePlan.PreDeleteType.EXECUTE, this.deleteDatabaseSchema.getName());
                        this.setNextState(DeleteStorageGroupState.INVALIDATE_CACHE);
                        break;
                    }
                    case INVALIDATE_CACHE: {
                        LOG.info("[DeleteDatabaseProcedure] Invalidate cache of database: {}", (Object)this.deleteDatabaseSchema.getName());
                        if (env.invalidateCache(this.deleteDatabaseSchema.getName())) {
                            this.setNextState(DeleteStorageGroupState.DELETE_DATABASE_SCHEMA);
                            break;
                        }
                        this.setFailure(new ProcedureException("[DeleteDatabaseProcedure] Invalidate cache failed"));
                        break;
                    }
                    case DELETE_DATABASE_SCHEMA: {
                        LOG.info("[DeleteDatabaseProcedure] Delete DatabaseSchema: {}", (Object)this.deleteDatabaseSchema.getName());
                        OfferRegionMaintainTasksPlan dataRegionDeleteTaskOfferPlan = new OfferRegionMaintainTasksPlan();
                        List<TRegionReplicaSet> regionReplicaSets = env.getAllReplicaSets(this.deleteDatabaseSchema.getName());
                        ArrayList schemaRegionReplicaSets = new ArrayList();
                        regionReplicaSets.forEach(regionReplicaSet -> {
                            env.getConfigManager().getLoadManager().removeRegionGroupRelatedCache(regionReplicaSet.getRegionId());
                            if (regionReplicaSet.getRegionId().getType().equals((Object)TConsensusGroupType.SchemaRegion)) {
                                schemaRegionReplicaSets.add(regionReplicaSet);
                            } else {
                                regionReplicaSet.getDataNodeLocations().forEach(targetDataNode -> dataRegionDeleteTaskOfferPlan.appendRegionMaintainTask(new RegionDeleteTask((TDataNodeLocation)targetDataNode, regionReplicaSet.getRegionId())));
                            }
                        });
                        if (!dataRegionDeleteTaskOfferPlan.getRegionMaintainTaskList().isEmpty()) {
                            env.getConfigManager().getConsensusManager().write(dataRegionDeleteTaskOfferPlan);
                        }
                        DataNodeAsyncRequestContext asyncClientHandler = new DataNodeAsyncRequestContext(CnToDnAsyncRequestType.DELETE_REGION);
                        HashMap<Integer, RegionDeleteTask> schemaRegionDeleteTaskMap = new HashMap<Integer, RegionDeleteTask>();
                        int requestIndex = 0;
                        for (TRegionReplicaSet tRegionReplicaSet : schemaRegionReplicaSets) {
                            for (TDataNodeLocation dataNodeLocation : tRegionReplicaSet.getDataNodeLocations()) {
                                asyncClientHandler.putRequest(requestIndex, tRegionReplicaSet.getRegionId());
                                asyncClientHandler.putNodeLocation(requestIndex, dataNodeLocation);
                                schemaRegionDeleteTaskMap.put(requestIndex, new RegionDeleteTask(dataNodeLocation, tRegionReplicaSet.getRegionId()));
                                ++requestIndex;
                            }
                        }
                        if (!schemaRegionDeleteTaskMap.isEmpty()) {
                            CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(asyncClientHandler);
                            for (Map.Entry entry : asyncClientHandler.getResponseMap().entrySet()) {
                                if (((TSStatus)entry.getValue()).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                                    LOG.info("[DeleteDatabaseProcedure] Successfully delete SchemaRegion[{}] on {}", asyncClientHandler.getRequest((Integer)entry.getKey()), (Object)((RegionDeleteTask)schemaRegionDeleteTaskMap.get(entry.getKey())).getTargetDataNode());
                                    schemaRegionDeleteTaskMap.remove(entry.getKey());
                                    continue;
                                }
                                LOG.warn("[DeleteDatabaseProcedure] Failed to delete SchemaRegion[{}] on {}. Submit to async deletion.", asyncClientHandler.getRequest((Integer)entry.getKey()), (Object)((RegionDeleteTask)schemaRegionDeleteTaskMap.get(entry.getKey())).getTargetDataNode());
                            }
                            if (!schemaRegionDeleteTaskMap.isEmpty()) {
                                OfferRegionMaintainTasksPlan schemaRegionDeleteTaskOfferPlan = new OfferRegionMaintainTasksPlan();
                                schemaRegionDeleteTaskMap.values().forEach(schemaRegionDeleteTaskOfferPlan::appendRegionMaintainTask);
                                env.getConfigManager().getConsensusManager().write(schemaRegionDeleteTaskOfferPlan);
                            }
                        }
                        env.getConfigManager().getLoadManager().clearDataPartitionPolicyTable(this.deleteDatabaseSchema.getName());
                        LOG.info("data partition policy table cleared.");
                        PartitionMetrics.unbindDatabaseRelatedMetricsWhenUpdate((AbstractMetricService)MetricService.getInstance(), this.deleteDatabaseSchema.getName());
                        TSStatus deleteConfigResult = env.deleteDatabaseConfig(this.deleteDatabaseSchema.getName(), this.isGeneratedByPipe);
                        if (deleteConfigResult.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                            LOG.info("[DeleteDatabaseProcedure] Database: {} is deleted successfully", (Object)this.deleteDatabaseSchema.getName());
                            return StateMachineProcedure.Flow.NO_MORE_STATE;
                        }
                        if (this.getCycles() <= 5) break;
                        this.setFailure(new ProcedureException("[DeleteDatabaseProcedure] Delete DatabaseSchema failed"));
                    }
                }
            }
            catch (IOException | ConsensusException | TException e) {
                if (this.isRollbackSupported(state)) {
                    this.setFailure(new ProcedureException("[DeleteDatabaseProcedure] Delete database " + this.deleteDatabaseSchema.getName() + " failed " + (Object)((Object)state)));
                }
                LOG.error("[DeleteDatabaseProcedure] Retriable error trying to delete database {}, state {}", new Object[]{this.deleteDatabaseSchema.getName(), state, e});
                if (this.getCycles() <= 5) break block18;
                this.setFailure(new ProcedureException("[DeleteDatabaseProcedure] State stuck at " + (Object)((Object)state)));
            }
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, DeleteStorageGroupState state) throws IOException, InterruptedException {
        switch (state) {
            case PRE_DELETE_DATABASE: 
            case INVALIDATE_CACHE: {
                LOG.info("[DeleteDatabaseProcedure] Rollback to preDeleted: {}", (Object)this.deleteDatabaseSchema.getName());
                env.preDeleteDatabase(PreDeleteDatabasePlan.PreDeleteType.ROLLBACK, this.deleteDatabaseSchema.getName());
                break;
            }
        }
    }

    @Override
    protected boolean isRollbackSupported(DeleteStorageGroupState state) {
        switch (state) {
            case PRE_DELETE_DATABASE: 
            case INVALIDATE_CACHE: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected DeleteStorageGroupState getState(int stateId) {
        return DeleteStorageGroupState.values()[stateId];
    }

    @Override
    protected int getStateId(DeleteStorageGroupState deleteStorageGroupState) {
        return deleteStorageGroupState.ordinal();
    }

    @Override
    protected DeleteStorageGroupState getInitialState() {
        return DeleteStorageGroupState.PRE_DELETE_DATABASE;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(this.isGeneratedByPipe ? ProcedureType.PIPE_ENRICHED_DELETE_DATABASE_PROCEDURE.getTypeCode() : ProcedureType.DELETE_DATABASE_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ThriftConfigNodeSerDeUtils.serializeTDatabaseSchema((TDatabaseSchema)this.deleteDatabaseSchema, (OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        try {
            this.deleteDatabaseSchema = ThriftConfigNodeSerDeUtils.deserializeTDatabaseSchema((ByteBuffer)byteBuffer);
        }
        catch (ThriftSerDeException e) {
            LOG.error("Error in deserialize DeleteStorageGroupProcedure", (Throwable)e);
        }
    }

    public boolean equals(Object that) {
        if (that instanceof DeleteDatabaseProcedure) {
            DeleteDatabaseProcedure thatProc = (DeleteDatabaseProcedure)that;
            return thatProc.getProcId() == this.getProcId() && ((DeleteStorageGroupState)((Object)thatProc.getCurrentState())).equals(this.getCurrentState()) && thatProc.getCycles() == this.getCycles() && thatProc.isGeneratedByPipe == this.isGeneratedByPipe && thatProc.deleteDatabaseSchema.equals(this.getDeleteDatabaseSchema());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getProcId(), this.getCurrentState(), this.getCycles(), this.isGeneratedByPipe, this.deleteDatabaseSchema);
    }
}

