/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.cache.region;

import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.confignode.manager.load.cache.AbstractHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.AbstractLoadCache;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionStatistics;

public class RegionCache
extends AbstractLoadCache {
    public RegionCache() {
        this.currentStatistics.set(RegionStatistics.generateDefaultRegionStatistics());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateCurrentStatistics(boolean forceUpdate) {
        List list = this.slidingWindow;
        synchronized (list) {
            RegionHeartbeatSample lastSample = (RegionHeartbeatSample)this.getLastSample();
            List<AbstractHeartbeatSample> history = Collections.unmodifiableList(this.slidingWindow);
            long currentNanoTime = System.nanoTime();
            RegionStatus status = lastSample == null ? RegionStatus.Unknown : (!this.failureDetector.isAvailable(history) ? RegionStatus.Unknown : lastSample.getStatus());
            this.currentStatistics.set(new RegionStatistics(currentNanoTime, status));
        }
    }

    @Override
    public RegionStatistics getCurrentStatistics() {
        return (RegionStatistics)this.currentStatistics.get();
    }

    public synchronized void cacheHeartbeatSample(RegionHeartbeatSample newHeartbeatSample, boolean overwrite) {
        if (overwrite || this.getLastSample() == null) {
            super.cacheHeartbeatSample(newHeartbeatSample);
            return;
        }
        RegionStatus lastStatus = ((RegionHeartbeatSample)this.getLastSample()).getStatus();
        if (lastStatus.equals((Object)RegionStatus.Adding) || lastStatus.equals((Object)RegionStatus.Removing)) {
            RegionHeartbeatSample fakeHeartbeatSample = new RegionHeartbeatSample(newHeartbeatSample.getSampleLogicalTimestamp(), lastStatus);
            super.cacheHeartbeatSample(fakeHeartbeatSample);
        } else {
            super.cacheHeartbeatSample(newHeartbeatSample);
        }
    }
}

