/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.pipe.payload;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class PipeDeleteLogicalViewPlan
extends ConfigPhysicalPlan {
    private ByteBuffer patternTreeBytes;

    public PipeDeleteLogicalViewPlan() {
        super(ConfigPhysicalPlanType.PipeDeleteLogicalView);
    }

    public PipeDeleteLogicalViewPlan(@Nonnull ByteBuffer patternTreeBytes) {
        super(ConfigPhysicalPlanType.PipeDeleteLogicalView);
        this.patternTreeBytes = patternTreeBytes;
    }

    public ByteBuffer getPatternTreeBytes() {
        this.patternTreeBytes.rewind();
        return this.patternTreeBytes;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ReadWriteIOUtils.write((ByteBuffer)this.patternTreeBytes, (OutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.patternTreeBytes = ByteBuffer.wrap(ReadWriteIOUtils.readBinary((ByteBuffer)buffer).getValues());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PipeDeleteLogicalViewPlan that = (PipeDeleteLogicalViewPlan)obj;
        return Arrays.equals(this.patternTreeBytes.array(), that.patternTreeBytes.array());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.patternTreeBytes);
    }

    public String toString() {
        return "PipeDeleteLogicalViewPlan{patternTreeBytes='" + Arrays.toString(this.patternTreeBytes.array()) + "'}";
    }
}

