/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.utils;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStoreUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileStoreUtils.class);

    public static FileStore getFileStore(String dir) {
        Path path = Paths.get(dir, new String[0]);
        FileStore fileStore = null;
        while (fileStore == null && path != null) {
            try {
                fileStore = Files.getFileStore(path);
            }
            catch (NoSuchFileException e) {
                path = path.getParent();
            }
            catch (IOException e) {
                logger.warn("Failed to get storage path of {}, because", (Object)dir, (Object)e);
                break;
            }
        }
        if (path == null) {
            path = Paths.get("./", new String[0]);
            try {
                fileStore = Files.getFileStore(path);
            }
            catch (IOException innerException) {
                logger.warn("Failed to get storage path of {}, because", (Object)dir, (Object)innerException);
            }
        }
        return fileStore;
    }
}

