/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.tsfile;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public enum TsFileResourceBlockType {
    EMPTY_BLOCK(0),
    PROGRESS_INDEX(1),
    REMOTE_STORAGE_BLOCK(2),
    PIPE_MARK(3);

    private final byte type;

    private TsFileResourceBlockType(byte type) {
        this.type = type;
    }

    public void serialize(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((byte)this.type, (OutputStream)outputStream);
    }

    public static TsFileResourceBlockType deserialize(byte type) {
        switch (type) {
            case 0: {
                return EMPTY_BLOCK;
            }
            case 1: {
                return PROGRESS_INDEX;
            }
            case 3: {
                return PIPE_MARK;
            }
        }
        throw new IllegalArgumentException("Invalid input: " + type);
    }
}

