/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.repair;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.db.storageengine.dataregion.compaction.repair.RepairTimePartition;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileRepairStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;

public class RepairLogger
implements Closeable {
    static final String repairTaskStartTimeLogPrefix = "TASK_START_TIME";
    static final String repairTimePartitionStartLogPrefix = "START_TIME_PARTITION";
    static final String cannotRepairFileLogPrefix = "TSFILE";
    static final String repairTimePartitionEndLogPrefix = "END_TIME_PARTITION";
    public static final String repairProgressFileName = "repair-data.progress";
    public static final String repairProgressStoppedFileName = "repair-data.stopped";
    public static final String repairLogDir = "repair";
    private File logFile;
    private final File logFileDir;
    private FileOutputStream logStream;
    private boolean hasPreviousTask = false;
    private boolean isPreviousTaskStopped = false;
    private boolean needRecoverFromLogFile = false;

    public RepairLogger(File logFileDir, boolean recover) throws IOException {
        this.logFileDir = logFileDir;
        this.checkPreviousRepairTaskStatus();
        if (recover) {
            this.recoverPreviousTask();
        } else {
            this.startRepairTask();
        }
    }

    private void checkPreviousRepairTaskStatus() {
        File[] files = this.logFileDir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            String fileName = file.getName();
            if (repairProgressFileName.equals(fileName)) {
                this.hasPreviousTask = true;
                this.logFile = file;
                continue;
            }
            if (!repairProgressStoppedFileName.equals(fileName)) continue;
            this.hasPreviousTask = true;
            this.isPreviousTaskStopped = true;
            this.logFile = file;
        }
    }

    private void startRepairTask() throws IOException {
        if (this.hasPreviousTask && this.isPreviousTaskStopped) {
            this.unmarkStopped();
            this.recoverPreviousTask();
            return;
        }
        this.deletePreviousLogFileIfExists();
        this.createNewLogFile();
    }

    private void unmarkStopped() throws IOException {
        File progressFile = new File(this.logFileDir.getPath() + File.separator + repairProgressFileName);
        File stoppedFile = new File(this.logFileDir.getPath() + File.separator + repairProgressStoppedFileName);
        if (stoppedFile.exists()) {
            Files.move(stoppedFile.toPath(), progressFile.toPath(), new CopyOption[0]);
            this.logFile = progressFile;
        }
        this.isPreviousTaskStopped = false;
    }

    private void deletePreviousLogFileIfExists() throws IOException {
        File[] files = this.logFileDir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (!repairProgressFileName.equals(file.getName())) continue;
            Files.deleteIfExists(file.toPath());
            return;
        }
    }

    private void createNewLogFile() throws IOException {
        this.logFile = new File(this.logFileDir.getPath() + File.separator + repairProgressFileName);
        Path logFilePath = this.logFile.toPath();
        if (!Files.exists(logFilePath, new LinkOption[0])) {
            Files.createFile(logFilePath, new FileAttribute[0]);
        }
        this.logStream = new FileOutputStream(this.logFile, true);
    }

    private void recoverPreviousTask() throws FileNotFoundException {
        if (!this.hasPreviousTask) {
            return;
        }
        this.needRecoverFromLogFile = true;
        if (!this.isPreviousTaskStopped) {
            this.logStream = new FileOutputStream(this.logFile, true);
        }
    }

    public boolean isNeedRecoverFromLogFile() {
        return this.needRecoverFromLogFile;
    }

    public boolean isPreviousTaskStopped() {
        return this.isPreviousTaskStopped;
    }

    public File getLogFile() {
        return this.logFile;
    }

    public void recordRepairTaskStartTimeIfLogFileEmpty(long repairTaskStartTime) throws IOException {
        if (this.logFile.length() != 0L) {
            return;
        }
        String repairTaskStartTimeLog = String.format("%s %s\n", repairTaskStartTimeLogPrefix, repairTaskStartTime);
        this.logStream.write(repairTaskStartTimeLog.getBytes());
    }

    public void recordRepairedTimePartition(RepairTimePartition timePartition) throws IOException {
        this.markStartOfRepairedTimePartition(timePartition);
        this.recordCannotRepairFiles(timePartition);
        this.markEndOfRepairedTimePartition(timePartition);
    }

    public void recordCannotRepairFiles(RepairTimePartition timePartition) throws IOException {
        List<TsFileResource> resources = timePartition.getAllFileSnapshot();
        List cannotRepairFiles = resources.stream().filter(resource -> resource.getTsFileRepairStatus() == TsFileRepairStatus.CAN_NOT_REPAIR).collect(Collectors.toList());
        for (TsFileResource cannotRepairFile : cannotRepairFiles) {
            this.recordOneFile(cannotRepairFile);
        }
    }

    public void markStartOfRepairedTimePartition(RepairTimePartition timePartition) throws IOException {
        String startTimePartitionLog = String.format("%s %s %s %s\n", repairTimePartitionStartLogPrefix, timePartition.getDatabaseName(), timePartition.getDataRegionId(), timePartition.getTimePartitionId());
        this.logStream.write(startTimePartitionLog.getBytes());
    }

    public void markEndOfRepairedTimePartition(RepairTimePartition timePartition) throws IOException {
        String endTimePartitionLog = String.format("%s\n", repairTimePartitionEndLogPrefix);
        this.logStream.write(endTimePartitionLog.getBytes());
        this.logStream.flush();
    }

    public void recordOneFile(TsFileResource resource) throws IOException {
        String fileLog = String.format("%s %s\n", cannotRepairFileLogPrefix, resource.getTsFile().getAbsolutePath());
        this.logStream.write(fileLog.getBytes());
    }

    public String getRepairLogFilePath() {
        return this.logFile.getAbsolutePath();
    }

    @Override
    public void close() throws IOException {
        if (this.logStream != null) {
            this.logStream.getFD().sync();
            this.logStream.close();
        }
    }
}

