/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.buffer;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.LongConsumer;
import org.apache.iotdb.commons.exception.IoTDBIORuntimeException;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.queryengine.metric.ChunkCacheMetrics;
import org.apache.iotdb.db.queryengine.metric.SeriesScanCostMetricSet;
import org.apache.iotdb.db.storageengine.dataregion.read.control.FileReaderManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileID;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChunkCache.class);
    private static final Logger DEBUG_LOGGER = LoggerFactory.getLogger((String)"QUERY_DEBUG");
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private static final long MEMORY_THRESHOLD_IN_CHUNK_CACHE = CONFIG.getAllocateMemoryForChunkCache();
    private static final boolean CACHE_ENABLE = CONFIG.isMetaDataCacheEnable();
    private static final SeriesScanCostMetricSet SERIES_SCAN_COST_METRIC_SET = SeriesScanCostMetricSet.getInstance();
    private final Cache<ChunkCacheKey, Chunk> lruCache;

    private ChunkCache() {
        if (CACHE_ENABLE) {
            LOGGER.info("ChunkCache size = {}", (Object)MEMORY_THRESHOLD_IN_CHUNK_CACHE);
        }
        this.lruCache = Caffeine.newBuilder().maximumWeight(MEMORY_THRESHOLD_IN_CHUNK_CACHE).weigher((key, chunk) -> (int)(key.getRetainedSizeInBytes() + chunk.getRetainedSizeInBytes())).recordStats().build();
        MetricService.getInstance().addMetricSet((IMetricSet)new ChunkCacheMetrics(this));
    }

    public double getHitRate() {
        return this.lruCache.stats().hitRate() * 100.0;
    }

    public static ChunkCache getInstance() {
        return ChunkCacheHolder.INSTANCE;
    }

    public Chunk get(ChunkCacheKey chunkCacheKey, List<TimeRange> timeRangeList, Statistics chunkStatistic) throws IOException {
        LongConsumer emptyConsumer = l -> {};
        return this.get(chunkCacheKey, timeRangeList, chunkStatistic, false, emptyConsumer, emptyConsumer, emptyConsumer);
    }

    public Chunk get(ChunkCacheKey chunkCacheKey, List<TimeRange> timeRangeList, Statistics chunkStatistic, QueryContext queryContext) throws IOException {
        LongConsumer ioSizeRecorder = queryContext.getQueryStatistics().getLoadChunkActualIOSize()::addAndGet;
        LongConsumer cacheHitAdder = queryContext.getQueryStatistics().getLoadChunkFromCacheCount()::addAndGet;
        LongConsumer cacheMissAdder = queryContext.getQueryStatistics().getLoadChunkFromDiskCount()::addAndGet;
        return this.get(chunkCacheKey, timeRangeList, chunkStatistic, queryContext.isDebug(), ioSizeRecorder, cacheHitAdder, cacheMissAdder);
    }

    private Chunk get(ChunkCacheKey chunkCacheKey, List<TimeRange> timeRangeList, Statistics chunkStatistic, boolean debug, LongConsumer ioSizeRecorder, LongConsumer cacheHitAdder, LongConsumer cacheMissAdder) throws IOException {
        long startTime = System.nanoTime();
        ChunkLoader chunkLoader = new ChunkLoader(ioSizeRecorder);
        try {
            if (!CACHE_ENABLE) {
                Chunk chunk = chunkLoader.apply(chunkCacheKey);
                Chunk chunk2 = this.constructChunk(chunk, timeRangeList, chunkStatistic);
                return chunk2;
            }
            Chunk chunk = (Chunk)this.lruCache.get((Object)chunkCacheKey, (Function)chunkLoader);
            if (debug) {
                DEBUG_LOGGER.info("get chunk from cache whose key is: {}", (Object)chunkCacheKey);
            }
            Chunk chunk3 = this.constructChunk(chunk, timeRangeList, chunkStatistic);
            return chunk3;
        }
        catch (IoTDBIORuntimeException e) {
            throw e.getCause();
        }
        finally {
            if (chunkLoader.isCacheMiss()) {
                cacheMissAdder.accept(1L);
            } else {
                cacheHitAdder.accept(1L);
            }
            SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("read_chunk_all", System.nanoTime() - startTime);
        }
    }

    private Chunk constructChunk(Chunk chunk, List<TimeRange> timeRangeList, Statistics chunkStatistic) {
        return new Chunk(chunk.getHeader(), chunk.getData().duplicate(), timeRangeList, chunkStatistic);
    }

    public double calculateChunkHitRatio() {
        return this.lruCache.stats().hitRate();
    }

    public long getEvictionCount() {
        return this.lruCache.stats().evictionCount();
    }

    public long getMaxMemory() {
        return MEMORY_THRESHOLD_IN_CHUNK_CACHE;
    }

    public double getAverageLoadPenalty() {
        return this.lruCache.stats().averageLoadPenalty();
    }

    public void clear() {
        this.lruCache.invalidateAll();
        this.lruCache.cleanUp();
    }

    public boolean isEmpty() {
        return this.lruCache.asMap().isEmpty();
    }

    private static class ChunkCacheHolder {
        private static final ChunkCache INSTANCE = new ChunkCache();

        private ChunkCacheHolder() {
        }
    }

    public static class ChunkCacheKey {
        private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(ChunkCacheKey.class);
        private final String filePath;
        private final TsFileID tsFileID;
        private final long offsetOfChunkHeader;
        private final boolean closed;

        public ChunkCacheKey(String filePath, TsFileID tsfileId, long offsetOfChunkHeader, boolean closed) {
            this.filePath = filePath;
            this.tsFileID = tsfileId;
            this.offsetOfChunkHeader = offsetOfChunkHeader;
            this.closed = closed;
        }

        public long getRetainedSizeInBytes() {
            return INSTANCE_SIZE;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChunkCacheKey that = (ChunkCacheKey)o;
            return Objects.equals(this.tsFileID, that.tsFileID) && this.offsetOfChunkHeader == that.offsetOfChunkHeader;
        }

        public int hashCode() {
            return Objects.hash(this.tsFileID, this.offsetOfChunkHeader);
        }

        public String toString() {
            return "ChunkCacheKey{filePath='" + this.filePath + '\'' + ", regionId=" + this.tsFileID.regionId + ", timePartitionId=" + this.tsFileID.timePartitionId + ", tsFileVersion=" + this.tsFileID.fileVersion + ", compactionVersion=" + this.tsFileID.compactionVersion + ", offsetOfChunkHeader=" + this.offsetOfChunkHeader + '}';
        }
    }

    private static class ChunkLoader
    implements Function<ChunkCacheKey, Chunk> {
        private boolean cacheMiss = false;
        private final LongConsumer ioSizeRecorder;

        private ChunkLoader(LongConsumer ioSizeRecorder) {
            this.ioSizeRecorder = ioSizeRecorder;
        }

        @Override
        public Chunk apply(ChunkCacheKey key) {
            long startTime = System.nanoTime();
            try {
                this.cacheMiss = true;
                TsFileSequenceReader reader = FileReaderManager.getInstance().get(key.getFilePath(), key.closed, this.ioSizeRecorder);
                Chunk chunk = reader.readMemChunk(key.offsetOfChunkHeader, this.ioSizeRecorder);
                chunk.getHeader().setMeasurementID(null);
                Chunk chunk2 = chunk;
                return chunk2;
            }
            catch (IOException e) {
                throw new IoTDBIORuntimeException(e);
            }
            finally {
                SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("read_chunk_file", System.nanoTime() - startTime);
            }
        }

        public boolean isCacheMiss() {
            return this.cacheMiss;
        }
    }
}

