/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.transformer.unary;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.transformation.api.LayerReader;
import org.apache.iotdb.db.queryengine.transformation.dag.transformer.unary.UnaryTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class LogicNotTransformer
extends UnaryTransformer {
    public LogicNotTransformer(LayerReader layerReader) {
        super(layerReader);
        if (this.layerReaderDataType != TSDataType.BOOLEAN) {
            throw new UnSupportedDataTypeException("Unsupported data type: " + layerReader.getDataTypes()[0].toString());
        }
    }

    @Override
    public TSDataType[] getDataTypes() {
        return new TSDataType[]{TSDataType.BOOLEAN};
    }

    @Override
    protected void transform(Column[] columns, ColumnBuilder builder) throws QueryProcessException, IOException {
        int count = columns[0].getPositionCount();
        boolean[] values = columns[0].getBooleans();
        boolean[] isNulls = columns[0].isNull();
        for (int i = 0; i < count; ++i) {
            if (!isNulls[i]) {
                boolean res = !values[i];
                builder.writeBoolean(res);
                continue;
            }
            builder.appendNull();
        }
    }
}

