/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.visitor;

import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.analyze.ExpressionTypeAnalyzer;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.ReconstructVisitor;

public class GetMeasurementExpressionVisitor
extends ReconstructVisitor<Analysis> {
    @Override
    public Expression process(Expression expression, Analysis analysis) {
        if (expression.getViewPath() != null) {
            PartialPath viewPath = expression.getViewPath();
            return new TimeSeriesOperand((PartialPath)new MeasurementPath(new PartialPath(viewPath.getMeasurement(), false), ExpressionTypeAnalyzer.analyzeExpression(analysis, expression)));
        }
        return expression.accept(this, analysis);
    }

    @Override
    public Expression visitTimeSeriesOperand(TimeSeriesOperand timeSeriesOperand, Analysis analysis) {
        MeasurementPath rawPath = (MeasurementPath)timeSeriesOperand.getPath();
        String measurementName = rawPath.isMeasurementAliasExists() ? rawPath.getMeasurementAlias() : rawPath.getMeasurement();
        MeasurementPath measurementPath = new MeasurementPath(new PartialPath(measurementName, false), rawPath.getMeasurementSchema());
        measurementPath.setTagMap(rawPath.getTagMap());
        return new TimeSeriesOperand((PartialPath)measurementPath);
    }
}

