/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.schedule.queue;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.queryengine.execution.schedule.queue.IDIndexedAccessible;
import org.apache.iotdb.db.queryengine.execution.schedule.queue.IndexedBlockingQueue;

public abstract class IndexedBlockingReserveQueue<E extends IDIndexedAccessible>
extends IndexedBlockingQueue<E> {
    private int reservedSize;

    public IndexedBlockingReserveQueue(int maxCapacity, E queryHolder) {
        super(maxCapacity, queryHolder);
    }

    @Override
    public synchronized E poll() throws InterruptedException {
        while (this.isEmpty()) {
            this.wait();
        }
        Object output = this.pollFirst();
        --this.size;
        ++this.reservedSize;
        return output;
    }

    @Override
    public synchronized void push(E element) {
        if (element == null) {
            throw new NullPointerException("pushed element is null");
        }
        Preconditions.checkState((this.size + this.reservedSize < this.capacity ? 1 : 0) != 0, (Object)"The system can't allow more query tasks.");
        this.pushToQueue(element);
        ++this.size;
        this.notifyAll();
    }

    public synchronized void repush(E element) {
        if (element == null) {
            throw new NullPointerException("pushed element is null");
        }
        this.pushToQueue(element);
        --this.reservedSize;
        ++this.size;
        this.notifyAll();
    }

    public synchronized void decreaseReservedSize() {
        --this.reservedSize;
    }
}

