/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source;

import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.source.SourceOperator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.utils.RamUsageEstimator;

public class LastCacheScanOperator
implements SourceOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(LastCacheScanOperator.class);
    private final OperatorContext operatorContext;
    private final PlanNodeId sourceId;
    private TsBlock tsBlock;

    public LastCacheScanOperator(OperatorContext operatorContext, PlanNodeId sourceId, TsBlock tsBlock) {
        this.operatorContext = operatorContext;
        this.sourceId = sourceId;
        this.tsBlock = tsBlock;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public TsBlock next() throws Exception {
        TsBlock res = this.tsBlock;
        this.tsBlock = null;
        return res;
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.tsBlock != null && !this.tsBlock.isEmpty();
    }

    @Override
    public boolean isFinished() throws Exception {
        return !this.hasNextWithTimer();
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public long calculateMaxPeekMemory() {
        return this.tsBlock.getRetainedSizeInBytes();
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.tsBlock.getRetainedSizeInBytes();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return 0L;
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.sourceId) + (this.tsBlock == null ? 0L : this.tsBlock.getRetainedSizeInBytes());
    }
}

