/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tsfile.container;

import java.io.IOException;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.datastructure.pattern.PipePattern;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.metric.overview.PipeTsFileToTabletsMetrics;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryBlock;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.filter.factory.TimeFilterApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TsFileInsertionDataContainer
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TsFileInsertionDataContainer.class);
    protected final String pipeName;
    protected final long creationTime;
    protected final PipePattern pattern;
    protected final GlobalTimeExpression timeFilterExpression;
    protected final PipeTaskMeta pipeTaskMeta;
    protected final EnrichedEvent sourceEvent;
    protected final long initialTimeNano = System.nanoTime();
    protected boolean timeUsageReported = false;
    protected final PipeMemoryBlock allocatedMemoryBlockForTablet;
    protected TsFileSequenceReader tsFileSequenceReader;

    protected TsFileInsertionDataContainer(String pipeName, long creationTime, PipePattern pattern, long startTime, long endTime, PipeTaskMeta pipeTaskMeta, EnrichedEvent sourceEvent) {
        this.pipeName = pipeName;
        this.creationTime = creationTime;
        this.pattern = pattern;
        this.timeFilterExpression = startTime == Long.MIN_VALUE && endTime == Long.MAX_VALUE ? null : new GlobalTimeExpression((Filter)TimeFilterApi.between((long)startTime, (long)endTime));
        this.pipeTaskMeta = pipeTaskMeta;
        this.sourceEvent = sourceEvent;
        this.allocatedMemoryBlockForTablet = PipeDataNodeResourceManager.memory().forceAllocateForTabletWithRetry(0L);
    }

    public abstract Iterable<TabletInsertionEvent> toTabletInsertionEvents();

    @Override
    public void close() {
        try {
            if (this.pipeName != null && !this.timeUsageReported) {
                PipeTsFileToTabletsMetrics.getInstance().recordTsFileToTabletTime(this.pipeName + "_" + this.creationTime, System.nanoTime() - this.initialTimeNano);
                this.timeUsageReported = true;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to report time usage for parsing tsfile for pipe {}", (Object)this.pipeName, (Object)e);
        }
        try {
            if (this.tsFileSequenceReader != null) {
                this.tsFileSequenceReader.close();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to close TsFileSequenceReader", (Throwable)e);
        }
        if (this.allocatedMemoryBlockForTablet != null) {
            this.allocatedMemoryBlockForTablet.close();
        }
    }
}

